/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.linter.launch;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.linter.ruleset.DVTRulesetKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;

public abstract class AbstractLintLaunchShortcut
implements ILaunchShortcut2 {
    protected static final String EMPTY_STRING = "";

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return this.getMappedConfigurations((IResource)this.getProjectFrom(this.getResourceFrom(selection)));
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return this.getMappedConfigurations((IResource)this.getProjectFrom(this.getResourceFrom(editorpart)));
    }

    public IResource getLaunchableResource(ISelection selection) {
        return this.getProjectFrom(this.getResourceFrom(selection));
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        return this.getProjectFrom(this.getResourceFrom(editorpart));
    }

    public void launch(ISelection selection, String mode) {
        IResource resource = this.getResourceFrom(selection);
        this.launch(this.getProjectForLaunchFrom(resource), resource, mode);
    }

    public void launch(IEditorPart editor, String mode) {
        IResource resource = this.getResourceFrom(editor);
        this.launch(this.getProjectForLaunchFrom(resource), resource, mode);
    }

    private IResource getResourceFrom(ISelection selection) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            return (IResource)element;
        }
        return null;
    }

    private IResource getResourceFrom(IEditorPart editorpart) {
        IEditorInput editorInput = editorpart.getEditorInput();
        if (editorInput != null) {
            return (IResource)editorInput.getAdapter(IResource.class);
        }
        return null;
    }

    private IProject getProjectFrom(IResource resource) {
        if (resource != null) {
            return resource.getProject();
        }
        return null;
    }

    private IProject getProjectForLaunchFrom(IResource resource) {
        IProject project = this.getProjectFrom(resource);
        try {
            if (project != null && project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                return project;
            }
        }
        catch (CoreException coreException) {}
        project = DVTPlugin.getSelectionManager().getLastSelectedProject();
        try {
            if (project != null && project.isAccessible() && project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                return project;
            }
        }
        catch (CoreException coreException) {}
        return Utils.selectProject(new String[]{"ro.amiq.vlogdt.VlogNature"}, "Select a project:", null, null);
    }

    public void launch(IProject project, IResource resource, String mode) {
        this.internalLaunch(project, resource, mode);
    }

    private void internalLaunch(IProject project, IResource resource, String mode) {
        try {
            ILaunchConfiguration[] launchConfigs;
            LaunchOptions result = this.getLaunchOptions(project, resource);
            ILaunchConfiguration launchableConfig = null;
            ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigs = this.getMappedConfigurations((IResource)project);
            int n = launchConfigs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration launchConfig = iLaunchConfigurationArray[n2];
                if (AbstractLintLaunchShortcut.equalConfigurations(launchConfig, (ILaunchConfiguration)result.newLaunchConfig)) {
                    launchableConfig = launchConfig;
                    break;
                }
                ++n2;
            }
            if (launchableConfig == null) {
                launchableConfig = result.newLaunchConfig.doSave();
            }
            if (result.showConfigurationDialog) {
                DebugUITools.openLaunchConfigurationDialog((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILaunchConfiguration)launchableConfig, (String)"ro.amiq.dvt.linter.launch.group", null);
            } else {
                DebugUITools.launch((ILaunchConfiguration)launchableConfig, (String)mode, (boolean)false);
            }
        }
        catch (CoreException e) {
            if (e.getMessage().startsWith("A resource already exists on disk")) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> new MessageDialog(DVTUiUtils.getActiveWorkbenchWindow().getShell(), "Resource exception", null, e.getMessage(), 1, new String[]{IDialogConstants.OK_LABEL}, 0).open());
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private ILaunchConfiguration[] getMappedConfigurations(IResource project) {
        if (project == null) {
            return new ILaunchConfiguration[0];
        }
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] existingConfigs;
            ILaunchConfiguration[] iLaunchConfigurationArray = existingConfigs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(this.getLaunchConfigurationType());
            int n = existingConfigs.length;
            int n2 = 0;
            while (n2 < n) {
                String projectName;
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                String rulesetKind = config.getAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", EMPTY_STRING);
                if (rulesetKind.equals(this.getRulesetKind().toString()) && ((projectName = config.getAttribute("ro.amiq.dvt.linter.launch.project", EMPTY_STRING)).isEmpty() || projectName.equals(project.getName()))) {
                    configs.add(config);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return configs.toArray(new ILaunchConfiguration[configs.size()]);
    }

    public static boolean equalConfigurations(ILaunchConfiguration l1, ILaunchConfiguration l2) throws CoreException {
        int l2Int;
        boolean l2Bool;
        if (l1 == null || l2 == null) {
            return l1 == null && l2 == null;
        }
        String l1String = null;
        String l2String = null;
        l1String = l1.getAttribute("ro.amiq.dvt.linter.launch.project", EMPTY_STRING);
        if (!l1String.equals(l2String = l2.getAttribute("ro.amiq.dvt.linter.launch.project", EMPTY_STRING))) {
            return false;
        }
        l1String = l1.getAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", EMPTY_STRING);
        if (!l1String.equals(l2String = l2.getAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", EMPTY_STRING))) {
            return false;
        }
        l1String = l1.getAttribute("ro.amiq.dvt.linter.launch.ruleset-file", EMPTY_STRING);
        if (!l1String.equals(l2String = l2.getAttribute("ro.amiq.dvt.linter.launch.ruleset-file", EMPTY_STRING))) {
            return false;
        }
        l1String = l1.getAttribute("ro.amiq.dvt.linter.launch.waivers-file", EMPTY_STRING);
        if (!l1String.equals(l2String = l2.getAttribute("ro.amiq.dvt.linter.launch.waivers-file", EMPTY_STRING))) {
            return false;
        }
        l1String = l1.getAttribute("ro.amiq.dvt.linter.launch.manual-checks-status-file", EMPTY_STRING);
        if (!l1String.equals(l2String = l2.getAttribute("ro.amiq.dvt.linter.launch.manual-checks-status-file", EMPTY_STRING))) {
            return false;
        }
        l1String = l1.getAttribute("ro.amiq.dvt.linter.launch.html-report-location", EMPTY_STRING);
        if (!l1String.equals(l2String = l2.getAttribute("ro.amiq.dvt.linter.launch.html-report-location", EMPTY_STRING))) {
            return false;
        }
        l1String = l1.getAttribute("ro.amiq.dvt.linter.launch.html-import-location", EMPTY_STRING);
        if (!l1String.equals(l2String = l2.getAttribute("ro.amiq.dvt.linter.launch.html-import-location", EMPTY_STRING))) {
            return false;
        }
        boolean l1Bool = l1.getAttribute("ro.amiq.dvt.linter.launch.library-ovm", false);
        if (l1Bool != (l2Bool = l2.getAttribute("ro.amiq.dvt.linter.launch.library-ovm", false))) {
            return false;
        }
        l1Bool = l1.getAttribute("ro.amiq.dvt.linter.launch.prewaive-unchanged-files", false);
        if (l1Bool != (l2Bool = l2.getAttribute("ro.amiq.dvt.linter.launch.prewaive-unchanged-files", false))) {
            return false;
        }
        l1String = l1.getAttribute("ro.amiq.dvt.linter.launch.baseline-report-location", EMPTY_STRING);
        if (!l1String.equals(l2String = l2.getAttribute("ro.amiq.dvt.linter.launch.baseline-report-location", EMPTY_STRING))) {
            return false;
        }
        l1Bool = l1.getAttribute("ro.amiq.dvt.linter.launch.include-code-html-report", false);
        if (l1Bool != (l2Bool = l2.getAttribute("ro.amiq.dvt.linter.launch.include-code-html-report", false))) {
            return false;
        }
        l1Bool = l1.getAttribute("ro.amiq.dvt.linter.launch.auto-export-html-report", false);
        if (l1Bool != (l2Bool = l2.getAttribute("ro.amiq.dvt.linter.launch.auto-export-html-report", false))) {
            return false;
        }
        l1Bool = l1.getAttribute("ro.amiq.dvt.linter.launch.auto-export-html-open-report", false);
        if (l1Bool != (l2Bool = l2.getAttribute("ro.amiq.dvt.linter.launch.auto-export-html-open-report", false))) {
            return false;
        }
        l1String = l1.getAttribute("ro.amiq.dvt.linter.launch.linting-mode", EMPTY_STRING);
        if (!l1String.equals(l2String = l2.getAttribute("ro.amiq.dvt.linter.launch.linting-mode", EMPTY_STRING))) {
            return false;
        }
        int l1Int = l1.getAttribute("ro.amiq.dvt.linter.launch.process_timeout_value", 0);
        if (l1Int != (l2Int = l2.getAttribute("ro.amiq.dvt.linter.launch.process_timeout_value", 0))) {
            return false;
        }
        l1Int = l1.getAttribute("ro.amiq.dvt.linter.launch.session_timeout_value", 0);
        if (l1Int != (l2Int = l2.getAttribute("ro.amiq.dvt.linter.launch.session_timeout_value", 0))) {
            return false;
        }
        l1Int = l1.getAttribute("ro.amiq.dvt.linter.launch.check_timeout_value", 0);
        return l1Int == (l2Int = l2.getAttribute("ro.amiq.dvt.linter.launch.check_timeout_value", 0));
    }

    protected abstract ILaunchConfigurationType getLaunchConfigurationType();

    protected abstract LaunchOptions getLaunchOptions(IProject var1, IResource var2) throws CoreException;

    protected abstract DVTRulesetKind getRulesetKind();

    protected static class LaunchOptions {
        public ILaunchConfigurationWorkingCopy newLaunchConfig;
        public boolean showConfigurationDialog;

        public LaunchOptions(ILaunchConfigurationWorkingCopy launchConfig, boolean showDialog) {
            this.newLaunchConfig = launchConfig;
            this.showConfigurationDialog = showDialog;
        }
    }
}

