/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.linter.ui;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.preferences.theme.DVTThemeUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class ALinterHTMLReportBrowser
extends EditorPart
implements IResourceChangeListener {
    private Browser fBrowser;
    private URL fURL;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            workspace.addResourceChangeListener((IResourceChangeListener)this);
        }
        URI uri = null;
        if (input instanceof FileEditorInput) {
            uri = ((FileEditorInput)input).getURI();
        } else if (input instanceof FileStoreEditorInput) {
            uri = ((FileStoreEditorInput)input).getURI();
        } else {
            throw new PartInitException((IStatus)new Status(4, "ro.amiq.dvt", "Invalid input for Linter HTML Browser Viewer"));
        }
        try {
            this.fURL = uri.toURL();
        }
        catch (MalformedURLException e1) {
            throw new PartInitException((IStatus)new Status(4, "ro.amiq.dvt", "Invalid input for Linter HTML Browser Viewer", (Throwable)e1));
        }
    }

    protected final void setEditorInfo(String title, String creationDate, String author) {
        if (title != null) {
            if (title.toLowerCase().contains("ovm compliance")) {
                this.setTitleImage(DVTImages.imageCache.getImage(DVTImages.IMG_OVM));
            } else if (title.toLowerCase().contains("uvm compliance")) {
                this.setTitleImage(DVTImages.imageCache.getImage(DVTImages.IMG_UVM));
            } else {
                this.setTitleImage(DVTImages.imageCache.getImage(DVTImages.IMG_LINTER));
            }
            this.setPartName(title);
            if (author != null && creationDate != null) {
                String toolTip = String.valueOf(title) + ", generated by " + author + " on " + creationDate;
                this.setTitleToolTip(toolTip);
            }
        }
    }

    protected final void openExternalBrowser(String location) {
        try {
            IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
            browser.openURL(new URL(location));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected static final void openFile(String filePath, int line) {
        File file = new File(filePath);
        if (file.canRead()) {
            DVTFileUtils.getInstance().openEditor(file, line);
        }
    }

    protected final void openURL() {
        if (this.fBrowser != null && !this.fBrowser.isDisposed()) {
            this.fBrowser.setUrl(String.valueOf(this.fURL.toString()) + "?internalWebBrowser=true&theme=" + (DVTThemeUtils.isDarkUI() ? "css/dark-theme.css" : "css/style.css"));
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        try {
            try {
                this.fBrowser = new Browser(parent, 0);
                this.fBrowser.addOpenWindowListener(event -> {
                    Browser browser = event.browser = this.fBrowser;
                });
            }
            catch (SWTError e) {
                DVTLogger.INSTANCE.logError((Throwable)new Exception(e));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void refresh() {
        if (this.fBrowser == null || this.fBrowser.isDisposed()) {
            return;
        }
        this.fBrowser.refresh();
    }

    public void dispose() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            workspace.removeResourceChangeListener((IResourceChangeListener)this);
        }
        if (this.fBrowser != null) {
            this.fBrowser.dispose();
        }
        super.dispose();
    }

    protected Browser getBrowser() {
        return this.fBrowser;
    }

    protected URL getURL() {
        return this.fURL;
    }

    public void setFocus() {
        this.fBrowser.setFocus();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        int type = event.getType();
        if (project.equals((Object)event.getResource()) && (type == 4 || type == 2)) {
            this.doClose();
        }
    }

    private IProject getProject() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    private void doClose() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ALinterHTMLReportBrowser.this.getSite().getPage().closeEditor((IEditorPart)ALinterHTMLReportBrowser.this, false);
            }
        });
    }
}

