/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.linter.ui;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import ro.amiq.dvt.linter.ui.ALinterHTMLReportBrowser;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.FileAcessEditorDecorator;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class LinterHTML4ReportBrowser
extends ALinterHTMLReportBrowser {
    public static final String ID = "ro.amiq.dvt.linter.ui.LinterHTML4ReportBrowser";
    private static final Pattern fTitlePattern;
    private static final Pattern fCreationDatePattern;
    private static final Pattern fAuthorPattern;

    static {
        FileAcessEditorDecorator.excludeEditor(LinterHTML4ReportBrowser.class);
        fTitlePattern = Pattern.compile("<title>(.*?)</title>");
        fCreationDatePattern = Pattern.compile("<meta name=\"Creation-Date\" content=\"(.*?)\"/>");
        fAuthorPattern = Pattern.compile("<meta name=\"Author\" content=\"(.*?)\"/>");
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        String title;
        String author;
        String creationDate;
        block9: {
            super.init(site, input);
            creationDate = null;
            author = null;
            title = null;
            BufferedReader br = null;
            try {
                try {
                    br = new BufferedReader(new InputStreamReader(this.getURL().openStream()));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        if (!line.matches("</head>")) {
                            Matcher lineMatcher = fTitlePattern.matcher(line);
                            if (lineMatcher.matches() && lineMatcher.groupCount() == 1) {
                                title = lineMatcher.group(1);
                            }
                            if ((lineMatcher = fAuthorPattern.matcher(line)).matches() && lineMatcher.groupCount() == 1) {
                                author = lineMatcher.group(1);
                            }
                            if (!(lineMatcher = fCreationDatePattern.matcher(line)).matches() || lineMatcher.groupCount() != 1) continue;
                            creationDate = lineMatcher.group(1);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    DVTLogger.INSTANCE.logError(e);
                    DVTUtilsCommon.INSTANCE.closeClosable(br);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DVTUtilsCommon.INSTANCE.closeClosable(br);
                throw throwable;
            }
            DVTUtilsCommon.INSTANCE.closeClosable(br);
        }
        this.setEditorInfo(title, creationDate, author);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Browser browser = this.getBrowser();
        if (browser != null) {
            browser.addLocationListener(new LocationListener(){

                public void changed(LocationEvent event) {
                }

                public void changing(LocationEvent event) {
                    String location = event.location;
                    if (location.startsWith("file:/") && location.contains("line=")) {
                        location = location.replaceAll("line=", "");
                        URL fileURL = null;
                        try {
                            fileURL = new URL(location);
                        }
                        catch (MalformedURLException malformedURLException) {
                            return;
                        }
                        int line = 0;
                        try {
                            line = Integer.parseInt(fileURL.getQuery());
                        }
                        catch (NumberFormatException e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return;
                        }
                        String filePath = fileURL.getPath();
                        try {
                            filePath = URLDecoder.decode(filePath, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                        LinterHTML4ReportBrowser.openFile(filePath, line);
                        event.doit = false;
                    } else if (event.location.matches("https?://.*")) {
                        LinterHTML4ReportBrowser.this.openExternalBrowser(event.location);
                        event.doit = false;
                    }
                }
            });
            this.openURL();
        }
    }
}

