/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.linter.ui;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import ro.amiq.dvt.linter.ui.ALinterHTMLReportBrowser;
import ro.amiq.dvt.linter.ui.LinterHTMLReportHandler;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.FileAcessEditorDecorator;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class LinterHTML5ReportBrowser
extends ALinterHTMLReportBrowser {
    public static final String ID = "ro.amiq.dvt.linter.ui.LinterHTML5ReportBrowser";
    static final Pattern REGEX_LINK = Pattern.compile("https?://.*");
    static final Pattern REGEX_REPORT = Pattern.compile(".*/index.html");
    static final Pattern REGEX_FILE_START = Pattern.compile("file:///.*/index.html");
    private static final Pattern INFO_PATTERN;

    static {
        FileAcessEditorDecorator.excludeEditor(LinterHTML5ReportBrowser.class);
        INFO_PATTERN = Pattern.compile("'([^']*?)'|undefined,?");
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        block17: {
            super.init(site, input);
            if (this.getURL().toString().endsWith("Ruleset_Doc.html")) {
                this.setEditorInfo("Verissimo Linter Ruleset Doc", null, null);
                return;
            }
            if (this.getURL().toString().endsWith("Verissimo_Ruleset_Editor.html")) {
                this.setEditorInfo("Verissimo Linter Ruleset Editor", null, null);
                return;
            }
            BufferedReader br = null;
            Closeable brReport = null;
            try {
                try {
                    br = new BufferedReader(new FileReader(new File(new File(this.getURL().getFile()).getParent(), "js/data0.js")));
                    StringBuilder infoLines = new StringBuilder();
                    String line = null;
                    while ((line = br.readLine()) != null && !line.contains("categories : [")) {
                        infoLines.append(line).append('\n');
                    }
                    Matcher matcher = INFO_PATTERN.matcher(infoLines);
                    String author = null;
                    String creationDate = null;
                    String title = null;
                    String projectName = "";
                    String baselineLocation = null;
                    int i = 0;
                    while (matcher.find()) {
                        switch (i) {
                            case 1: {
                                author = matcher.group(1);
                                break;
                            }
                            case 2: {
                                creationDate = matcher.group(1);
                                break;
                            }
                            case 3: {
                                title = matcher.group(1);
                                break;
                            }
                            case 4: {
                                projectName = matcher.group(1);
                                break;
                            }
                            case 21: {
                                baselineLocation = matcher.group(1);
                                break;
                            }
                        }
                        ++i;
                    }
                    if (baselineLocation != null && !baselineLocation.isEmpty() && (baselineLocation.contains("\\") || baselineLocation.contains("/"))) {
                        title = "Changes Lint Report";
                    }
                    String titleMessage = "";
                    titleMessage = projectName != null && !projectName.isEmpty() ? String.valueOf(title) + " on " + projectName : title;
                    this.setEditorInfo(titleMessage, creationDate, author);
                }
                catch (Throwable e) {
                    DVTLogger.INSTANCE.logError(e);
                    DVTUtilsCommon.INSTANCE.closeClosable(br);
                    DVTUtilsCommon.INSTANCE.closeClosable(brReport);
                    break block17;
                }
            }
            catch (Throwable throwable) {
                DVTUtilsCommon.INSTANCE.closeClosable(br);
                DVTUtilsCommon.INSTANCE.closeClosable(brReport);
                throw throwable;
            }
            DVTUtilsCommon.INSTANCE.closeClosable(br);
            DVTUtilsCommon.INSTANCE.closeClosable(brReport);
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        final Browser browser = this.getBrowser();
        if (browser != null) {
            browser.addLocationListener(new LocationListener(){

                public void changed(LocationEvent event) {
                }

                public void changing(LocationEvent event) {
                    if (REGEX_LINK.matcher(event.location).matches()) {
                        LinterHTML5ReportBrowser.this.openExternalBrowser(event.location);
                        event.doit = false;
                    } else if (REGEX_REPORT.matcher(event.location).matches()) {
                        String location = "";
                        if (REGEX_FILE_START.matcher(event.location).matches()) {
                            location = event.location.substring("file://".length());
                            location = location.substring(0, location.length() - "index.html".length());
                        }
                        LinterHTMLReportHandler.openHTMLReport(location, 0);
                        event.doit = false;
                    }
                }
            });
            browser.addProgressListener(new ProgressListener(){

                public void completed(ProgressEvent event) {
                    new OpenFileJSFunction(browser);
                }

                public void changed(ProgressEvent event) {
                }
            });
            this.openURL();
        }
    }

    private static final class OpenFileJSFunction
    extends BrowserFunction {
        public OpenFileJSFunction(Browser browser) {
            super(browser, "DVTOpenFile");
        }

        public Object function(Object[] arguments) {
            super.function(arguments);
            if (arguments == null || arguments.length < 2) {
                return null;
            }
            if (!(arguments[0] instanceof String)) {
                return null;
            }
            if (!(arguments[1] instanceof Number)) {
                return null;
            }
            ALinterHTMLReportBrowser.openFile((String)arguments[0], ((Number)arguments[1]).intValue());
            return null;
        }
    }
}

