/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.linter.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.buildconfig.BuildConfigBuilder;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigXml;
import ro.amiq.dvt.linter.launch.AbstractLintLaunchShortcut;
import ro.amiq.dvt.linter.ui.LinterHTMLReportHandlerCommon;
import ro.amiq.dvt.settings.DVTSManagedCommonTab;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.utils.Utils;

public class LinterHTMLReportHandler
extends LinterHTMLReportHandlerCommon
implements IEditorLauncher {
    private IProject project;
    public static final int HTML_BROWSER_HITS_LIMIT = 500000;

    public void open(IPath path) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            try {
                ILaunchConfiguration[] launchConfigs;
                File file = path.toFile();
                IContainer[] members = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(file.toURI());
                if (members == null || members.length == 0) {
                    this.showBuildFileErrorBlockingDialog("Error identifying selected project!");
                    return;
                }
                if (members.length != 1) {
                    StringBuilder sb = new StringBuilder();
                    String prefix = "";
                    IContainer[] iContainerArray = members;
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContainer member = iContainerArray[n2];
                        if (member.getProject() != null) {
                            sb.append(prefix);
                            prefix = ", ";
                            sb.append(member.getProject().getName());
                        }
                        ++n2;
                    }
                    this.showBuildFileErrorBlockingDialog("The selected Verissimo HTML report is located in more than one project: " + sb.toString() + ". The report must be unique before importing.");
                    return;
                }
                File reportFile = file.getParentFile();
                this.project = members[0].getProject();
                if (!this.checkBuildFile(file.getCanonicalPath(), path)) {
                    return;
                }
                ILaunchConfiguration launchableConfig = null;
                ILaunchConfigurationType lauchConfigType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("ro.amiq.dvt.linter.launch.SVLintLaunchConfiguration");
                DVTSManagedCommonTab.refreshSettingsDirectory();
                ILaunchConfigurationWorkingCopy wc = lauchConfigType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName("SV Lint"));
                DVTSManagedCommonTab.setAsShared((ILaunchConfigurationWorkingCopy)wc);
                wc.setAttribute("ro.amiq.dvt.linter.launch.project", this.project.getName());
                wc.setAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", "Import from HTML report");
                wc.setAttribute("ro.amiq.dvt.linter.launch.first-edit", true);
                wc.setAttribute("ro.amiq.dvt.linter.launch.html-import-location", reportFile.getPath());
                wc.setMappedResources(new IResource[]{this.project});
                ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigs = this.getMappedConfigurations((IResource)this.project);
                int n = launchConfigs.length;
                int n3 = 0;
                while (n3 < n) {
                    ILaunchConfiguration launchConfig = iLaunchConfigurationArray[n3];
                    if (AbstractLintLaunchShortcut.equalConfigurations(launchConfig, (ILaunchConfiguration)wc)) {
                        launchableConfig = launchConfig;
                        break;
                    }
                    ++n3;
                }
                if (launchableConfig == null) {
                    launchableConfig = wc.doSave();
                }
                DebugUITools.launch((ILaunchConfiguration)launchableConfig, (String)"ro.amiq.dvt.linter.launch.mode");
            }
            catch (CoreException e) {
                if (e.getMessage().startsWith("A resource already exists on disk")) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> new MessageDialog(DVTUiUtils.getActiveWorkbenchWindow().getShell(), "Resource exception", null, e.getMessage(), 1, new String[]{IDialogConstants.OK_LABEL}, 0).open());
                }
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
    }

    public static void openHTMLReport(String parentDir, int numberOfHits) {
        try {
            File indexFile = new File(parentDir, "index.html");
            if (!indexFile.canRead()) {
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, (String)"Linter report can't be opened!", (IStatus)new Status(4, "ro.amiq.dvt", "Can't read file " + indexFile.getAbsolutePath()));
                return;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                try {
                    if (!EclipseUtils.hasWorkingBrowser()) {
                        if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"No Internal Web Browser available!", (String)"Open Verissimo HTML Report with an External Web Browser?")) {
                            IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                            browser.openURL(new URL("file://" + indexFile.getAbsolutePath()));
                        }
                        return;
                    }
                    if (numberOfHits < 500000) {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (URI)new URL("file://" + indexFile.getAbsolutePath()).toURI(), (String)"ro.amiq.dvt.linter.ui.LinterHTML5ReportBrowser", (boolean)true);
                        return;
                    }
                    MessageDialog messageDialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "The HTML report contains more than 500k hits!", PlatformUI.getWorkbench().getDisplay().getSystemImage(8), "Please consider opening the report in an External Web Browser to avoid slowness or crashes.", 4, 2, new String[]{"Cancel", "Use Internal Browser", "Use External Browser"});
                    int open = messageDialog.open();
                    if (open == 1) {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (URI)new URL("file://" + indexFile.getAbsolutePath()).toURI(), (String)"ro.amiq.dvt.linter.ui.LinterHTML5ReportBrowser", (boolean)true);
                    } else if (open == 2) {
                        IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                        browser.openURL(new URL("file://" + indexFile.getAbsolutePath()));
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean checkBuildFile(String reportFilePath, IPath path) {
        File reportFile = new File(reportFilePath);
        IFile file = BuildConfigManager.getActiveBuildConfigIFile(this.project);
        return this.checkReport(reportFile, file, path, false);
    }

    private ILaunchConfiguration[] getMappedConfigurations(IResource project) {
        if (project == null) {
            return new ILaunchConfiguration[0];
        }
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] existingConfigs;
            ILaunchConfigurationType lauchConfigType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("ro.amiq.dvt.linter.launch.SVLintLaunchConfiguration");
            ILaunchConfiguration[] iLaunchConfigurationArray = existingConfigs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(lauchConfigType);
            int n = existingConfigs.length;
            int n2 = 0;
            while (n2 < n) {
                String projectName;
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                String rulesetKind = config.getAttribute("ro.amiq.dvt.linter.launch.ruleset-kind", "");
                if (rulesetKind.equals("Import from HTML report") && ((projectName = config.getAttribute("ro.amiq.dvt.linter.launch.project", "")).isEmpty() || projectName.equals(project.getName()))) {
                    configs.add(config);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return configs.toArray(new ILaunchConfiguration[configs.size()]);
    }

    @Override
    protected void showBuildFileErrorBlockingDialog(String errorReason) {
        int[] messageDialogExitCode = new int[]{0};
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Report error", null, errorReason, 1, new String[]{"Ok"}, 0){};
        messageDialogExitCode[0] = dialog.open();
    }

    @Override
    protected boolean showBuildFileErrorDialog(String errorReason) {
        int[] messageDialogExitCode = new int[]{0};
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Report error", null, String.valueOf(errorReason) + "\n" + "Importing the report may create undesired results.\n" + "Do you want to continue?", 2, new String[]{"Yes", "No"}, 0){};
        messageDialogExitCode[0] = dialog.open();
        return messageDialogExitCode[0] == 0;
    }

    @Override
    protected boolean isBuildConfigCompatible(String inputLine, String fullPath) {
        return inputLine.equals(fullPath);
    }

    @Override
    protected void openHTMLReportWrapper(String parentDir, int numberOfHits) {
        LinterHTMLReportHandler.openHTMLReport(parentDir, numberOfHits);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Boolean platformSpecificCheckReport(File reportFile, IFile buildConfigIFile, IPath path) {
        String inputLine = null;
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(reportFile));){
                inputLine = bufferedReader.readLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        File reportBuildConfigFile = new File(inputLine);
        String reportBuildConfigName = reportBuildConfigFile.getName();
        if (reportBuildConfigName == null || reportBuildConfigName.isEmpty()) {
            return this.showBuildFileErrorDialog("Unable to identify the Verissimo HTML report build file name.");
        }
        IContainer[] members = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(reportBuildConfigFile.toURI());
        if (members == null || members.length == 0) {
            return this.showBuildFileErrorDialog("Unable to identify the project associated with the selected Verissimo HTML report file.");
        }
        if (members.length != 1) {
            void var11_19;
            StringBuilder sb = new StringBuilder();
            String prefix = "";
            IContainer[] iContainerArray = members;
            int n = members.length;
            boolean n2 = false;
            while (var11_19 < n) {
                IContainer member = iContainerArray[var11_19];
                if (member.getProject() != null) {
                    sb.append(prefix);
                    prefix = ", ";
                    sb.append(member.getProject().getName());
                }
                ++var11_19;
            }
            return this.showBuildFileErrorDialog("The selected Verissimo HTML report is associated with a build file located in more than one project: \n " + sb.toString());
        }
        IProject buildFileProject = members[0].getProject();
        if (buildFileProject == null) {
            return this.showBuildFileErrorDialog("Unable to identify the project associated with the selected Verissimo HTML report file.");
        }
        List<Object> availableBuildConfigs = new ArrayList();
        if (!Utils.isAccessibleDVTProject(buildFileProject)) {
            return this.showBuildFileErrorDialog("Unable to access the project associated with the selected Verissimo HTML report file.");
        }
        availableBuildConfigs = BuildConfigManager.getAvailableBuildConfigs(buildFileProject);
        this.project = buildFileProject;
        int index = reportBuildConfigName.indexOf(".build");
        if (index == -1) {
            return this.showBuildFileErrorDialog("The Verissimo HTML report contains an invalid build config file name.");
        }
        reportBuildConfigName = reportBuildConfigName.substring(0, index);
        for (String string : availableBuildConfigs) {
            if (!reportBuildConfigName.equals(string)) continue;
            if (!BuildConfigXml.load(this.project).setActiveBuildConfigName(string).save()) {
                MessageDialog.openError((Shell)ro.amiq.dvt.ui.Utils.getActiveShell(), (String)"Failed to save .dvt/build.config.xml", (String)"Unable to save .dvt/build.config.xml.\nPlease check write permissions");
            }
            try {
                if (this.project != null) {
                    this.project.getFile(".dvt/build.config.xml").refreshLocal(2, null);
                }
            }
            catch (CoreException e1) {
                DVTLogger.INSTANCE.logError((Throwable)e1);
            }
            if (BuildConfigManager.updateActiveBuildConfig(this.project)) {
                BuildConfigBuilder.refreshActiveBuildConfig(this.project);
            }
            return true;
        }
        return this.showBuildFileErrorDialog("Unable to identify the project and build config file associated with the selected Verissimo HTML report.");
    }
}

