/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.linter.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;

public abstract class LinterHTMLReportHandlerCommon {
    protected Boolean checkReport(File reportFile, IFile buildConfigIFile, IPath path, boolean isFromCLI) {
        if (buildConfigIFile == null || buildConfigIFile.getLocation() == null) {
            return this.showBuildFileErrorDialog("Unable to identify the active build file for the selected project.");
        }
        String fullPath = buildConfigIFile.getLocation().toOSString();
        if (!reportFile.exists() || !reportFile.canRead()) {
            return this.showBuildFileErrorDialog("Unable to access the selected Verissimo HTML report file.");
        }
        String inputLine = null;
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(reportFile));){
                inputLine = bufferedReader.readLine();
                if (inputLine == null || inputLine.isEmpty()) {
                    return this.showBuildFileErrorDialog("This Verissimo HTML report might be generated with an older version.");
                }
                if (inputLine.equals("Merge report")) {
                    this.showBuildFileErrorBlockingDialog("Importing a Verissimo merge report is not allowed");
                    this.openHTMLReportWrapper(path.toFile().getParent(), 0);
                    return false;
                }
                if (inputLine.equals("Diff report")) {
                    this.showBuildFileErrorBlockingDialog("Importing a Verissimo diff report is not allowed");
                    this.openHTMLReportWrapper(path.toFile().getParent(), 0);
                    return false;
                }
                if (isFromCLI || this.isBuildConfigCompatible(inputLine, fullPath)) {
                    return true;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return this.platformSpecificCheckReport(reportFile, buildConfigIFile, path);
    }

    protected abstract Boolean platformSpecificCheckReport(File var1, IFile var2, IPath var3);

    protected abstract boolean isBuildConfigCompatible(String var1, String var2);

    protected abstract boolean showBuildFileErrorDialog(String var1);

    protected abstract void showBuildFileErrorBlockingDialog(String var1);

    protected abstract void openHTMLReportWrapper(String var1, int var2);
}

