/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logic.form;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.logic.form.LFConverterOptions;
import ro.amiq.dvt.logic.form.LFElementConverter;
import ro.amiq.dvt.logic.form.LFOperatorConverter;
import ro.amiq.dvt.logic.form.LogicForm;
import ro.amiq.dvt.logic.form.model.LFFormula;
import ro.amiq.dvt.logic.form.model.LFProgram;
import ro.amiq.dvt.logic.form.utils.LFNormalizeTransformation;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;

public enum LFConverter {
    INSTANCE;


    public LogicForm convertElementAndNormalize(IRfNamedElement namedElement, Predicate<IHidObject> stateVariableCheck, Set<LFConverterOptions> options, Set<HidFlatteningOption> flatteningOptions, IProgressMonitor monitor) {
        return this.convertElementAndNormalize(namedElement, stateVariableCheck, options, flatteningOptions, null, null, monitor);
    }

    public LogicForm convertElementAndNormalize(IRfNamedElement namedElement, Predicate<IHidObject> stateVariableCheck, Set<LFConverterOptions> options, Set<HidFlatteningOption> flatteningOptions, Predicate<LFProgram> failPredicate, Predicate<LFFormula> failFormula, IProgressMonitor monitor) {
        LFProgram prog = new LFElementConverter(options, stateVariableCheck, flatteningOptions, failPredicate, failFormula, monitor).convert(namedElement, new ArrayDeque<LFFormula>());
        LogicForm form = LogicForm.of(prog);
        if (form == null) {
            return null;
        }
        return form.apply(LFNormalizeTransformation.INSTANCE);
    }

    public LogicForm convertOperatorAndNormalize(IHidOperator operator, IRfNamedElement enclosingScope, Set<LFConverterOptions> options, Set<HidFlatteningOption> flatteningOptions, String filePath, IProgressMonitor monitor) {
        List<LFProgram> progs = new LFOperatorConverter(options, flatteningOptions, GoToInfo.sourceSupplierFor(filePath, ((HidOperator)operator).getLanguageKind()), monitor).convert(operator, enclosingScope);
        if (progs == null || progs.isEmpty()) {
            return null;
        }
        return LogicForm.of(progs).apply(LFNormalizeTransformation.INSTANCE);
    }

    public LogicForm convertOperatorAndNormalize(LFOperatorConverter converter, IHidOperator operator, IRfNamedElement scope) {
        LogicForm logicForm = this.convertOperator(converter, operator, scope);
        if (logicForm == null) {
            return null;
        }
        return logicForm.apply(LFNormalizeTransformation.INSTANCE);
    }

    private LogicForm convertOperator(LFOperatorConverter converter, IHidOperator operator, IRfNamedElement scope) {
        if (converter == null) {
            return null;
        }
        List<LFProgram> progs = converter.convert(operator, scope);
        if (progs == null || progs.isEmpty()) {
            return null;
        }
        return LogicForm.of(progs);
    }

    public LogicForm convertOperatorsAndNormalize(LFOperatorConverter converter, List<HidOperator> operators, IRfNamedElement scope) {
        LogicForm logicForm = this.convertOperator(converter, operators, scope);
        if (logicForm == null) {
            return null;
        }
        return logicForm.apply(LFNormalizeTransformation.INSTANCE);
    }

    private LogicForm convertOperator(LFOperatorConverter converter, List<HidOperator> operators, IRfNamedElement scope) {
        if (converter == null || operators == null || operators.isEmpty()) {
            return null;
        }
        ArrayList<LFProgram> allProgs = new ArrayList<LFProgram>(operators.size());
        for (IHidOperator iHidOperator : operators) {
            List<LFProgram> progs = converter.convert(iHidOperator, scope);
            if (progs == null || progs.isEmpty()) continue;
            allProgs.addAll(progs);
        }
        return LogicForm.of(allProgs);
    }
}

