/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logic.form;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.fsm.model.FSMState;
import ro.amiq.dvt.logic.form.LFConverterOptions;
import ro.amiq.dvt.logic.form.LFOperatorConverter;
import ro.amiq.dvt.logic.form.model.LFFormula;
import ro.amiq.dvt.logic.form.model.LFProgram;
import ro.amiq.dvt.logic.form.utils.LFUtils;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;

public class LFElementConverter {
    private static final long CASE_ITEM_BLOCK_QUALIFIER = IRfActionBlockElement.BlockQualifier.CASE_ITEM.value() | IRfActionBlockElement.BlockQualifier.RANDCASE_ITEM.value();
    private static final long LOOP_BLOCK_QUALIFIER = IRfActionBlockElement.BlockQualifier.FOR.value() | IRfActionBlockElement.BlockQualifier.FOREACH.value() | IRfActionBlockElement.BlockQualifier.FOREVER.value() | IRfActionBlockElement.BlockQualifier.WHILE.value() | IRfActionBlockElement.BlockQualifier.REPEAT.value() | IRfActionBlockElement.BlockQualifier.DO.value();
    private static final HidOperatorQualifier[] IS_CONDITIONAL_EXPRESSION = new HidOperatorQualifier[]{HidOperatorQualifier.IS_CONDITIONAL_EXPRESSION};
    private static final HidOperatorQualifier[] IS_CASE_ITEM_EXPRESSION = new HidOperatorQualifier[]{HidOperatorQualifier.IS_CASE_ITEM_EXPRESSION};
    private static final HidOperatorQualifier[] IS_LOOP_EXPRESSION = new HidOperatorQualifier[]{HidOperatorQualifier.IS_LOOP_EXPRESSION};
    private static final long IS_FORK_BLOCK_QUALIFIER = IRfActionBlockElement.BlockQualifier.FORK_JOIN.value() + IRfActionBlockElement.BlockQualifier.FORK_JOIN_ANY.value() + IRfActionBlockElement.BlockQualifier.FORK_JOIN_NONE.value();
    private Set<LFConverterOptions> options;
    private Set<HidFlatteningOption> flatteningOptions;
    private Predicate<LFProgram> failPredicate;
    private Predicate<LFFormula> failFormula;
    private Predicate<IHidObject> stateVariableCheck;
    private LFInternalFailProgressMonitor monitor;

    protected LFElementConverter(Set<LFConverterOptions> options, Predicate<IHidObject> stateVariableCheck, Set<HidFlatteningOption> flatteningOptions, Predicate<LFProgram> failPredicate, Predicate<LFFormula> failFormula, IProgressMonitor monitor) {
        this.options = options;
        this.flatteningOptions = flatteningOptions;
        this.failPredicate = failPredicate;
        this.failFormula = failFormula;
        this.stateVariableCheck = stateVariableCheck;
        this.monitor = new LFInternalFailProgressMonitor(monitor);
    }

    public LFProgram convert(IRfNamedElement namedElement, ArrayDeque<LFFormula> ifConditions) {
        LFProgram conj;
        LFFormula condition;
        if (this.monitor.isCanceled()) {
            return null;
        }
        if (!LFElementConverter.isValidScope(namedElement)) {
            return null;
        }
        ArrayList<LFProgram> progs = new ArrayList<LFProgram>();
        LFFormula lFFormula = condition = namedElement instanceof IRfActionBlockElement ? this.extractActionBlockCondition((IRfActionBlockElement)namedElement, ifConditions) : null;
        if (this.monitor.isCanceled()) {
            return null;
        }
        this.visitHidHolder(namedElement, progs);
        this.visitMembers(namedElement, progs);
        if (this.monitor.isCanceled()) {
            return null;
        }
        if (progs.size() > 1) {
            Collections.sort(progs, new Comparator<LFProgram>(){

                @Override
                public int compare(LFProgram o1, LFProgram o2) {
                    GoToInfo marker1 = o1.getMarker();
                    GoToInfo marker2 = o2.getMarker();
                    if (marker1 == null && marker2 == null) {
                        return 0;
                    }
                    if (marker1 == null) {
                        return -1;
                    }
                    if (marker2 == null) {
                        return 1;
                    }
                    return marker1.offset - marker2.offset;
                }
            });
        }
        if (this.monitor.isCanceled()) {
            return null;
        }
        LFProgram lFProgram = conj = namedElement instanceof IRfActionBlockElement && ((IRfActionBlockElement)namedElement).hasBlockQualifier(IS_FORK_BLOCK_QUALIFIER) ? LFUtils.makeParallel(progs) : LFUtils.makeSequence(progs);
        if (conj == null) {
            conj = LFProgram.CONTINUE;
        }
        return condition != null ? condition.imply(conj) : conj;
    }

    private void visitMembers(IRfNamedElement namedElement, List<LFProgram> progs) {
        if (this.monitor.isCanceled()) {
            return;
        }
        Collection<? extends IRfNamedElement> members = namedElement.getMembers(true, true);
        if (members == null || members.isEmpty()) {
            return;
        }
        ArrayDeque<LFFormula> ifConditions = new ArrayDeque<LFFormula>();
        for (IRfNamedElement iRfNamedElement : members) {
            if (this.monitor.isCanceled()) {
                return;
            }
            LFProgram prog = this.convert(iRfNamedElement, ifConditions);
            if (prog == null) continue;
            progs.add(prog);
        }
    }

    private void visitHidHolder(IRfNamedElement namedElement, List<LFProgram> progs) {
        if (this.monitor.isCanceled()) {
            return;
        }
        if (!LFElementConverter.isValidScope(namedElement)) {
            return;
        }
        IHidHolder ownHidHolder = namedElement.getHidHolder();
        if (ownHidHolder == null) {
            return;
        }
        ownHidHolder.visitHidObject(null, new LFOperatorConverterVisitor(progs, this.options, this.flatteningOptions, this.failPredicate, this.monitor));
    }

    private static boolean isValidScope(IRfNamedElement namedElement) {
        return namedElement instanceof IRfActionBlockElement || namedElement instanceof IRfMethodElement || DesignUtils.getDesignKind(namedElement) != IRfNamedElement.ElementKind.UNKNOWN;
    }

    private LFFormula extractActionBlockCondition(IRfActionBlockElement actionBlock, ArrayDeque<LFFormula> ifConditions) {
        List<IHidOperator> operators;
        IRfDefElement defElem = actionBlock.getDeclaration();
        IRfFileDef defFile = defElem != null ? defElem.getDefFile() : null;
        ParserPath parserPath = defFile != null ? defFile.getParserPath() : null;
        String filePath = parserPath != null ? parserPath.path : null;
        LanguageKind languageKind = actionBlock.getLanguageKind();
        if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.IF) && (operators = actionBlock.getHidOperators(IS_CONDITIONAL_EXPRESSION, true)) != null && !operators.isEmpty()) {
            IHidOperator operator = operators.get(0);
            HidOperatorOccurrence occurrence = operator.getOccurrence();
            GoToInfo marker = GoToInfo.of(filePath, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), "", languageKind);
            LFFormula condition = LFFormula.f(operator, marker);
            if (this.failFormula != null && this.failFormula.test(condition)) {
                this.monitor.setHasFailed(true);
                return null;
            }
            ifConditions.addLast(condition);
            return condition;
        }
        if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ELSIF)) {
            LFFormula notPrevCondition;
            LFFormula prevCondition = ifConditions.pollLast();
            if (prevCondition == null) {
                return null;
            }
            GoToInfo prevConditionMarker = prevCondition.getMarker();
            if (prevConditionMarker == null) {
                prevConditionMarker = GoToInfo.sourceOf(actionBlock);
                if (!this.options.contains((Object)LFConverterOptions.ELSE_MARKER_ON_IF_CONDITION)) {
                    prevConditionMarker.endLine = prevConditionMarker.line;
                }
            }
            if (prevCondition instanceof LFFormula.LFAndFormula) {
                List<LFFormula> prevConditions = ((LFFormula.LFAndFormula)prevCondition).getExpr();
                notPrevCondition = LFUtils.andFormulas(prevConditions.subList(0, prevConditions.size() - 1));
                LFFormula not = prevConditions.get(prevConditions.size() - 1).not();
                not.setMarker(prevConditionMarker);
                notPrevCondition = notPrevCondition.and(not);
            } else {
                LFFormula not = prevCondition.not();
                not.setMarker(prevConditionMarker);
                notPrevCondition = not;
            }
            List<IHidOperator> operators2 = actionBlock.getHidOperators(IS_CONDITIONAL_EXPRESSION, true);
            if (operators2 != null && !operators2.isEmpty()) {
                IHidOperator operator = operators2.get(0);
                HidOperatorOccurrence occurrence = operator.getOccurrence();
                GoToInfo marker = GoToInfo.of(filePath, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), "", languageKind);
                LFFormula newCondition = LFFormula.f(operator, marker);
                if (this.failFormula != null && this.failFormula.test(newCondition)) {
                    this.monitor.setHasFailed(true);
                    return null;
                }
                newCondition = notPrevCondition.and(newCondition);
                ifConditions.addLast(newCondition);
                return newCondition;
            }
            return notPrevCondition;
        }
        if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ELSE)) {
            LFFormula result;
            LFFormula condition = ifConditions.pollLast();
            if (condition == null) {
                return null;
            }
            GoToInfo marker = GoToInfo.sourceOf(actionBlock);
            if (marker != null && !this.options.contains((Object)LFConverterOptions.ELSE_MARKER_ON_IF_CONDITION)) {
                marker.endLine = marker.line;
            } else {
                marker = condition.getMarker();
            }
            if (condition instanceof LFFormula.LFAndFormula) {
                List<LFFormula> prevConditions = ((LFFormula.LFAndFormula)condition).getExpr();
                result = LFUtils.andFormulas(prevConditions.subList(0, prevConditions.size() - 1));
                LFFormula not = prevConditions.get(prevConditions.size() - 1).not();
                not.setMarker(marker);
                result = result.and(not);
            } else {
                LFFormula not = condition.not();
                not.setMarker(marker);
                result = not;
            }
            return result;
        }
        if (actionBlock.hasBlockQualifier(CASE_ITEM_BLOCK_QUALIFIER) && (operators = actionBlock.getHidOperators(IS_CASE_ITEM_EXPRESSION, true)) != null && !operators.isEmpty()) {
            boolean containsStateVariable;
            IHidOperator operator = operators.get(0);
            HidOperatorOccurrence occurrence = operator.getOccurrence();
            GoToInfo marker = GoToInfo.of(filePath, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), "", languageKind);
            LFFormula condition = null;
            boolean isConcatenation = operator.getLHValue() instanceof IHidOperator ? ((IHidOperator)operator.getLHValue()).hasOccurrence(HidQualifierCache.IS_CONCATENATION_QUALIFIER) : false;
            boolean bl = containsStateVariable = this.stateVariableCheck != null && this.stateVariableCheck.test(operator.getLHValue());
            if (isConcatenation && containsStateVariable) {
                List<IHidOperator> subOperators = LFElementConverter.transformConcatenationOperator(operator, this.stateVariableCheck);
                if (subOperators != null) {
                    for (IHidOperator subOperator : subOperators) {
                        condition = condition != null ? LFFormula.f(subOperator, marker).and(condition) : LFFormula.f(subOperator, marker);
                    }
                } else {
                    condition = LFFormula.f(operator, marker);
                }
            } else {
                condition = LFFormula.f(operator, marker);
            }
            if (this.failFormula != null && this.failFormula.test(condition)) {
                this.monitor.setHasFailed(true);
                return null;
            }
            return condition;
        }
        if (actionBlock.hasBlockQualifier(LOOP_BLOCK_QUALIFIER) && (operators = actionBlock.getHidOperators(IS_LOOP_EXPRESSION, true)) != null && !operators.isEmpty()) {
            IHidOperator operator = operators.get(0);
            HidOperatorOccurrence occurrence = operator.getOccurrence();
            GoToInfo marker = GoToInfo.of(filePath, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), "", languageKind);
            LFFormula condition = LFFormula.f(operator, marker);
            if (this.failFormula != null && this.failFormula.test(condition)) {
                this.monitor.setHasFailed(true);
                return null;
            }
            return condition;
        }
        return null;
    }

    public static List<IHidOperator> transformConcatenationOperator(IHidOperator operator, Predicate<IHidObject> stateVariableCheck) {
        ArrayList<HidImplicit> reusableHids;
        boolean isConcatenation;
        boolean bl = isConcatenation = operator.getLHValue() instanceof IHidOperator ? ((IHidOperator)operator.getLHValue()).hasOccurrence(HidQualifierCache.IS_CONCATENATION_QUALIFIER) : false;
        if (!isConcatenation) {
            return null;
        }
        ListContainer<IHidObject> lhValues = ((IHidOperator)operator.getLHValue()).getRHValues();
        ListContainer<IHidObject> rhValues = operator.getRHValues();
        String rhValueBinText = LFElementConverter.toBinaryString(rhValues, reusableHids = new ArrayList<HidImplicit>());
        if (rhValueBinText == null) {
            return null;
        }
        int lsb = 0;
        int msb = 0;
        ArrayList<IHidOperator> result = new ArrayList<IHidOperator>(lhValues.size());
        int i = 0;
        while (i < lhValues.size()) {
            IHidObject hidObject = lhValues.get(i);
            int nofBits = HidUtils.nofBits(hidObject, false);
            if (nofBits <= 0) {
                return null;
            }
            msb = nofBits - 1 + lsb;
            HidImplicit implicitValue = LFElementConverter.extractImplicit(msb, lsb, rhValueBinText);
            lsb = msb + 1;
            if (implicitValue != null) {
                HidImplicit tempValue = null;
                for (HidImplicit reusableHid : reusableHids) {
                    if (!reusableHid.getName().equals(implicitValue.getName())) continue;
                    if (tempValue != null) {
                        tempValue = null;
                        break;
                    }
                    tempValue = reusableHid;
                }
                HidImplicit hidImplicit = implicitValue = tempValue == null ? implicitValue : tempValue;
                if (stateVariableCheck.test(hidObject) || FSMState.ANY_STATE_IMPLICIT != implicitValue) {
                    HidOperator tempOperator = HidUtils.makeStandInOperator(hidObject, Collections.singletonList(implicitValue), IHidOperatorConstants.OperatorType.QUA_EQUALITY.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "==", operator.getOccurrence(), 0L);
                    result.add(tempOperator);
                }
            }
            ++i;
        }
        return result;
    }

    private static String toBinaryString(ListContainer<IHidObject> values, List<HidImplicit> reusableHids) {
        if (values.size() != 1) {
            return null;
        }
        IHidObject value = values.get(0);
        if (value instanceof HidImplicit) {
            String valueBinText = ((HidImplicit)value).getName();
            int index = valueBinText.indexOf("'b");
            if (index < 0) {
                return null;
            }
            reusableHids.add((HidImplicit)value);
            return valueBinText.substring(index + 2).replace("_", "");
        }
        if (value instanceof HidOperator && ((HidOperator)value).hasOccurrence(HidQualifierCache.IS_CONCATENATION_QUALIFIER)) {
            ListContainer<IHidObject> subOperators = ((HidOperator)value.get(0)).getRHValues();
            StringBuilder valueBinText = new StringBuilder();
            int i = subOperators.size() - 1;
            while (i >= 0) {
                IHidObject subOperator = subOperators.get(i);
                String valueChunkBinText = LFElementConverter.toBinaryString(subOperator, reusableHids);
                if (valueChunkBinText == null) {
                    return null;
                }
                valueBinText.append(valueChunkBinText);
                --i;
            }
            return valueBinText.toString();
        }
        return null;
    }

    public static HidImplicit extractImplicit(int msb, int lsb, String binText) {
        StringBuilder binTextPad = new StringBuilder();
        int i = binText.length();
        while (i < msb + 1) {
            binTextPad.append("0");
            ++i;
        }
        binTextPad.append(binText);
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(msb - lsb + 1)).append("'b");
        int start = binTextPad.length() - msb - 1;
        int end = binTextPad.length() - lsb;
        String substring = binTextPad.substring(start, end);
        int i2 = 0;
        while (i2 < substring.length()) {
            if (substring.charAt(i2) != '?') {
                sb.append(substring);
                return HidUtils.makeStandInImplicit(sb.toString(), IHidImplicitConstants.ImplicitType.QUA_NUMBER.id);
            }
            ++i2;
        }
        return substring == null || substring.isEmpty() ? null : FSMState.ANY_STATE_IMPLICIT;
    }

    private static class LFInternalFailProgressMonitor
    extends ProgressMonitorWrapper {
        private boolean hasFailed = false;

        private LFInternalFailProgressMonitor(IProgressMonitor monitor) {
            super((IProgressMonitor)(monitor != null ? monitor : new NullProgressMonitor()));
        }

        public void setHasFailed(boolean hasFailed) {
            this.hasFailed = hasFailed;
        }

        public boolean isCanceled() {
            return this.hasFailed || super.isCanceled();
        }
    }

    private static class LFOperatorConverterVisitor
    implements IHidVisitor<IHidOperator> {
        private IRfNamedElement scope;
        private LanguageKind languageKind;
        private String filePath;
        private List<LFProgram> collected;
        private LFOperatorConverter converter;
        private Set<LFConverterOptions> options;
        private Set<HidFlatteningOption> flatteningOptions;
        private Predicate<LFProgram> failPredicate;
        private LFInternalFailProgressMonitor monitor;

        public LFOperatorConverterVisitor(List<LFProgram> collected, Set<LFConverterOptions> options, Set<HidFlatteningOption> flatteningOptions, Predicate<LFProgram> failPredicate, LFInternalFailProgressMonitor monitor) {
            this.collected = collected;
            this.options = options != null ? options : LFConverterOptions.EMPTY_SET;
            this.flatteningOptions = flatteningOptions != null ? flatteningOptions : HidFlatteningOption.NONE_EXCLUDED;
            this.failPredicate = failPredicate;
            this.monitor = monitor;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            this.scope = ((HidHolder)holder).getScope();
            this.languageKind = this.scope.getLanguageKind();
        }

        @Override
        public void setParserPath(ParserPath parserPath) {
            this.filePath = parserPath.path;
            this.converter = new LFOperatorConverter(this.options, this.flatteningOptions, GoToInfo.sourceSupplierFor(this.filePath, this.languageKind), (IProgressMonitor)this.monitor);
        }

        @Override
        public boolean visit(IHidOperator operator) {
            if (this.monitor.isCanceled()) {
                return false;
            }
            List<LFProgram> progs = this.converter.convert(operator, this.scope);
            if (progs == null || progs.isEmpty()) {
                return true;
            }
            if (this.failPredicate != null) {
                for (LFProgram prog : progs) {
                    if (!this.failPredicate.test(prog)) continue;
                    this.monitor.setHasFailed(true);
                    return false;
                }
            }
            this.collected.add(LFUtils.makeSequence(progs));
            return true;
        }

        @Override
        public Class<IHidOperator> getType() {
            return IHidOperator.class;
        }
    }
}

