/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logic.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.logic.form.LFConverterOptions;
import ro.amiq.dvt.logic.form.model.LFFanIn;
import ro.amiq.dvt.logic.form.model.LFFormula;
import ro.amiq.dvt.logic.form.model.LFProgram;
import ro.amiq.dvt.logic.form.utils.LFUtils;
import ro.amiq.dvt.model.reflection.DummyField;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISContext;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.OptimizedUtils;

public class LFOperatorConverter {
    private Set<LFConverterOptions> options;
    private Set<HidFlatteningOption> flatteningOptions;
    private Set<HidFlatteningOption> flatteningOptionsNoSelects;
    private GoToInfo.GoToInfoSupplier goToInfoSupplier;
    private IProgressMonitor monitor;

    public LFOperatorConverter(Set<LFConverterOptions> options, Set<HidFlatteningOption> flatteningOptions, GoToInfo.GoToInfoSupplier goToInfoSupplier, IProgressMonitor monitor) {
        this.options = options;
        this.flatteningOptions = flatteningOptions;
        this.flatteningOptionsNoSelects = LFOperatorConverter.makeFlatteningOptionsNoSelects(flatteningOptions);
        this.goToInfoSupplier = goToInfoSupplier;
        this.monitor = monitor != null ? monitor : new NullProgressMonitor();
    }

    public final List<LFProgram> convert(IHidOperator operator, IRfNamedElement scope) {
        if (this.monitor.isCanceled()) {
            return null;
        }
        List<LFProgram> progs = this.convertOperator(operator, scope);
        if (this.monitor.isCanceled()) {
            return null;
        }
        return progs;
    }

    private static final Set<HidFlatteningOption> makeFlatteningOptionsNoSelects(Set<HidFlatteningOption> options) {
        if (!options.contains((Object)HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS)) {
            EnumSet<HidFlatteningOption> optionsNoSelects = options.isEmpty() ? EnumSet.noneOf(HidFlatteningOption.class) : EnumSet.copyOf(options);
            optionsNoSelects.add(HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS);
            return optionsNoSelects;
        }
        return options;
    }

    @NotNull
    private List<LFProgram> convertOperator(IHidOperator operator, IRfNamedElement scope) {
        if (operator == null) {
            return Collections.emptyList();
        }
        if (operator.hasOccurrence(HidQualifierCache.IS_EVENT_CONTROL_QUALIFIER)) {
            return this.convertEventControlOperator(operator);
        }
        if (operator.hasOccurrence(HidQualifierCache.ALL_DECLARATION_QUALIFIERS) && !this.options.contains((Object)LFConverterOptions.IGNORE_DECLARATIONS)) {
            return this.convertDeclarationOperator(operator, scope);
        }
        if (operator.hasOccurrence(HidQualifierCache.ALL_BLOCKING_ASSIGN_QUALIFIERS) && !this.options.contains((Object)LFConverterOptions.IGNORE_BLOCKING_ASSIGNMENTS)) {
            return this.convertAssignmentOperator(operator, scope);
        }
        if (operator.hasOccurrence(HidQualifierCache.IS_NONBLOCKING_ASSIGN_QUALIFIER) && (operator.getLanguageKind() != LanguageKind.VLOG || !this.options.contains((Object)LFConverterOptions.IGNORE_NON_BLOCKING_ASSIGNMENTS))) {
            return this.convertAssignmentOperator(operator, scope);
        }
        if (operator.hasOccurrence(HidQualifierCache.IS_ASSOCIATION_QUALIFIER) && !operator.hasOccurrence(HidQualifierCache.IS_ARGUMENT_VALUE_QUALIFIER) && !this.options.contains((Object)LFConverterOptions.IGNORE_ASSOCIATIONS) && !operator.hasOccurrence(HidQualifierCache.IS_PATTERN_VALUE_QUALIFIER)) {
            return this.convertAssignmentOperator(operator, scope);
        }
        if (operator.hasOccurrence(HidQualifierCache.IS_ALIAS_QUALIFIER) && !this.options.contains((Object)LFConverterOptions.IGNORE_ALIASES)) {
            return this.convertAliasOperator(operator, scope);
        }
        if (operator.hasOccurrence(HidQualifierCache.ALL_BLOCKING_SELECT_ASSIGN_QUALIFIERS) && !this.options.contains((Object)LFConverterOptions.IGNORE_BLOCKING_ASSIGNMENTS)) {
            return this.convertSelectAssignmentOperator(operator, scope);
        }
        if (operator.hasOccurrence(HidQualifierCache.IS_NONBLOCKING_SELECT_ASSIGN_QUALIFIER)) {
            return this.convertSelectAssignmentOperator(operator, scope);
        }
        return Collections.emptyList();
    }

    private List<LFProgram> convertEventControlOperator(IHidOperator operator) {
        boolean hasClocks;
        if (operator.getOperatorKind() == IHidOperatorConstants.OperatorKind.TERNARY_OPERATOR) {
            return Collections.emptyList();
        }
        LinkedHashSet<IHid> clocks = new LinkedHashSet<IHid>();
        DesignUtils.collectVLOGClockEventHids(operator, clocks, true);
        if (clocks.isEmpty()) {
            DesignUtils.collectVHDLClockEventHids(operator, clocks, true);
        }
        boolean bl = hasClocks = !clocks.isEmpty();
        if (!hasClocks && this.options.contains((Object)LFConverterOptions.IGNORE_COMBINATIONAL_EVENT_CONTROLS) || hasClocks && this.options.contains((Object)LFConverterOptions.IGNORE_SEQUENTIAL_EVENT_CONTROLS)) {
            return Collections.emptyList();
        }
        GoToInfo marker = this.goToInfoSupplier.get(operator.getOccurrence(), "");
        LFFormula ec = LFFormula.f(operator, marker);
        LFProgram.LFImplication prog = ec.imply(hasClocks ? LFProgram.BREAK : LFProgram.CONTINUE);
        return Collections.singletonList(prog);
    }

    private List<LFProgram> convertDeclarationOperator(IHidOperator operator, IRfNamedElement declarationScope) {
        GoToInfo marker = this.goToInfoSupplier.get(operator.getOccurrence(), "");
        ArrayList<IHid> lhHids = new ArrayList<IHid>(4);
        Predicate<IHidObject> lhSide = hidObject -> {
            IRfNamedElement resolvedElement;
            IHid hid = HidUtils.getHidFrom(hidObject);
            if (HidUtils.isHidImplicit(hid) && ((IHidImplicit)hid).isID() && declarationScope != null && (resolvedElement = declarationScope.semanticGetMember(hid.getName(), hid, declarationScope != null && declarationScope.getDeclaration() != null ? declarationScope.getDeclaration().getParserPath() : null, declarationScope, null, true, true, false)) != null) {
                hid = HidUtils.DEFAULT_BUILDERS.buildHid(resolvedElement.getName(), resolvedElement, new HidOccurrence(-1, -1, -1, HidQualifierCache.FORMAL_PART_QUALIFIER, null), HidQualifierCache.FORMAL_PART_QUALIFIER);
            }
            if (hid != null) {
                lhHids.add(hid);
            }
            return true;
        };
        HidUtils.flattenToObjects(lhSide, operator.getLHValue(), this.flatteningOptions);
        ArrayList<LFProgram> progs = new ArrayList<LFProgram>(lhHids.size());
        this.internalConvertAssignmentRHSide(lhHids, OptimizedUtils.asList(operator.getRHValues(), false), Collections.emptyList(), declarationScope, marker, progs);
        return progs;
    }

    private void internalConvertAssignmentRHSide(Collection<IHid> lhHids, Collection<IHidObject> rhSideObjects, Collection<IHid> lhDrivers, IRfNamedElement declarationScope, GoToInfo marker, Collection<LFProgram> result) {
        if (lhHids == null || lhHids.isEmpty()) {
            return;
        }
        ArrayList<IHid> collectedDrivers = new ArrayList<IHid>(4);
        ArrayList<LFProgram> collectedAssociations = new ArrayList<LFProgram>(2);
        AtomicBoolean isObjectAssignmentPattern = new AtomicBoolean(false);
        Predicate<IHidObject> rhSide = hidObject -> {
            if (HidUtils.isOperator(hidObject) && (((HidOperator)hidObject).isAssignmentPattern() || ((HidOperator)hidObject).isAggregate())) {
                isObjectAssignmentPattern.set(true);
                for (IHid correspondentHid : lhHids) {
                    HidOperator newAssignPattern;
                    LFAssignmentContext context = LFOperatorConverter.makeAssignmentPatternContext(correspondentHid = LFOperatorConverter.makeLHSideHid(correspondentHid));
                    if (context == null || (newAssignPattern = HidUtils.transformAssignmentPattern((HidOperator)hidObject, context, declarationScope, false, HidUtils.DEFAULT_BUILDERS)) == null || newAssignPattern == hidObject) continue;
                    ListContainer<IHidObject> associationOperators = newAssignPattern.getRHValues();
                    for (IHidObject operator : associationOperators) {
                        if (!HidUtils.isOperator(operator) || !((HidOperator)operator).hasOccurrence(HidQualifierCache.IS_PATTERN_VALUE_QUALIFIER)) continue;
                        HidOperator association = (HidOperator)operator;
                        this.internalConvertBinaryOperator(association.getLHValue(), OptimizedUtils.asList(association.getRHValues(), false), false, declarationScope, marker, collectedAssociations);
                    }
                }
                return false;
            }
            IHid hid = HidUtils.getHidFrom(hidObject);
            if (hid != null) {
                collectedDrivers.add(hid);
            }
            return true;
        };
        HidUtils.flattenToObjects(rhSide, rhSideObjects, this.flatteningOptions);
        if (!collectedAssociations.isEmpty()) {
            int lhSize = lhHids.size();
            LFProgram implied = LFUtils.makeSequence(collectedAssociations);
            int i = 0;
            while (i < lhSize) {
                LFProgram.LFImplication prog = LFUtils.makeImplication(LFFormula.EMPTY, implied);
                this.addProg(prog, result);
                ++i;
            }
        }
        if (lhDrivers != null && !lhDrivers.isEmpty()) {
            for (IHid lhDriver : lhDrivers) {
                if (lhDriver instanceof HidImplicit) continue;
                collectedDrivers.add(lhDriver);
            }
        }
        if (isObjectAssignmentPattern.get() && this.options != null && this.options.contains((Object)LFConverterOptions.IGNORE_NULL_DRIVERS_ASSOCIATIONS_IN_ASSIGNMENT_PATTERNS) && collectedDrivers.isEmpty()) {
            return;
        }
        for (IHid written : lhHids) {
            LFFanIn fan = LFFanIn.of(written);
            if (fan == null) continue;
            fan.addAllToBorder(collectedDrivers);
            fan.setMarker(marker);
            this.addProg(LFProgram.p(fan), result);
        }
    }

    private static Hid makeLHSideHid(IHid hid) {
        return HidUtils.isHid(hid) ? ((Hid)hid).upwardsCopy(true) : null;
    }

    private static LFAssignmentContext makeAssignmentPatternContext(IHid lhHid) {
        IRfNamedElement assoc;
        IRfNamedElement element = HidUtils.getResolvedElement(lhHid);
        IRfNamedElement iRfNamedElement = assoc = element instanceof IRfAssociatedTypeElement ? ((IRfAssociatedTypeElement)element).getResolvedType(true) : null;
        if (assoc instanceof IRfTypeAliasElement) {
            assoc = ((IRfTypeAliasElement)assoc).getTranslatedType();
        }
        LFAssignmentContext context = LFAssignmentContext.of(assoc, (Hid)lhHid);
        return context;
    }

    private List<LFProgram> convertSelectAssignmentOperator(IHidOperator operator, IRfNamedElement declarationScope) {
        GoToInfo marker = this.goToInfoSupplier.get(operator.getOccurrence(), "");
        ArrayList<LFProgram> progs = new ArrayList<LFProgram>();
        LFFormula expression = LFFormula.f(operator.getLHValue(), marker);
        ListContainer<IHidObject> rhValues = operator.getRHValues();
        if (rhValues.size() == 1) {
            LFProgram conj;
            IHidObject rfHidObject = rhValues.get(0);
            if (HidUtils.isOperator(rfHidObject)) {
                IHidOperator assignment = (IHidOperator)rfHidObject;
                this.internalConvertBinaryOperator(assignment.getLHValue(), OptimizedUtils.asList(assignment.getRHValues(), false), true, declarationScope, marker, progs);
            }
            if ((conj = LFUtils.makeSequence(progs)) != null) {
                return Collections.singletonList(expression.imply(conj));
            }
        }
        return progs;
    }

    private List<LFProgram> convertAliasOperator(IHidOperator operator, IRfNamedElement declarationScope) {
        GoToInfo marker = this.goToInfoSupplier.get(operator.getOccurrence(), "");
        List<IHidObject> aValues = OptimizedUtils.asList(operator.getRHValues(), false);
        ArrayList<LFProgram> progs = new ArrayList<LFProgram>();
        for (IHidObject aValue : aValues) {
            ArrayList<IHidObject> other = new ArrayList<IHidObject>(aValues);
            other.remove(aValue);
            this.internalConvertBinaryOperator(aValue, other, false, declarationScope, marker, progs);
        }
        return progs;
    }

    private List<LFProgram> convertAssignmentOperator(IHidOperator operator, IRfNamedElement declarationScope) {
        GoToInfo marker = this.goToInfoSupplier.get(operator.getOccurrence(), "");
        ArrayList<LFProgram> progs = new ArrayList<LFProgram>();
        ListContainer<IHidObject> rhValues = operator.getRHValues();
        if (!rhValues.isEmpty() && this.isTernaryOperator(rhValues.get(0))) {
            this.internalConvertTernaryOperator(operator.getLHValue(), (IHidOperator)rhValues.get(0), true, declarationScope, marker, progs);
        } else {
            this.internalConvertBinaryOperator(operator.getLHValue(), OptimizedUtils.asList(rhValues, false), true, declarationScope, marker, progs);
        }
        return progs;
    }

    private void internalConvertBinaryOperator(IHidObject lhValue, List<IHidObject> rhValues, boolean testNoSelects, IRfNamedElement declarationScope, GoToInfo marker, List<LFProgram> progs) {
        Set<IHid> lhHidsSelects = HidUtils.flattenToHids(lhValue, this.flatteningOptions);
        Set<IHid> lhHidsNoSelects = testNoSelects ? HidUtils.flattenToHids(lhValue, this.flatteningOptionsNoSelects) : lhHidsSelects;
        boolean hasHidsInSelects = false;
        if (lhHidsSelects.size() != lhHidsNoSelects.size()) {
            hasHidsInSelects = lhHidsSelects.removeAll(lhHidsNoSelects);
        }
        this.internalConvertAssignmentRHSide(lhHidsNoSelects, rhValues, hasHidsInSelects ? lhHidsSelects : Collections.emptyList(), declarationScope, marker, progs);
    }

    private void internalConvertTernaryOperator(IHidObject lhValue, IHidOperator rhTernaryOperator, boolean testNoSelects, IRfNamedElement declarationScope, GoToInfo assignmentMarker, List<LFProgram> progs) {
        Set<IHid> lhHidsSelects = HidUtils.flattenToHids(lhValue, this.flatteningOptions);
        Set<IHid> lhHidsNoSelects = testNoSelects ? HidUtils.flattenToHids(lhValue, this.flatteningOptionsNoSelects) : lhHidsSelects;
        boolean hasHidsInSelects = false;
        if (lhHidsSelects.size() != lhHidsNoSelects.size()) {
            hasHidsInSelects = lhHidsSelects.removeAll(lhHidsNoSelects);
        }
        this.internalRecursiveConvertTernaryOperator(lhHidsNoSelects, rhTernaryOperator, hasHidsInSelects ? lhHidsSelects : Collections.emptyList(), declarationScope, assignmentMarker, progs);
    }

    private List<LFProgram> internalRecursiveConvertTernaryOperator(Collection<IHid> lhHids, IHidOperator ternaryOperator, Collection<IHid> lhDrivers, IRfNamedElement declarationScope, GoToInfo assignmentMarker, List<LFProgram> progs) {
        GoToInfo conditionMarker = this.goToInfoSupplier.get(ternaryOperator.getOccurrence(), "");
        IHidObject condition = ternaryOperator.getLHValue();
        LFFormula conditionFormula = LFFormula.f(condition, conditionMarker);
        ListContainer<IHidObject> rhValues = ternaryOperator.getRHValues();
        int index = 1;
        while (index >= 0) {
            LFFormula implyingFormula;
            IHidObject ternaryPartValue = rhValues.get(index);
            LFFormula lFFormula = implyingFormula = index == 1 ? conditionFormula : conditionFormula.not();
            if (this.isTernaryOperator(ternaryPartValue)) {
                rhProgs = new ArrayList<LFProgram>(2);
                this.internalRecursiveConvertTernaryOperator(lhHids, (IHidOperator)ternaryPartValue, lhDrivers, declarationScope, assignmentMarker, rhProgs);
                progs.add(implyingFormula.imply(LFUtils.makeSequence(rhProgs)));
            } else {
                rhProgs = new ArrayList(2);
                this.internalConvertAssignmentRHSide(lhHids, Collections.singletonList(ternaryPartValue), lhDrivers, declarationScope, assignmentMarker, rhProgs);
                for (LFProgram rhProg : rhProgs) {
                    progs.add(implyingFormula.imply(rhProg));
                }
            }
            --index;
        }
        return progs;
    }

    private boolean isTernaryOperator(IHidObject hidObject) {
        return hidObject instanceof IHidOperator && ((IHidOperator)hidObject).isConditionalTernary();
    }

    private void addProg(LFProgram prog, Collection<LFProgram> progs) {
        if (prog == null) {
            return;
        }
        progs.add(prog);
    }

    private static class LFAssignmentContext
    implements ISContext {
        private IRfNamedElement correspondentScope;
        private Hid correspondentFieldHid;
        private List<IRfNamedElement> cacheMembers;
        private IRfNamedElement cacheMemberOfList;

        private static LFAssignmentContext of(IRfNamedElement correspondentScope, Hid correspondentFieldHid) {
            if (correspondentScope == null || correspondentFieldHid == null) {
                return null;
            }
            return new LFAssignmentContext(correspondentScope, correspondentFieldHid);
        }

        private LFAssignmentContext(IRfNamedElement correspondentScope, Hid correspondentFieldHid) {
            this.correspondentScope = correspondentScope;
            this.correspondentFieldHid = correspondentFieldHid;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IRfNamedElement calculateCorrespondentByPosition(int position) {
            void var3_2;
            IRfListType iRfListType;
            IRfNamedElement iRfNamedElement = this.correspondentScope;
            if (iRfNamedElement instanceof IRfListType && (iRfListType = (IRfListType)iRfNamedElement) == (IRfListType)var3_2) {
                void listScope;
                if (listScope.isAssociativeArray()) {
                    return null;
                }
                if (this.cacheMemberOfList == null) {
                    this.cacheMemberOfList = new DummyField("Pos0", listScope.getLanguageKind() == LanguageKind.VHDL ? 8192 : 1, 1, (IRfNamedElement)listScope, listScope.getAssociatedType());
                }
                return this.cacheMemberOfList;
            }
            if (this.correspondentScope instanceof IRfListType) {
                if (this.cacheMemberOfList == null) {
                    this.cacheMemberOfList = this.correspondentFieldHid.getElement();
                }
                return this.cacheMemberOfList;
            }
            if (this.correspondentScope instanceof IRfCompositeTypeElement) {
                if (this.cacheMembers == null) {
                    Collection<? extends IRfNamedElement> members = this.correspondentScope.getMembers(true, true);
                    if (members == null) {
                        return null;
                    }
                    this.cacheMembers = new ArrayList<IRfNamedElement>(members);
                }
                return position >= 0 && position < this.cacheMembers.size() ? this.cacheMembers.get(position) : null;
            }
            return null;
        }

        @Override
        public IRfNamedElement calculateCorrespondentByName(String name, IHidObject originalFormalPart, IRfNamedElement initialScope) {
            if (this.correspondentScope instanceof IRfListType) {
                return null;
            }
            if (!(this.correspondentScope instanceof IRfCompositeTypeElement)) {
                return null;
            }
            return this.correspondentScope.semanticGetLocalMember(name, null, null, null, new HashSet<IRfNamedElement>(), null, false, true, false);
        }

        @Override
        public Hid getAssignPatternLHSideHid() {
            return this.correspondentFieldHid;
        }

        @Override
        public boolean isStruct() {
            return this.correspondentScope instanceof IRfCompositeTypeElement && ((IRfCompositeTypeElement)this.correspondentScope).isStruct();
        }
    }
}

