/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logic.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ro.amiq.dvt.logic.form.ILFTransformation;
import ro.amiq.dvt.logic.form.model.ILFProgram;
import ro.amiq.dvt.logic.form.model.LFProgram;
import ro.amiq.dvt.logic.form.utils.LFNormalizeTransformation;

public class LogicForm {
    public List<LFProgram> content = new ArrayList<LFProgram>();

    private LogicForm() {
    }

    public static LogicForm noneOf() {
        return new LogicForm();
    }

    public static LogicForm of(LFProgram prog) {
        if (prog == null) {
            return null;
        }
        LogicForm logicForm = new LogicForm();
        logicForm.content.add(prog);
        return logicForm;
    }

    public static LogicForm of(Collection<LFProgram> prog) {
        if (prog == null || prog.isEmpty()) {
            return null;
        }
        LogicForm logicForm = new LogicForm();
        logicForm.content.addAll(prog);
        return logicForm;
    }

    public static LogicForm normOf(Collection<LFProgram> prog) {
        if (prog == null || prog.isEmpty()) {
            return null;
        }
        LogicForm logicForm = new LogicForm();
        logicForm.content.addAll(prog);
        return logicForm.apply(LFNormalizeTransformation.INSTANCE);
    }

    public LogicForm apply(ILFTransformation agent) {
        if (agent == null) {
            return this;
        }
        return agent.doWork(this);
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ILFProgram iLFProgram : this.content) {
            sb.append(iLFProgram).append("\n");
        }
        return sb.toString();
    }
}

