/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logic.form.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.logic.form.model.ILFMarkerHolder;
import ro.amiq.dvt.model.reflection.DummyField;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.utils.OptimizedUtils;

public class LFFanIn
implements ILFMarkerHolder {
    private final IHid center;
    private IRfNamedElement centerResolved;
    private List<IHid> border;
    private GoToInfo fileMarker;

    public static LFFanIn of(IHid center) {
        if (center == null) {
            return null;
        }
        return new LFFanIn(center);
    }

    private LFFanIn(IHid center) {
        this.center = center;
    }

    public void addAllToBorder(Collection<IHid> hids) {
        if (hids == null || hids.isEmpty()) {
            return;
        }
        this.border = OptimizedUtils.listAdd(this.border, hids);
    }

    public void replaceHidFromBorder(IHid toReplace, IHid replacement) {
        this.border.remove(toReplace);
        this.border = OptimizedUtils.listAdd(this.border, replacement);
    }

    public void setMarker(GoToInfo marker) {
        this.fileMarker = marker;
    }

    @Override
    public GoToInfo getMarker() {
        return this.fileMarker;
    }

    public IHid getCenter() {
        return this.center;
    }

    public IRfNamedElement getCenterResolved() {
        return this.getCenterResolved(null, null, null);
    }

    public IRfNamedElement getSimpleCenterResolved() {
        IRfNamedElement candidate = this.getCenterResolved();
        return candidate instanceof HierarchicalElement ? ((HierarchicalElement)candidate).getLastSegment() : candidate;
    }

    public IRfNamedElement getCenterResolved(DesignUtils.DesignRequest request, ELInstance closestAncestorInstance, Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap) {
        if (!HidUtils.isHid(this.center)) {
            return this.centerResolved;
        }
        Hid centerHid = (Hid)this.center;
        if (centerHid.getElement() instanceof DummyField && centerHid.getParentHid() != null) {
            centerHid = centerHid.getParentHid();
        }
        if (request != null || closestAncestorInstance != null || dummyPortMap != null) {
            IRfNamedElement resolved = centerHid.getDesignSignal(request, closestAncestorInstance, dummyPortMap);
            return resolved;
        }
        if (this.centerResolved == null) {
            this.centerResolved = centerHid.getDesignSignal(null, null, null);
        }
        return this.centerResolved;
    }

    public void setCenterResolved(IRfNamedElement resolved) {
        this.centerResolved = resolved;
    }

    @NotNull
    public List<IHid> getBorder() {
        return this.border != null ? this.border : Collections.emptyList();
    }

    public boolean hasBorder() {
        return this.border != null;
    }

    public int size() {
        return this.border != null ? this.border.size() : 0;
    }

    public boolean isDeclaration() {
        return HidUtils.isHidImplicit(this.center);
    }

    public String toString() {
        return "{ " + HidUtils.toNiceString(this.center) + " | " + this.border + " }";
    }

    public LFFanIn deepCopy() {
        LFFanIn newFan = new LFFanIn(this.center);
        newFan.addAllToBorder(this.border);
        newFan.centerResolved = this.centerResolved;
        return newFan;
    }
}

