/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logic.form.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.logic.form.model.ILFFormula;
import ro.amiq.dvt.logic.form.model.ILFMarkerHolder;
import ro.amiq.dvt.logic.form.model.LFFormulaKind;
import ro.amiq.dvt.logic.form.model.LFProgram;
import ro.amiq.dvt.logic.form.utils.LFUtils;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;

public abstract class LFFormula
implements ILFFormula,
ILFMarkerHolder {
    public static final LFFormula EMPTY = new LFFormula(){

        @Override
        public LFFormulaKind getFormulaKind() {
            return LFFormulaKind.EMPTY;
        }

        @Override
        public GoToInfo getMarker() {
            return null;
        }

        public String toString() {
            return "EMPTY";
        }
    };
    public static final LFFormula FILTERED_FORMULA = new LFFormula(){

        @Override
        public GoToInfo getMarker() {
            return null;
        }

        @Override
        public LFFormulaKind getFormulaKind() {
            return LFFormulaKind.EMPTY;
        }

        public String toString() {
            return "Filtered by hide conditions related preferences";
        }
    };

    public void collectExprHids(Collection<IHid> collected, Set<HidFlatteningOption> options) {
    }

    public void setMarker(GoToInfo marker) {
    }

    public static final LFFormula f(IHidObject expr, GoToInfo fileMarker) {
        Objects.requireNonNull(expr);
        Objects.requireNonNull(fileMarker);
        return new LFAtomicFormula(expr, fileMarker);
    }

    public LFFormula and(LFFormula ... others) {
        Objects.requireNonNull(others);
        return new LFAndFormula(this, others);
    }

    public LFFormula not() {
        if (this instanceof LFNotFormula) {
            return ((LFNotFormula)this).getExpr();
        }
        if (this == EMPTY) {
            return EMPTY;
        }
        if (this == FILTERED_FORMULA) {
            return FILTERED_FORMULA;
        }
        return new LFNotFormula(this);
    }

    public LFProgram.LFImplication imply(LFProgram prog) {
        return LFProgram.p(this, prog);
    }

    public static class LFAndFormula
    extends LFFormula {
        private final List<LFFormula> expr = new ArrayList<LFFormula>();

        private LFAndFormula(LFFormula me, LFFormula[] others) {
            this.expr.add(me);
            LFFormula[] lFFormulaArray = others;
            int n = others.length;
            int n2 = 0;
            while (n2 < n) {
                LFFormula other = lFFormulaArray[n2];
                if (other != null) {
                    this.expr.add(other);
                }
                ++n2;
            }
        }

        @Override
        public void collectExprHids(Collection<IHid> collected, Set<HidFlatteningOption> options) {
            for (LFFormula other : this.expr) {
                other.collectExprHids(collected, options);
            }
        }

        @Override
        public LFFormulaKind getFormulaKind() {
            return LFFormulaKind.AND;
        }

        @Override
        public GoToInfo getMarker() {
            return this.expr.get(this.expr.size() - 1).getMarker();
        }

        public List<LFFormula> getExpr() {
            return this.expr;
        }

        public String toString() {
            GoToInfo marker = this.getMarker();
            LanguageKind languageKind = marker != null ? marker.languageKind : null;
            StringJoiner sj = new StringJoiner(languageKind == LanguageKind.VHDL ? " and " : " && ");
            for (LFFormula formula : this.expr) {
                sj.add(formula.toString());
            }
            return "(" + sj + ")";
        }
    }

    public static class LFAtomicFormula
    extends LFFormula {
        private final IHidObject expr;
        private final GoToInfo fileMarker;

        private LFAtomicFormula(IHidObject expr, GoToInfo fileMarker) {
            this.expr = expr;
            this.fileMarker = fileMarker;
        }

        @Override
        public void collectExprHids(Collection<IHid> collected, Set<HidFlatteningOption> options) {
            collected.addAll(HidUtils.flattenToHids(this.getExpr(), options));
        }

        @Override
        public LFFormulaKind getFormulaKind() {
            return LFFormulaKind.ATOMIC;
        }

        @Override
        public GoToInfo getMarker() {
            return this.fileMarker;
        }

        public IHidObject getExpr() {
            return this.expr;
        }

        public String toString() {
            return "(" + LFUtils.getLabelText(this.expr) + ")";
        }
    }

    public static class LFNotFormula
    extends LFFormula {
        private final LFFormula expr;
        private GoToInfo fileMarker;

        private LFNotFormula(LFFormula me) {
            this.expr = me;
        }

        @Override
        public void collectExprHids(Collection<IHid> collected, Set<HidFlatteningOption> options) {
            this.expr.collectExprHids(collected, options);
        }

        @Override
        public LFFormulaKind getFormulaKind() {
            return LFFormulaKind.NOT;
        }

        @Override
        public GoToInfo getMarker() {
            return this.fileMarker;
        }

        @Override
        public void setMarker(GoToInfo marker) {
            this.fileMarker = marker;
        }

        public LFFormula getExpr() {
            return this.expr;
        }

        public String toString() {
            GoToInfo marker = this.getMarker();
            if (marker == null) {
                marker = this.expr.getMarker();
            }
            LanguageKind languageKind = marker != null ? marker.languageKind : null;
            return String.valueOf(languageKind == LanguageKind.VHDL ? "not " : "!") + this.expr;
        }
    }
}

