/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logic.form.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import ro.amiq.dvt.logic.form.model.ILFMarkerHolder;
import ro.amiq.dvt.logic.form.model.ILFProgram;
import ro.amiq.dvt.logic.form.model.LFFanIn;
import ro.amiq.dvt.logic.form.model.LFFormula;
import ro.amiq.dvt.logic.form.model.LFProgramKind;
import ro.amiq.dvt.model.reflection.GoToInfo;

public abstract class LFProgram
implements ILFProgram,
ILFMarkerHolder {
    public static final LFProgram CONTINUE = new LFProgram(){

        @Override
        public LFProgramKind getProgramKind() {
            return LFProgramKind.CONTINUE;
        }

        @Override
        public GoToInfo getMarker() {
            return null;
        }

        public String toString() {
            return "CONTINUE";
        }
    };
    public static final LFProgram BREAK = new LFProgram(){

        @Override
        public LFProgramKind getProgramKind() {
            return LFProgramKind.BREAK;
        }

        @Override
        public GoToInfo getMarker() {
            return null;
        }

        public String toString() {
            return "BREAK";
        }
    };

    public static LFAtomicProgram p(LFFanIn fan) {
        Objects.requireNonNull(fan);
        return new LFAtomicProgram(fan);
    }

    public static LFImplication p(LFFormula antec, LFProgram conseq) {
        Objects.requireNonNull(antec);
        Objects.requireNonNull(conseq);
        return new LFImplication(antec, conseq);
    }

    public LFSequenceProgram putInSequence(LFProgram ... others) {
        Objects.requireNonNull(others);
        return new LFSequenceProgram(this, others);
    }

    public LFParallelProgram putInParallel(LFProgram ... others) {
        Objects.requireNonNull(others);
        return new LFParallelProgram(this, others);
    }

    public static class LFAtomicProgram
    extends LFProgram {
        public final LFFanIn fan;

        public LFAtomicProgram(LFFanIn fan) {
            this.fan = fan;
        }

        @Override
        public LFProgramKind getProgramKind() {
            return LFProgramKind.ATOMIC;
        }

        @Override
        public GoToInfo getMarker() {
            return this.fan.getMarker();
        }

        public String toString() {
            return "[" + this.fan.toString() + "]";
        }
    }

    public static class LFImplication
    extends LFProgram {
        public final LFFormula antec;
        public final LFProgram conseq;

        private LFImplication(LFFormula antec, LFProgram conseq) {
            this.antec = antec;
            this.conseq = conseq;
        }

        @Override
        public LFProgramKind getProgramKind() {
            return LFProgramKind.IMPLICATION;
        }

        @Override
        public GoToInfo getMarker() {
            GoToInfo marker = this.conseq.getMarker();
            return marker == null ? this.antec.getMarker() : marker;
        }

        public String toString() {
            return "[" + this.antec + " ?; " + this.conseq + "]";
        }
    }

    public static class LFParallelProgram
    extends LFSequenceProgram {
        public LFParallelProgram(LFProgram me, LFProgram[] others) {
            super(me, others);
        }

        @Override
        public LFProgramKind getProgramKind() {
            return LFProgramKind.PARALLEL;
        }

        @Override
        public String toString() {
            StringJoiner sj = new StringJoiner(" , ");
            for (LFProgram prog : this.content) {
                sj.add(prog.toString());
            }
            return "OR[" + sj + "]";
        }
    }

    public static class LFSequenceProgram
    extends LFProgram {
        public final List<LFProgram> content = new ArrayList<LFProgram>();

        public LFSequenceProgram(LFProgram me, LFProgram[] others) {
            this.content.add(me);
            LFProgram[] lFProgramArray = others;
            int n = others.length;
            int n2 = 0;
            while (n2 < n) {
                LFProgram other = lFProgramArray[n2];
                if (other != null) {
                    this.content.add(other);
                }
                ++n2;
            }
        }

        @Override
        public LFProgramKind getProgramKind() {
            return LFProgramKind.SEQUENCE;
        }

        @Override
        public GoToInfo getMarker() {
            return this.content.get(this.content.size() - 1).getMarker();
        }

        public String toString() {
            StringJoiner sj = new StringJoiner(" , ");
            for (LFProgram prog : this.content) {
                sj.add(prog.toString());
            }
            return "AND[" + sj + "]";
        }
    }
}

