/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logic.form.utils;

import java.util.ArrayDeque;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.logic.form.ILFVisitor;
import ro.amiq.dvt.logic.form.model.LFProgram;
import ro.amiq.dvt.logic.form.utils.LFUtils;

public final class LFTraversals {
    private LFTraversals() {
    }

    public static final LFBFS newBFS(LFProgram program, ILFVisitor visitor, IProgressMonitor monitor) {
        Objects.requireNonNull(program);
        Objects.requireNonNull(visitor);
        return new LFBFS(program, visitor, (IProgressMonitor)(monitor == null ? new NullProgressMonitor() : monitor));
    }

    public static class LFBFS {
        private ILFVisitor visitor;
        private LFProgram program;
        private IProgressMonitor monitor;

        private LFBFS(LFProgram program, ILFVisitor visitor, IProgressMonitor monitor) {
            this.visitor = visitor;
            this.program = program;
            this.monitor = monitor;
        }

        public boolean start() {
            ArrayDeque<LFProgram> boundary = new ArrayDeque<LFProgram>();
            boundary.add(this.program);
            this.monitor.beginTask("Work", 0);
            while (!boundary.isEmpty()) {
                if (this.monitor.isCanceled()) {
                    return true;
                }
                LFProgram prog = (LFProgram)boundary.poll();
                this.visitor.visit(null, prog);
                LFUtils.flattenToPrograms(prog, boundary, false, false);
            }
            this.monitor.worked(0);
            return true;
        }

        public void cancel() {
            this.monitor.setCanceled(true);
        }
    }
}

