/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.logic.form.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import ro.amiq.dvt.logic.form.LogicForm;
import ro.amiq.dvt.logic.form.model.ILFFormula;
import ro.amiq.dvt.logic.form.model.ILFProgram;
import ro.amiq.dvt.logic.form.model.LFFanIn;
import ro.amiq.dvt.logic.form.model.LFFormula;
import ro.amiq.dvt.logic.form.model.LFProgram;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;

public final class LFUtils {
    private static final Predicate<LFFormula> NON_EMPTY_FORMULA = formula -> !LFUtils.isEmptyFormula(formula);

    private LFUtils() {
    }

    public static final boolean isProgram(Object obj) {
        return obj instanceof ILFProgram;
    }

    public static final boolean isSimpleProgram(Object obj) {
        return LFUtils.isAtomicProgram(obj) || LFUtils.isBreakProgram(obj) || LFUtils.isContinueProgram(obj);
    }

    public static final boolean isAtomicProgram(Object obj) {
        return obj instanceof LFProgram.LFAtomicProgram;
    }

    public static final boolean isBreakProgram(Object obj) {
        return LFProgram.BREAK == obj;
    }

    public static final boolean isContinueProgram(Object obj) {
        return LFProgram.CONTINUE == obj;
    }

    public static final boolean isImplication(Object obj) {
        return obj instanceof LFProgram.LFImplication;
    }

    public static final boolean isBreakImplication(LFProgram.LFImplication obj) {
        return LFUtils.isBreakProgram(obj.conseq);
    }

    public static final boolean isFormula(Object obj) {
        return obj instanceof ILFFormula;
    }

    public static final boolean isSimpleFormula(Object obj) {
        Object formula = obj instanceof LFFormula.LFNotFormula ? ((LFFormula.LFNotFormula)obj).getExpr() : obj;
        return formula instanceof LFFormula.LFAtomicFormula;
    }

    public static final boolean isEmptyFormula(Object obj) {
        return LFFormula.EMPTY == obj || LFFormula.FILTERED_FORMULA == obj;
    }

    public static final boolean isNormalized(LFProgram program) {
        if (program == null) {
            return false;
        }
        switch (program.getProgramKind()) {
            case BREAK: 
            case CONTINUE: 
            case ATOMIC: {
                return true;
            }
            case IMPLICATION: {
                return LFUtils.isSimpleProgram(((LFProgram.LFImplication)program).conseq);
            }
        }
        return false;
    }

    public static final LFProgram makeSequence(List<LFProgram> progs) {
        if (progs == null || progs.isEmpty()) {
            return null;
        }
        if (progs.size() == 1) {
            return progs.get(0);
        }
        return LFUtils.makeSequence(progs.get(0), progs.subList(1, progs.size()).toArray(new LFProgram[0]));
    }

    public static final LFProgram makeSequence(LFProgram first, LFProgram ... progs) {
        if (first == null) {
            return null;
        }
        if (progs == null || progs.length == 0 || progs.length == 1 && progs[0] == null) {
            return first;
        }
        return first.putInSequence(progs);
    }

    public static LFProgram makeParallel(List<LFProgram> progs) {
        if (progs == null || progs.isEmpty()) {
            return null;
        }
        if (progs.size() == 1) {
            return progs.get(0);
        }
        return LFUtils.makeParallel(progs.get(0), progs.subList(1, progs.size()).toArray(new LFProgram[0]));
    }

    public static final LFProgram makeParallel(LFProgram first, LFProgram ... progs) {
        if (first == null) {
            return null;
        }
        if (progs == null || progs.length == 0 || progs.length == 1 && progs[0] == null) {
            return first;
        }
        return first.putInParallel(progs);
    }

    public static final LFProgram.LFImplication makeImplication(LFFormula antec, LFProgram conseq) {
        if (antec == null || conseq == null) {
            return null;
        }
        return antec.imply(conseq);
    }

    @NotNull
    public static LFFormula andFormulas(List<LFFormula> formulas) {
        if (formulas == null || formulas.isEmpty()) {
            return LFFormula.EMPTY;
        }
        return LFUtils.andFormulas(formulas.get(0), formulas.subList(1, formulas.size()).toArray(new LFFormula[0]));
    }

    @NotNull
    public static final LFFormula andFormulas(LFFormula first, LFFormula ... formulas) {
        if (first == null) {
            first = LFFormula.EMPTY;
        }
        if (formulas == null || formulas.length == 0) {
            return first;
        }
        return first.and(formulas);
    }

    public static final LFFanIn getExtendedFanInOfProgram(LFProgram prog, Set<HidFlatteningOption> options) {
        if (!LFUtils.isNormalized(prog)) {
            return null;
        }
        if (prog instanceof LFProgram.LFAtomicProgram) {
            return ((LFProgram.LFAtomicProgram)prog).fan.deepCopy();
        }
        if (prog instanceof LFProgram.LFImplication) {
            LFProgram.LFImplication impli = (LFProgram.LFImplication)prog;
            if (impli.conseq instanceof LFProgram.LFAtomicProgram) {
                LFFanIn fan = ((LFProgram.LFAtomicProgram)impli.conseq).fan.deepCopy();
                ArrayList<IHid> completeBorder = new ArrayList<IHid>(fan.getBorder());
                impli.antec.collectExprHids(completeBorder, options);
                fan.addAllToBorder(completeBorder);
                return fan;
            }
        }
        return null;
    }

    public static final boolean checkFanInOfProgram(LFProgram prog, Predicate<LFFanIn> predicate) {
        if (!LFUtils.isNormalized(prog)) {
            return false;
        }
        if (predicate == null) {
            return true;
        }
        if (prog instanceof LFProgram.LFAtomicProgram) {
            return predicate.test(((LFProgram.LFAtomicProgram)prog).fan);
        }
        if (prog instanceof LFProgram.LFImplication) {
            LFProgram.LFImplication impli = (LFProgram.LFImplication)prog;
            if (impli.conseq instanceof LFProgram.LFAtomicProgram) {
                return predicate.test(((LFProgram.LFAtomicProgram)impli.conseq).fan);
            }
        }
        return false;
    }

    public static final IHidObject getHidObject(LFFormula.LFAtomicFormula formula) {
        if (formula == null) {
            return null;
        }
        return formula.getExpr();
    }

    public static final IHidOperator getHidOperator(LFFormula.LFAtomicFormula formula) {
        IHidObject hidObject = LFUtils.getHidObject(formula);
        return HidUtils.isOperator(hidObject) ? (IHidOperator)hidObject : null;
    }

    public static final void flattenToPrograms(LFProgram program, Collection<LFProgram> flattened, boolean recursive, boolean includeOriginal) {
        if (program == null || flattened == null) {
            return;
        }
        if (includeOriginal) {
            flattened.add(program);
        }
        switch (program.getProgramKind()) {
            case IMPLICATION: {
                LFProgram conseq = ((LFProgram.LFImplication)program).conseq;
                if (recursive) {
                    LFUtils.flattenToPrograms(conseq, flattened, recursive, includeOriginal || LFUtils.isSimpleProgram(conseq));
                } else {
                    flattened.add(conseq);
                }
                return;
            }
            case SEQUENCE: {
                for (LFProgram prog : ((LFProgram.LFSequenceProgram)program).content) {
                    if (recursive) {
                        LFUtils.flattenToPrograms(prog, flattened, recursive, includeOriginal || LFUtils.isSimpleProgram(prog));
                        continue;
                    }
                    flattened.add(prog);
                }
                return;
            }
            case PARALLEL: {
                for (LFProgram prog : ((LFProgram.LFParallelProgram)program).content) {
                    if (recursive) {
                        LFUtils.flattenToPrograms(prog, flattened, recursive, includeOriginal || LFUtils.isSimpleProgram(prog));
                        continue;
                    }
                    flattened.add(prog);
                }
                return;
            }
        }
    }

    @NotNull
    public static final Map<IRfNamedElement, Set<IRfNamedElement>> mapFanInSignals(LogicForm normalizedForm, Set<HidFlatteningOption> options, Function<IHid, IRfNamedElement> resolver) {
        if (normalizedForm == null || resolver == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<IRfNamedElement, Set<IRfNamedElement>> result = new LinkedHashMap<IRfNamedElement, Set<IRfNamedElement>>(10);
        for (LFProgram prog : normalizedForm.content) {
            IRfNamedElement centerResolved;
            LFFanIn fan = LFUtils.getExtendedFanInOfProgram(prog, options);
            if (fan == null || (centerResolved = resolver.apply(fan.getCenter())) == null) continue;
            LinkedHashSet<IRfNamedElement> border = (LinkedHashSet<IRfNamedElement>)result.get(centerResolved);
            if (border == null) {
                border = new LinkedHashSet<IRfNamedElement>(4);
                result.put(centerResolved, border);
            }
            for (IHid driverHid : fan.getBorder()) {
                IRfNamedElement resolved = resolver.apply(driverHid);
                if (resolved == null) continue;
                border.add(resolved);
            }
        }
        return result;
    }

    public static final LFFormula getFormulaFromProgram(LFProgram prog) {
        return prog instanceof LFProgram.LFImplication ? ((LFProgram.LFImplication)prog).antec : null;
    }

    public static final void normalizeProgram(LFProgram program, List<LFProgram> normalized) {
        if (program == null || normalized == null) {
            return;
        }
        LFUtils.splitIntoNormalizedPrograms(program, normalized);
    }

    private static final void splitIntoNormalizedPrograms(LFProgram startProgram, List<LFProgram> normalized) {
        if (LFUtils.isNormalized(startProgram)) {
            normalized.add(startProgram);
            return;
        }
        ArrayDeque<LFProgram> working = new ArrayDeque<LFProgram>();
        working.add(startProgram);
        while (!working.isEmpty()) {
            LFProgram prog = (LFProgram)working.poll();
            LFFormula formula = LFFormula.EMPTY;
            ArrayList<LFProgram> flattened = new ArrayList<LFProgram>();
            block0 : switch (prog.getProgramKind()) {
                case ATOMIC: {
                    normalized.add(prog);
                    break;
                }
                case SEQUENCE: 
                case PARALLEL: {
                    LFUtils.flattenToPrograms(prog, flattened, false, false);
                    break;
                }
                case IMPLICATION: {
                    LFProgram.LFImplication implication = (LFProgram.LFImplication)prog;
                    formula = implication.antec;
                    switch (implication.conseq.getProgramKind()) {
                        case ATOMIC: {
                            normalized.add(prog);
                            break block0;
                        }
                        case SEQUENCE: 
                        case PARALLEL: {
                            prog = implication.conseq;
                            LFUtils.flattenToPrograms(implication.conseq, flattened, false, false);
                            break block0;
                        }
                        case IMPLICATION: {
                            LFFormula conseqFormula = ((LFProgram.LFImplication)implication.conseq).antec;
                            if (!LFUtils.isEmptyFormula(conseqFormula)) {
                                formula = LFUtils.andFormulas(formula, conseqFormula);
                            }
                            working.add(LFUtils.newImplicationOrProgram(formula, ((LFProgram.LFImplication)implication.conseq).conseq));
                            break block0;
                        }
                    }
                    break;
                }
            }
            for (LFProgram memberProg : flattened) {
                if (memberProg instanceof LFProgram.LFImplication && LFUtils.isBreakImplication((LFProgram.LFImplication)memberProg)) {
                    LFFormula breakFormula = ((LFProgram.LFImplication)memberProg).antec;
                    if (LFUtils.isEmptyFormula(breakFormula) || !(prog instanceof LFProgram.LFSequenceProgram)) continue;
                    formula = LFUtils.andFormulas(formula, breakFormula);
                    continue;
                }
                working.add(LFUtils.newImplicationOrProgram(formula, memberProg));
            }
        }
    }

    private static final LFProgram newImplicationOrProgram(LFFormula antec, LFProgram conseq) {
        List<LFFormula> nonEmptyFormulas = LFUtils.flattenFormula(antec, NON_EMPTY_FORMULA);
        return !nonEmptyFormulas.isEmpty() ? LFUtils.andFormulas(nonEmptyFormulas).imply(conseq) : conseq;
    }

    @NotNull
    public static final List<LFFormula> flattenFormula(LFFormula startFormula, Predicate<LFFormula> criteria) {
        if (startFormula == null) {
            return Collections.emptyList();
        }
        ArrayDeque<LFFormula> working = new ArrayDeque<LFFormula>(4);
        working.add(startFormula);
        ArrayList<LFFormula> simpleFormulas = new ArrayList<LFFormula>(4);
        while (!working.isEmpty()) {
            LFFormula formula = (LFFormula)working.poll();
            if (formula instanceof LFFormula.LFAndFormula) {
                working.addAll(((LFFormula.LFAndFormula)formula).getExpr());
                continue;
            }
            if (criteria != null && !criteria.test(formula)) continue;
            simpleFormulas.add(formula);
        }
        if (simpleFormulas.isEmpty()) {
            return Collections.emptyList();
        }
        Collections.sort(simpleFormulas, new Comparator<LFFormula>(){

            @Override
            public int compare(LFFormula o1, LFFormula o2) {
                GoToInfo marker1 = o1.getMarker();
                GoToInfo marker2 = o2.getMarker();
                if (marker1 == null) {
                    return -1;
                }
                if (marker2 == null) {
                    return 1;
                }
                return marker1.offset - marker2.offset;
            }
        });
        return simpleFormulas;
    }

    public static final List<LFProgram> filterPrograms(List<LFProgram> progs, Predicate<? super LFProgram> pred) {
        if (progs == null) {
            return null;
        }
        return progs.stream().filter(pred).collect(Collectors.toList());
    }

    @NotNull
    public static final String getLabelText(IHidObject object) {
        if (object == null) {
            return "";
        }
        switch (object.getHidKind()) {
            case HID: 
            case IMPLICIT: 
            case ACCESS: {
                return HidUtils.toStringBuilder(object, true, true, false, true, true, true).toString();
            }
            case OPERATOR: {
                IHidOperator operator = (IHidOperator)object;
                if (operator.hasOccurrence(HidQualifierCache.IS_CONDITIONAL_EXPRESSION_QUALIFIER + HidQualifierCache.IS_LOOP_EXPRESSION_QUALIFIER)) {
                    return HidUtils.toStringBuilder(operator.getLHValue(), true, true, false, true, true, true).toString();
                }
                return HidUtils.toStringBuilder(operator, true, true, false, true, true, true).toString();
            }
        }
        return "";
    }
}

