/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.main;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class AbstractReportGenerator {
    protected Configuration freeMarkerConfig;
    protected String templatePath;
    protected String customReportLocation;

    public boolean generateReport(Map<String, Object> root) {
        return this.generateReport(0, root);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean generateReport(int rerunNo, Map<String, Object> root) {
        boolean success = true;
        Template template = null;
        File templateFile = new File(this.templatePath);
        try {
            template = this.freeMarkerConfig.getTemplate(templateFile.getCanonicalFile().getName());
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError("ERROR: Can't read template '" + templateFile.getAbsolutePath() + "': " + e.getMessage());
            success = false;
        }
        if (template == null) {
            return false;
        }
        template.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        try {
            Throwable e = null;
            Object var7_11 = null;
            try {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.getReportFileName(rerunNo)));
                try {
                    try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(bos));){
                        template.process(root, (Writer)out);
                        ((Writer)out).flush();
                    }
                    if (bos == null) return success;
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    if (bos == null) throw e;
                    ((OutputStream)bos).close();
                    throw e;
                }
                ((OutputStream)bos).close();
                return success;
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                    throw e;
                } else {
                    if (e == throwable) throw e;
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (TemplateException e) {
            DVTLogger.INSTANCE.logError("ERROR: Custom report template has errors:\n" + e.getMessage() + "\n" + e.getFTLInstructionStack());
            return false;
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError("ERROR: Can't write custom report: " + e.getMessage());
            return false;
        }
    }

    public abstract Map<String, Object> createRootModel();

    public String getReportFileName() {
        return this.getReportFileName(0);
    }

    public String getReportFileName(int rerunNo) {
        IPath reportFolder = Path.fromOSString((String)(this.customReportLocation == null ? "" : this.customReportLocation));
        IPath path = Path.fromOSString((String)this.templatePath);
        String fileExtension = path.getFileExtension();
        String reportName = "";
        if (rerunNo == 0) {
            reportName = fileExtension != null && !fileExtension.isEmpty() ? path.removeFileExtension().lastSegment() : path.addFileExtension("custom.report").lastSegment();
        } else if (fileExtension != null && !fileExtension.isEmpty()) {
            IPath tempPath = path.removeFileExtension();
            String tempFileExtension = tempPath.getFileExtension();
            reportName = String.valueOf(tempPath.removeFileExtension().lastSegment()) + rerunNo;
            if (tempFileExtension != null && !tempFileExtension.isEmpty()) {
                reportName = String.valueOf(reportName) + "." + tempFileExtension;
            }
        } else {
            reportName = path.addFileExtension("custom" + rerunNo + ".report").lastSegment();
        }
        if (reportFolder != null) {
            return reportFolder.append(reportName).toOSString();
        }
        return reportName;
    }

    public static boolean createReportFolder(String reportLocation, String templatePath) {
        if (reportLocation == null || templatePath == null) {
            return false;
        }
        File reportFolder = new File(reportLocation);
        IPath path = Path.fromOSString((String)templatePath);
        String fileExtension = path.getFileExtension();
        String reportName = "";
        reportName = fileExtension != null && !fileExtension.isEmpty() ? path.removeFileExtension().lastSegment() : path.addFileExtension("custom.report").lastSegment();
        File reportPath = new File(reportLocation, reportName);
        return AbstractReportGenerator.writeCustomReportFolder(new File[]{reportFolder, reportPath}, AbstractReportGenerator::errorHandler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeCustomReportFolder(File[] files, Consumer<String> errorHandler) {
        if (files[0].exists()) {
            if (!files[0].isDirectory()) {
                errorHandler.accept("ERROR: Can't create report directory '" + files[0].getAbsolutePath() + "', it is an existing file!");
                return false;
            }
            if (!files[0].canWrite()) {
                errorHandler.accept("ERROR: Can't create report directory '" + files[0].getAbsolutePath() + "', it exists and has no write access!");
                return false;
            }
            if (files[1].exists()) {
                errorHandler.accept("WARNING: Custom report file '" + files[1].getAbsolutePath() + "' exists, contents will be overwritten!");
                try {
                    DVTFileUtils.getInstance().removeRecursive(files[1].toPath());
                }
                catch (IOException iOException) {
                    errorHandler.accept("ERROR: Can't remove existing custom report file '" + files[1].getAbsolutePath() + "'!");
                    return false;
                }
            }
            try {
                files[1].createNewFile();
            }
            catch (IOException iOException) {
                errorHandler.accept("ERROR: Can't create custom report file '" + files[1].getAbsolutePath() + "'!");
                return false;
            }
        }
        if (!files[0].mkdirs() && !files[0].exists()) {
            errorHandler.accept("ERROR: Can't create report directory '" + files[0].getAbsolutePath() + "'!");
            return false;
        }
        return true;
    }

    public static void errorHandler(String message) {
        DVTLogger.INSTANCE.logError(message);
    }
}

