/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.memorymonitor;

import java.io.File;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.interpreter.console.XConsole;
import ro.amiq.dvt.interpreter.console.XConsoleRegistry;
import ro.amiq.dvt.memorymonitor.MemoryMonitorConstants;
import ro.amiq.dvt.memorymonitor.MemoryMonitorDebugParametersWrapper;
import ro.amiq.dvt.memorymonitor.MemoryMonitorState;
import ro.amiq.dvt.memorymonitor.MemoryMonitoringType;
import ro.amiq.dvt.model.BuildState;
import ro.amiq.dvt.model.BuildStateProvider;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.reportissue.DVTHeapHistogramCollector;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.Utils;

public abstract class AMemoryMonitorCommon {
    protected AtomicBoolean monitorWasStarted = new AtomicBoolean(false);
    protected AtomicBoolean monitorWasScheduled = new AtomicBoolean(false);
    protected String projectName;
    protected boolean monitorIsEnabled = true;
    protected MemoryMonitorState monitorState = MemoryMonitorState.NONE;
    protected Object monitorStateLock = new Object();
    protected MemoryMonitoringType processType;
    private boolean debugIsEnabled;
    private boolean heapHistogramCollectionIsEnabled;
    private boolean isProactiveMode;
    private boolean hasCustomStopOpTh;
    private long startMonitorWindowTimer;
    private long startBuildTimer;
    private long monitorWindowDuration;
    private long timeSpentInGC;
    private long memWarningTh;
    private double stopOperationPercentageTh;
    private double stopOperationTh;
    private boolean ignoreWarning;
    private MemoryMonitorDebugParametersWrapper debugParamsWrapper;
    private File logFile;
    private IntrpDebugTarget runtimeElabDebugTarget;
    private int startDelay = 30000;
    private int gcTimeWindowPercentage = 10;
    private int timeInGcPerWindowPercent = 50;
    private int warningPercentage = 80;
    private int warningPercentageTh;
    private boolean automaticallyDisableMemoryMonitor = this.shouldDisableMemoryMonitor();
    private Timer startDelayTimer;
    private Job memoryMonitorJob;
    private long[] gcbeansGcDuration;
    private NotificationListener[] listeners;
    long saveForLaterMemory;

    protected AMemoryMonitorCommon() {
        if (this.automaticallyDisableMemoryMonitor) {
            return;
        }
        this.memoryMonitorJob = new Job("DVT Memory Monitor"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (MemoryMonitoringType.BUILD.equals((Object)AMemoryMonitorCommon.this.processType) && !TestHelper.isTestMode() && !AMemoryMonitorCommon.this.ignoreWarning) {
                        AMemoryMonitorCommon.this.startDelayTimer = new Timer();
                        AMemoryMonitorCommon.this.startDelayTimer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                AMemoryMonitorCommon.this.installPostGCMonitoring();
                            }
                        }, AMemoryMonitorCommon.this.startDelay);
                        return Status.OK_STATUS;
                    }
                    AMemoryMonitorCommon.this.installPostGCMonitoring();
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return Status.OK_STATUS;
                }
            }
        };
        this.memoryMonitorJob.setSystem(true);
        this.memoryMonitorJob.setPriority(50);
    }

    protected boolean isIndependentOperation(MemoryMonitoringType processType) {
        return MemoryMonitoringType.BUILD.equals((Object)processType) || this.isRuntimeOperation();
    }

    private boolean shouldDisableMemoryMonitor() {
        if (this.isCustomGc()) {
            return true;
        }
        if (!this.isRecommendedDvtDistro()) {
            return true;
        }
        return this.hasCustomGcArguments();
    }

    private boolean isCustomGc() {
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        if (gcBeans == null) {
            return true;
        }
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            if (gcBean == null) {
                return true;
            }
            String gcName = gcBean.getName();
            if (gcName == null) {
                return true;
            }
            if (gcName.contains("G1")) continue;
            return true;
        }
        return false;
    }

    private boolean isRecommendedDvtDistro() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion == null) {
            return false;
        }
        String[] stringArray = MemoryMonitorConstants.DVT_DEFAULT_DISTRO;
        int n = MemoryMonitorConstants.DVT_DEFAULT_DISTRO.length;
        int n2 = 0;
        while (n2 < n) {
            String version = stringArray[n2];
            if (javaVersion.startsWith(version)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasCustomGcArguments() {
        RuntimeMXBean runtimemxBean = ManagementFactory.getRuntimeMXBean();
        if (runtimemxBean == null) {
            return true;
        }
        List<String> arguments = runtimemxBean.getInputArguments();
        for (String argument : arguments) {
            if (!this.isCustomGcArgument(argument)) continue;
            return true;
        }
        return false;
    }

    private boolean isCustomGcArgument(String argument) {
        return this.isCustomGcAlgorithm(argument) || argument.startsWith("-XX:G1") || argument.contains("HeapFreeRatio");
    }

    private boolean isCustomGcAlgorithm(String argument) {
        return argument.startsWith("-XX:+Use") && argument.endsWith("GC") && !argument.contains("G1");
    }

    private void installPostGCMonitoring() {
        try {
            if (!this.monitorWasScheduled.get()) {
                return;
            }
            this.startMonitorWindowTimer = System.currentTimeMillis();
            List<GarbageCollectorMXBean> gcbeans = ManagementFactory.getGarbageCollectorMXBeans();
            this.listeners = new NotificationListener[gcbeans.size()];
            this.gcbeansGcDuration = new long[gcbeans.size()];
            int counter = 0;
            for (GarbageCollectorMXBean gcbean : gcbeans) {
                this.gcbeansGcDuration[counter] = gcbean.getCollectionTime();
                NotificationEmitter emitter = (NotificationEmitter)((Object)gcbean);
                this.listeners[counter] = (notification, handback) -> this.memoryMonitor(gcbean);
                emitter.addNotificationListener(this.listeners[counter], null, null);
                ++counter;
            }
            this.monitorWasStarted.set(true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected boolean memoryMonitorShouldStart(MemoryMonitoringType processType, String projectName) {
        if (this.isInhibited()) {
            return false;
        }
        if (this.listeners != null) {
            return false;
        }
        if (MemoryMonitoringType.BUILD.equals((Object)processType)) {
            boolean bl = this.monitorIsEnabled = BuildConfigManager.isMemoryMonitorDisabled(Utils.getProject(projectName)) == false;
        }
        return this.monitorIsEnabled;
    }

    public void startMemoryMonitor(MemoryMonitoringType processType, String projectName) {
        try {
            if (!this.memoryMonitorShouldStart(processType, projectName)) {
                return;
            }
            this.initialize(processType, projectName);
            if (this.debugIsEnabled) {
                this.initDebugFile();
            }
            this.monitorWasScheduled.set(true);
            this.memoryMonitorJob.schedule();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void startMemoryMonitor(MemoryMonitoringType processType, String projectName, IntrpDebugTarget monitorTarget) {
        this.runtimeElabDebugTarget = monitorTarget;
        this.startMemoryMonitor(processType, projectName);
    }

    private void initialize(MemoryMonitoringType processType, String projectName) {
        this.processType = processType;
        this.projectName = this.computeProjectName(projectName);
        if (MemoryMonitoringType.BUILD.equals((Object)processType)) {
            this.checkDebugDirectives();
        } else if (!this.isProactiveMode && !this.hasCustomStopOpTh) {
            double d = this.stopOperationPercentageTh = this.isRuntimeOperation() ? 99.5 : 99.0;
        }
        this.monitorState = this.isIndependentOperation(processType) ? MemoryMonitorState.STARTED : (MemoryMonitorState.WARNING.equals((Object)this.monitorState) ? MemoryMonitorState.WARNING : MemoryMonitorState.STARTED);
        this.startBuildTimer = System.currentTimeMillis();
        this.timeSpentInGC = 0L;
        this.warningPercentageTh = 100 - this.warningPercentage;
        this.memWarningTh = MemoryMonitorConstants.HEAP_MAX_SIZE * (long)this.warningPercentageTh / 100L;
        this.stopOperationTh = (double)MemoryMonitorConstants.HEAP_MAX_SIZE * (100.0 - this.stopOperationPercentageTh) / 100.0;
    }

    private boolean isRuntimeOperation() {
        return MemoryMonitoringType.RUNTIME_ELAB.equals((Object)this.processType) || MemoryMonitoringType.XSIM.equals((Object)this.processType);
    }

    private void checkDebugDirectives() {
        IProject project = Utils.getProject(this.projectName);
        this.isProactiveMode = BuildConfigManager.isMemoryMonitorProactiveMode(project);
        this.heapHistogramCollectionIsEnabled = BuildConfigManager.isMemoryMonitorHeapHistogramEnabled(project);
        this.debugIsEnabled = BuildConfigManager.isMemoryMonitorDebugMode(project);
        if (this.isProactiveMode) {
            this.ignoreWarning = true;
            this.stopOperationPercentageTh = this.debugParamsWrapper == null || this.debugParamsWrapper.getForceStopTh() == null ? 80.0 : this.debugParamsWrapper.getForceStopTh();
            this.debugParamsWrapper = null;
            return;
        }
        this.resetDefaultParameters();
        if (this.debugParamsWrapper != null) {
            this.updateDirectiveParameters();
            this.debugParamsWrapper = null;
            return;
        }
    }

    private void updateDirectiveParameters() {
        if (this.debugParamsWrapper.getCustomStartDelay() != null) {
            this.startDelay = this.debugParamsWrapper.getCustomStartDelay();
        }
        if (this.debugParamsWrapper.getCustomTimeInGcPerWindowPercent() != null) {
            this.timeInGcPerWindowPercent = this.debugParamsWrapper.getCustomTimeInGcPerWindowPercent();
        }
        if (this.debugParamsWrapper.getCustomWarningPercentage() != null) {
            this.warningPercentage = this.debugParamsWrapper.getCustomWarningPercentage();
        }
        if (this.debugParamsWrapper.getCustomGcTimeWindowPercentage() != null) {
            this.gcTimeWindowPercentage = this.debugParamsWrapper.getCustomGcTimeWindowPercentage();
        }
        this.ignoreWarning = this.debugParamsWrapper.isIgnoreWarning();
        if (this.debugParamsWrapper.getForceStopTh() != null) {
            this.hasCustomStopOpTh = true;
            this.stopOperationPercentageTh = this.debugParamsWrapper.getForceStopTh();
            return;
        }
        this.hasCustomStopOpTh = false;
        this.stopOperationPercentageTh = 99.0;
    }

    private void resetDefaultParameters() {
        this.startDelay = 30000;
        this.timeInGcPerWindowPercent = 50;
        this.warningPercentage = 80;
        this.gcTimeWindowPercentage = 10;
        this.stopOperationPercentageTh = 99.0;
        this.ignoreWarning = false;
        this.hasCustomStopOpTh = false;
    }

    private void initDebugFile() {
        try {
            String saveToLocation = DVTHeapHistogramCollector.getSaveToLocation("memory_monitor");
            this.logFile = new File(saveToLocation, "dvt_memory_monitor_" + System.currentTimeMillis() + ".log");
            this.logDebug("Process type: " + (Object)((Object)this.processType) + " on project " + this.projectName);
            this.logDebug("Force stop percentage: " + this.stopOperationPercentageTh + ", ignore warning: " + this.ignoreWarning);
            if (!this.ignoreWarning) {
                this.logDebug("Start delay: " + this.startDelay + "ms, window duration percentage: " + this.gcTimeWindowPercentage + "%, time in gc percentage: " + this.timeInGcPerWindowPercent + "%, warning percentage: " + this.warningPercentage + "%");
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void stopMemoryMonitor() {
        try {
            if (this.isInhibited() || !this.monitorIsEnabled) {
                return;
            }
            if (this.startDelayTimer != null) {
                this.startDelayTimer.cancel();
                this.startDelayTimer = null;
            }
            this.monitorWasScheduled.set(false);
            if (!this.monitorWasStarted.get()) {
                return;
            }
            this.monitorWasStarted.set(false);
            this.addProblemMarker();
            this.reportProblemToBuildReport();
            if (this.heapHistogramCollectionIsEnabled) {
                DVTHeapHistogramCollector.getInstance().endSession();
            }
            if (this.listeners == null) {
                return;
            }
            List<GarbageCollectorMXBean> gcbeans = ManagementFactory.getGarbageCollectorMXBeans();
            int counter = 0;
            for (GarbageCollectorMXBean gcbean : gcbeans) {
                NotificationEmitter emitter = (NotificationEmitter)((Object)gcbean);
                if (this.listeners[counter] == null) continue;
                try {
                    emitter.removeNotificationListener(this.listeners[counter]);
                    this.listeners[counter] = null;
                    ++counter;
                }
                catch (ListenerNotFoundException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
            this.listeners = null;
            this.resetStates();
            if (!this.debugIsEnabled) {
                return;
            }
            this.logDebug("Debug finished");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void resetStates() {
        this.gcbeansGcDuration = null;
        this.runtimeElabDebugTarget = null;
        this.projectName = "unknown";
        this.saveForLaterMemory = 0L;
    }

    private void logDebug(String message) {
        if (!this.debugIsEnabled || this.logFile == null) {
            return;
        }
        try {
            DVTFileUtils.getInstance().writeStringToFile(this.logFile, new Timestamp(System.currentTimeMillis()) + "\t\t" + message + "\n", true);
        }
        catch (Exception exception) {}
    }

    private void collectHeapHistogram() {
        if (!this.heapHistogramCollectionIsEnabled) {
            return;
        }
        DVTHeapHistogramCollector.getInstance().startSession("memory_monitor", true);
        DVTHeapHistogramCollector.getInstance().collectHistogram();
    }

    public void updateSaveForLaterMemory(int numberOfHits, int hitSize) {
        long ruleHitListSize = (long)numberOfHits * (long)hitSize + 56L;
        this.saveForLaterMemory += ruleHitListSize;
        this.memWarningTh = (MemoryMonitorConstants.HEAP_MAX_SIZE - DVTUtilsCommon.INSTANCE.convertByteToMb(this.saveForLaterMemory)) * (long)this.warningPercentageTh / 100L;
    }

    private void memoryMonitor(GarbageCollectorMXBean gcbean) {
        if (gcbean == null || this.gcbeansGcDuration == null) {
            return;
        }
        String gcBeanName = gcbean.getName();
        if (gcBeanName == null || gcBeanName.isEmpty()) {
            return;
        }
        int position = gcBeanName.contains("Young") ? 0 : 1;
        long gcDuration = gcbean.getCollectionTime() - this.gcbeansGcDuration[position];
        this.gcbeansGcDuration[position] = gcbean.getCollectionTime();
        long allocatedHeapUsedSize = DVTUtilsCommon.INSTANCE.convertByteToMb(Runtime.getRuntime().totalMemory());
        long allocatedHeapFreeSize = DVTUtilsCommon.INSTANCE.convertByteToMb(Runtime.getRuntime().freeMemory());
        long totalHeapFreeSize = MemoryMonitorConstants.HEAP_MAX_SIZE - allocatedHeapUsedSize + allocatedHeapFreeSize;
        if (MemoryMonitorState.WARNING.equals((Object)this.monitorState)) {
            this.gcMode(gcDuration, totalHeapFreeSize);
        }
        if (MemoryMonitorState.STARTED.equals((Object)this.monitorState) && this.memWarningTh > totalHeapFreeSize && !this.ignoreWarning) {
            this.memoryWarning(totalHeapFreeSize);
        }
        if ((this.stopOperationTh > (double)totalHeapFreeSize || DVTUtilsCommon.INSTANCE.convertByteToMb(this.saveForLaterMemory) >= totalHeapFreeSize) && !MemoryMonitorState.ERROR.equals((Object)this.monitorState)) {
            this.memoryError("Operation was forced stop", totalHeapFreeSize);
        }
    }

    private void gcMode(long gcDuration, long heapFreeSize) {
        double memUsagePercentage = 100.0 - (double)heapFreeSize * 100.0 / (double)MemoryMonitorConstants.HEAP_MAX_SIZE;
        DecimalFormat dec = new DecimalFormat("#0.00");
        String debugMessage = "Memory percent: " + dec.format(memUsagePercentage) + "%, Empty Memory " + heapFreeSize + "MB";
        if (MemoryMonitoringType.LINT.equals((Object)this.processType)) {
            debugMessage = String.valueOf(debugMessage) + ", Memory for lint report " + DVTUtilsCommon.INSTANCE.convertByteToMb(this.saveForLaterMemory) + "MB";
        }
        this.logDebug(debugMessage);
        this.timeSpentInGC += gcDuration;
        long actualWindowDuration = System.currentTimeMillis() - this.startMonitorWindowTimer;
        if (actualWindowDuration >= this.monitorWindowDuration) {
            this.logDebug("Monitor window duration: " + this.monitorWindowDuration + ", actual window duration: " + actualWindowDuration + ", time spent in GC: " + this.timeSpentInGC + ", " + this.timeSpentInGC * 100L / this.monitorWindowDuration + "%");
            if (this.monitorWindowDuration != 0L && this.timeSpentInGC * 100L / this.monitorWindowDuration > (long)this.timeInGcPerWindowPercent && this.runtimeOperationCheck(heapFreeSize)) {
                this.memoryError("Operation was stopped by the memory monitor under normal conditions", heapFreeSize);
            }
            this.timeSpentInGC = 0L;
            this.startMonitorWindowTimer = System.currentTimeMillis();
            this.monitorWindowDuration = Math.min((this.startMonitorWindowTimer - this.startBuildTimer) * (long)this.gcTimeWindowPercentage / 100L, 20000L);
        }
    }

    private boolean runtimeOperationCheck(long heapFreeSize) {
        return !this.isRuntimeOperation() || MemoryMonitorConstants.RUNTIME_OPERATION_MEMORY_ERROR_TH > heapFreeSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void memoryWarning(long heapFreeSize) {
        try {
            Object object = this.monitorStateLock;
            synchronized (object) {
                this.monitorState = MemoryMonitorState.WARNING;
                this.monitorStateLock.notifyAll();
            }
            double memUsagePercentage = 100.0 - (double)heapFreeSize * 100.0 / (double)MemoryMonitorConstants.HEAP_MAX_SIZE;
            DecimalFormat dec = new DecimalFormat("#0.00");
            this.logDebug("A warning was raised Memory percent: " + dec.format(memUsagePercentage) + "%");
            this.memoryWarningInitializations();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void memoryWarningInitializations() {
        this.startMonitorWindowTimer = System.currentTimeMillis();
        this.monitorWindowDuration = (this.startMonitorWindowTimer - this.startBuildTimer) * (long)this.gcTimeWindowPercentage / 100L;
        this.timeSpentInGC = 0L;
    }

    protected void memoryError(String debugMessage, long heapFreeSize) {
        try {
            this.monitorState = MemoryMonitorState.ERROR;
            double memUsagePercentage = 100.0 - (double)heapFreeSize * 100.0 / (double)MemoryMonitorConstants.HEAP_MAX_SIZE;
            DecimalFormat dec = new DecimalFormat("#0.00");
            this.logDebug(String.valueOf(debugMessage) + " Memory percent: " + dec.format(memUsagePercentage) + "%");
            this.notifyMemoryIssue();
            this.collectHeapHistogram();
            if (this.isRuntimeOperation() && this.runtimeElabDebugTarget != null) {
                this.runtimeElabDebugTarget.terminate();
                this.runtimeElabDebugTarget = null;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void reportProblemToConsole() {
        if (this.processType == MemoryMonitoringType.GEN_DOC_GUI) {
            return;
        }
        String consoleMessageFormat = this.consoleMessageFormat();
        if (consoleMessageFormat == null || consoleMessageFormat.isEmpty()) {
            return;
        }
        switch (this.processType) {
            case BUILD: 
            case LINT: 
            case GEN_DOC_BATCH: {
                DVTBuildConsole buildConsole = DVTBuildConsoleRegistry.getConsole(Utils.getProject(this.projectName));
                buildConsole.print(consoleMessageFormat);
                break;
            }
            case RUNTIME_ELAB: {
                XConsole xConsole = XConsoleRegistry.getConsole(Utils.getProject(this.projectName), false, false);
                xConsole.print(consoleMessageFormat);
                break;
            }
            case XSIM: {
                XConsole xConsole = XConsoleRegistry.getConsole(Utils.getProject(this.projectName), true, false);
                xConsole.print(consoleMessageFormat);
                break;
            }
            default: {
                return;
            }
        }
    }

    protected String consoleMessageFormat() {
        String formattedMessage;
        String message = this.computeProblemMessage();
        if (MemoryMonitorState.WARNING.equals((Object)this.monitorState)) {
            String stringFormat = DVTBuildConsole.MEMORY_MONITOR_CONSOLE_WARNING_MESSAGE_FORMAT;
            formattedMessage = MessageFormat.format(stringFormat, message);
        } else {
            String stringFormat = DVTBuildConsole.MEMORY_MONITOR_CONSOLE_ERROR_MESSAGE_FORMAT;
            formattedMessage = MessageFormat.format(stringFormat, message);
        }
        return formattedMessage;
    }

    protected String computeProblemMarkerMessage() throws NullPointerException {
        if (!MemoryMonitorState.WARNING.equals((Object)this.monitorState) && !MemoryMonitorState.ERROR.equals((Object)this.monitorState)) {
            return "";
        }
        StringBuilder problemSb = new StringBuilder();
        switch (this.processType) {
            case BUILD: {
                problemSb.append("Build");
                break;
            }
            case LINT: {
                problemSb.append("Lint");
                break;
            }
            case GEN_DOC_GUI: {
                problemSb.append("HTML Documentation Generation");
                break;
            }
            case RUNTIME_ELAB: {
                problemSb.append("UVM Runtime Elaboration");
                break;
            }
            case XSIM: {
                problemSb.append("DVT Run All");
                break;
            }
            default: {
                return "";
            }
        }
        problemSb.append(" ");
        problemSb.append(MemoryMonitorState.WARNING.equals((Object)this.monitorState) ? "performance will improve if you restart the tool with an increased heap memory size." : "stopped because the tool has run out of memory,");
        if (MemoryMonitorState.ERROR.equals((Object)this.monitorState)) {
            problemSb.append(" ").append("restart with").append(" ").append(this.computeSuggestedMemory()).append(".");
        }
        return problemSb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String computeProblemMessage() {
        try {
            String messageHeader;
            String toolName;
            if (!MemoryMonitorState.WARNING.equals((Object)this.monitorState) && !MemoryMonitorState.ERROR.equals((Object)this.monitorState)) {
                return "";
            }
            switch (this.processType) {
                case BUILD: {
                    toolName = "dvt.sh";
                    messageHeader = "Build";
                    break;
                }
                case LINT: {
                    toolName = "verissimo.sh";
                    messageHeader = "Lint";
                    break;
                }
                case GEN_DOC_GUI: 
                case GEN_DOC_BATCH: {
                    toolName = "specador.sh";
                    messageHeader = "HTML Documentation Generation";
                    break;
                }
                case RUNTIME_ELAB: {
                    toolName = "dvt.sh";
                    messageHeader = "UVM Runtime Elaboration";
                    break;
                }
                case XSIM: {
                    toolName = "dvt.sh";
                    messageHeader = "DVT Run All";
                    break;
                }
                default: {
                    return "";
                }
            }
            String suggestedMemory = this.computeSuggestedMemory();
            if (MemoryMonitorState.WARNING.equals((Object)this.monitorState)) {
                String stringFormat = MemoryMonitorConstants.MEMORY_MONITOR_POPUP_WARNING_MESSAGE_FORMAT;
                return MessageFormat.format(stringFormat, messageHeader, this.projectName, toolName, suggestedMemory);
            }
            String stringFormat = MemoryMonitorConstants.MEMORY_MONITOR_POPUP_ERROR_MESSAGE_FORMAT;
            return MessageFormat.format(stringFormat, messageHeader, this.projectName, suggestedMemory, toolName, suggestedMemory, this.computeCustomStopThMessage());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    protected String computeCustomStopThMessage() {
        if (this.isProactiveMode) {
            return String.valueOf(MemoryMonitorConstants.PROACTIVE_MODE_MESSAGE) + this.stopOperationPercentageTh + "%!";
        }
        if (this.hasCustomStopOpTh) {
            return String.valueOf(MemoryMonitorConstants.CUSTOM_STOP_OP_TH_MESSAGE) + this.stopOperationPercentageTh + "%!";
        }
        return "";
    }

    protected String computeSuggestedMemory() {
        try {
            double suggestedMemory;
            double heapMaxSize = DVTUtilsCommon.INSTANCE.convertMbToGb(MemoryMonitorConstants.HEAP_MAX_SIZE);
            double d = suggestedMemory = BuildState.PARSING.equals((Object)BuildStateProvider.getInstance().getBuildState()) ? heapMaxSize * 2.0 : heapMaxSize * 1.5;
            if (heapMaxSize < 32.0 && suggestedMemory >= 32.0) {
                suggestedMemory = suggestedMemory - 32.0 + 48.0;
            }
            DecimalFormat dec = new DecimalFormat("#0");
            return String.valueOf(dec.format(Math.ceil(suggestedMemory))) + "G";
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return "";
        }
    }

    protected void notifyMemoryIssue() {
        try {
            this.reportProblemToConsole();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public MemoryMonitorState getMonitorState() {
        if (!this.monitorIsEnabled) {
            return MemoryMonitorState.NONE;
        }
        return this.monitorState;
    }

    public Object getMonitorStateLock() {
        return this.monitorStateLock;
    }

    public MemoryMonitoringType getProcessType() {
        return this.processType;
    }

    public void setDebugParameters(Integer customStartDelay, Integer customTimeInGcPerWindowPercent, Integer customWarningPercentage, Integer customGcTimeWindowPercentage, Double forceStopTh, boolean ignoreWarning) {
        this.debugParamsWrapper = new MemoryMonitorDebugParametersWrapper(customStartDelay, customTimeInGcPerWindowPercent, customWarningPercentage, customGcTimeWindowPercentage, forceStopTh, ignoreWarning);
    }

    protected abstract String computeProjectName(String var1);

    protected abstract void addProblemMarker();

    protected boolean isInhibited() {
        return TestHelper.memoryMonitorIsInhibited() || this.automaticallyDisableMemoryMonitor;
    }

    protected void reportProblemToBuildReport() {
        if (this.processType != MemoryMonitoringType.BUILD || MemoryMonitorState.STARTED.equals((Object)this.monitorState)) {
            return;
        }
        DVTBuildConsole console = DVTBuildConsoleRegistry.getConsole(Utils.getProject(this.projectName));
        console.getReportModel().addMessage(this.consoleMessageFormat());
    }
}

