/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.memorymonitor;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.memorymonitor.MemoryMonitoringType;

public abstract class MemoryDialog
extends MessageDialog {
    protected MemoryDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    private static String computeOperationName() {
        return switch (MemoryMonitor.getInstance().getProcessType()) {
            case MemoryMonitoringType.BUILD -> "Building";
            case MemoryMonitoringType.LINT -> "Linting";
            case MemoryMonitoringType.GEN_DOC_GUI -> "Generating Documentation for";
            case MemoryMonitoringType.RUNTIME_ELAB -> "Performing UVM Runtime Elaboration";
            case MemoryMonitoringType.XSIM -> "Performing DVT Run All";
            default -> "";
        };
    }

    protected static String computeTitle(String titleHeader, String projectName) {
        return String.valueOf(titleHeader) + " " + MemoryDialog.computeOperationName() + " '" + projectName + "'";
    }
}

