/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.memorymonitor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.memorymonitor.AMemoryMonitorCommon;
import ro.amiq.dvt.memorymonitor.MemoryMonitorErrorDialog;
import ro.amiq.dvt.memorymonitor.MemoryMonitorState;
import ro.amiq.dvt.memorymonitor.MemoryWarningDialog;
import ro.amiq.dvt.model.problems.DVTProblemCategories;
import ro.amiq.dvt.model.problems.DVTProblemCategory;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.Utils;

public class MemoryMonitor
extends AMemoryMonitorCommon {
    private boolean displayWarning = DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.MEMORY_MONITOR_DISPLAY_WARNING_POPUP");
    private static final MemoryMonitor INSTANCE = new MemoryMonitor();

    private MemoryMonitor() {
    }

    public static void loadMonitor() {
    }

    public static MemoryMonitor getInstance() {
        return INSTANCE;
    }

    @Override
    protected void notifyMemoryIssue() {
        try {
            if (this.shouldDisplayPopup()) {
                this.openDialog();
            }
            super.notifyMemoryIssue();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean shouldDisplayPopup() {
        if (TestHelper.isTestMode()) {
            return false;
        }
        if (MemoryMonitorState.ERROR.equals((Object)this.monitorState)) {
            return true;
        }
        return this.displayWarning;
    }

    @Override
    protected String computeProjectName(String projectName) {
        return projectName == null ? "unknown" : projectName;
    }

    @Override
    protected void memoryWarning(long heapFreeSize) {
        try {
            super.memoryWarning(heapFreeSize);
            this.notifyMemoryIssue();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected void addProblemMarker() {
        try {
            DVTProblemCategory problemCategory = DVTProblemCategories.MEMORY_MONITOR;
            IProject project = Utils.getProject(this.projectName);
            project.deleteMarkers(problemCategory.getMarkerId(), false, 0);
            if (!MemoryMonitorState.WARNING.equals((Object)this.monitorState) && !MemoryMonitorState.ERROR.equals((Object)this.monitorState)) {
                return;
            }
            IMarker memMarker = project.createMarker(problemCategory.getMarkerId());
            memMarker.setAttribute("severity", MemoryMonitorState.WARNING.equals((Object)this.monitorState) ? 1 : 2);
            memMarker.setAttribute("message", (Object)this.computeProblemMarkerMessage());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void openDialog() {
        Display.getDefault().asyncExec(() -> {
            if (MemoryMonitorState.WARNING.equals((Object)this.monitorState)) {
                MemoryWarningDialog.openMemoryMonitorWarningDialog(this.projectName);
                return;
            }
            MemoryWarningDialog.closeMemoryDialog();
            MemoryMonitorErrorDialog.openMemoryMonitorErrorDialog(this.projectName);
        });
    }

    public void setDisplayWarning(boolean displayWarning) {
        this.displayWarning = displayWarning;
    }
}

