/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.memorymonitor;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.memorymonitor.MemoryDialog;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;

public class MemoryWarningDialog
extends MemoryDialog {
    private static final String DONT_SHOW_AGAIN_MESSAGE = "Don't show again";
    private static final String TITLE_HEADER = "Low Memory While";
    private static MessageDialog dialog;

    private MemoryWarningDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    public static void openMemoryMonitorWarningDialog(String projectName) {
        dialog = new MemoryWarningDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), MemoryWarningDialog.computeTitle(TITLE_HEADER, projectName), null, MemoryMonitor.getInstance().computeProblemMessage().trim(), 4, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        Button checkbox = new Button(container, 32);
        checkbox.setText(DONT_SHOW_AGAIN_MESSAGE);
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Button source = (Button)e.getSource();
                MemoryMonitor.getInstance().setDisplayWarning(!source.getSelection());
                DVTPlugin.getDefault().getPreferenceStore().setValue("ro.amiq.dvt.MEMORY_MONITOR_DISPLAY_WARNING_POPUP", !source.getSelection());
                DVTPlugin.getDefault().savePreferences();
            }
        });
        return area;
    }

    public static void closeMemoryDialog() {
        if (dialog == null) {
            return;
        }
        dialog.close();
        dialog = null;
    }
}

