/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.DVTElement;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTFileUtils;

public class DVTFile
extends DVTElement
implements IDVTFile {
    private IFile fFile;
    private Object fAST;
    private ArrayList fErrors;
    private ArrayList fWarnings;
    private ArrayList fTasks;

    public DVTFile(IFile iFile) {
        this.fFile = iFile;
    }

    @Override
    public IResource getResource() {
        return this.fFile;
    }

    @Override
    public IFile getFile() {
        return this.fFile;
    }

    @Override
    public ParserPath getParserPath() {
        IFile file = this.getFile();
        if (file == null) {
            return null;
        }
        IPath location = file.getLocation();
        if (location == null) {
            return null;
        }
        return DVTFileUtils.getInstance().resource2parser((IResource)file);
    }

    @Override
    public void setAST(Object ast) {
        this.fAST = ast;
    }

    @Override
    public Object getAST() {
        return this.fAST;
    }

    @Override
    public void setErrors(Collection errors) {
        if (errors != null) {
            this.fErrors = new ArrayList(errors.size());
            this.fErrors.addAll(errors);
        } else {
            this.fErrors = new ArrayList();
        }
    }

    @Override
    public List getErrors() {
        return this.fErrors;
    }

    @Override
    public void setTasks(Collection tasks) {
        if (tasks != null) {
            this.fTasks = new ArrayList(tasks.size());
            this.fTasks.addAll(tasks);
        } else {
            this.fTasks = new ArrayList();
        }
    }

    @Override
    public List getTasks() {
        return this.fTasks;
    }

    @Override
    public void setWarnings(Collection warnings) {
        if (warnings != null) {
            this.fWarnings = new ArrayList(warnings.size());
            this.fWarnings.addAll(warnings);
        } else {
            this.fWarnings = new ArrayList();
        }
    }

    @Override
    public List getWarnings() {
        return this.fWarnings;
    }

    @Override
    public void scheduleReparse(boolean wait, boolean force, long delay, boolean saveRFDM) {
    }

    @Override
    public void scheduleReparse(boolean wait, boolean force, long delay, IDocument document, boolean saveRFDM) {
    }

    @Override
    public void reparse(IProgressMonitor monitor, boolean saveRFDM) {
    }

    @Override
    public void reparse(IProgressMonitor monitor, String documentContent, boolean saveRFDM) {
    }

    @Override
    public void cancelReparse() {
    }

    public boolean isBuilderEnabled(String natureID) {
        return true;
    }

    @Override
    public void blockingReparse(IProgressMonitor progressMonitor, IDocument document) {
    }
}

