/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.buildconfig.BuildConfigBuilder;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleCommon;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.memorymonitor.MemoryMonitorState;
import ro.amiq.dvt.model.BuildState;
import ro.amiq.dvt.model.BuildStateProvider;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.IDVTBuildContributor;
import ro.amiq.dvt.model.indexer.AbstractIdentifierIndexer;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfProjectState;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.utils.benchmark.StopWatch;

public class DVTMixedLangBuilder
extends IncrementalProjectBuilder {
    public static final String ID = "ro.amiq.dvt.MixedLangBuilder";
    public static final String DVT_BUILD_EXTENSION_POINT_ID = "ro.amiq.dvt.buildContributors";
    public static final String DVT_BUILD_CONTRIBUTOR_PRIORITY = "priority";
    public static final String DVT_BUILD_CONTRIBUTOR_ELEMENT = "buildContributor";
    private static final List<IDVTBuildContributor> fBuildContributors = DVTMixedLangBuilder.getBuildContributors();
    private static final String MIXED_LANG_BUILDER_CALLER_NAME = "Mixed Lang Builder";
    private static final String FAILED_TO_SERIALIZE_BC_ERROR = "Error: Failed to serialize active build config.";
    public static final QualifiedName BUILD_KIND_QNAME = new QualifiedName("", "BUILD_KIND_QNAME");
    public static final String FULL_BUILD_QNAME_VALUE = "FULL_BUILD";
    public static AtomicBoolean fBuildDone;

    public IProject[] build(final int kind, final Map args, final IProgressMonitor monitor) throws CoreException {
        if (kind == 6 || (kind == 10 || kind == 9) && this.getDelta(this.getProject()) == null) {
            try {
                Job.getJobManager().currentJob().setProperty(BUILD_KIND_QNAME, (Object)FULL_BUILD_QNAME_VALUE);
            }
            catch (Exception ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
            }
        }
        try {
            if (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isStarting()) {
                return null;
            }
            DVTAutoLinkManager.getInstance().cleanFileInfoCache();
            if (args != null && args.containsKey("justClean") && args.get("justClean").equals("true")) {
                return null;
            }
            final IProject project = this.getProject();
            TestHelper.fAutoLinkTime = 0.0;
            final DVTBuildConsole console = DVTBuildConsoleRegistry.getConsole(this.getProject());
            DVTAutoLinkManager.IAutoLinkOperation op = new DVTAutoLinkManager.IAutoLinkOperation(){

                @Override
                public void run(Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                    DVTMixedLangBuilder.this.internalBuild(kind, args, project, console, monitor);
                }
            };
            DVTAutoLinkManager.getInstance().modifyWorkspaceOperation(project, MIXED_LANG_BUILDER_CALLER_NAME, op, false);
            DVTAutoLinkManager.getInstance().printFileInfoCacheStat();
            DVTAutoLinkManager.getInstance().cleanFileInfoCache();
            boolean wasBuildCanceled = monitor.isCanceled();
            if (kind == 6) {
                StopWatch.stop("[BUILD]  total");
                console.printSection("Total build time [" + StopWatch.get("[BUILD]  total").timeFormatted() + "]");
                console.buildDone();
                BuildStateProvider.getInstance().setBuildState(BuildState.NOT_BUILDING);
                if (MemoryMonitorState.ERROR.equals((Object)MemoryMonitor.getInstance().getMonitorState())) {
                    wasBuildCanceled = true;
                }
                MemoryMonitor.getInstance().stopMemoryMonitor();
            } else if (kind == 10 || kind == 9) {
                StopWatch.stop("[BUILD]  incremental");
            }
            DVTMixedLangModelManager.getInstance().fireBuildDone(IBuildDoneListener.BuildFinishReason.computeBuildFinishReason(kind, wasBuildCanceled), project.getName());
            try {
                Utils.swapGrayEditors(project);
                this.resetAutobuildState(project);
            }
            catch (Throwable e) {
                DVTLogger.INSTANCE.logError(e);
            }
            monitor.done();
            ObjectionManager.getInstance().clear(Objection.BUILD_DONE);
            return null;
        }
        finally {
            try {
                Job.getJobManager().currentJob().setProperty(BUILD_KIND_QNAME, null);
            }
            catch (Exception ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
            }
        }
    }

    private void resetAutobuildState(IProject project) throws CoreException {
        if (project.getPersistentProperty(IDVTConstants.PROJECT_BUILT) == null) {
            project.setPersistentProperty(IDVTConstants.PROJECT_BUILT, "PROJECT_BUILT");
        }
    }

    /*
     * Exception decompiling
     */
    public void internalBuild(int kind, Map args, IProject project, DVTBuildConsole console, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 35[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void serializeBuildConfig(final IProject project) {
        Job serializeJob = new Job("Serialize Build Configuration"){

            protected IStatus run(IProgressMonitor monitor) {
                if (project.getLocation() == null) {
                    return Status.CANCEL_STATUS;
                }
                Path buildConfigsDefaultDirectoryPath = (Path)project.getLocation().append(".dvt").append(".build_config_dict");
                if (!BuildConfigManagerCommon.saveBuildConfig(BuildConfigManagerCommon.getBuildConfig(project), buildConfigsDefaultDirectoryPath)) {
                    DVTLogger.INSTANCE.logError(DVTMixedLangBuilder.FAILED_TO_SERIALIZE_BC_ERROR);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        serializeJob.schedule();
    }

    private void clearCanonicalPathCaches() {
        AbstractIdentifierIndexer.clearPhysicalPathCache();
        BuildConfigManager.clearCanonicalPathCache();
    }

    private void finalizeBuildAutoLink(final IProject project, IProgressMonitor monitor, int kind) throws CoreException {
        if (kind == 6) {
            DVTBuildConsoleRegistry.getConsole(project).printSection("Start adding/validating the DVT Auto-Linked resources", DVTBuildConsoleCommon.MessageSink.CONSOLE);
        }
        DVTAutoLinkManager.getInstance().startWorkspaceOperation(project, true);
        if (!monitor.isCanceled()) {
            DVTAutoLinkManager.IAutoLinkOperation op = new DVTAutoLinkManager.IAutoLinkOperation(){

                @Override
                public void run(Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                    DVTAutoLinkManager.getInstance().removeDirtyAutoLink(project, "DVT Auto-Linked", cachedLinksMap);
                }
            };
            DVTAutoLinkManager.getInstance().modifyWorkspaceOperation(project, MIXED_LANG_BUILDER_CALLER_NAME, op, false);
        }
        DVTAutoLinkManager.getInstance().endWorkspaceOperation(project, false);
        if (kind == 6) {
            DVTBuildConsoleRegistry.getConsole(project).printSection("Done adding/validating the DVT Auto-Linked resources [" + StopWatch.formatTime((long)TestHelper.fAutoLinkTime) + "]");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void clean(IProgressMonitor monitor) throws CoreException {
        block10: {
            block9: {
                super.clean(monitor);
                project = this.getProject();
                delegates = DVTMixedLangBuilder.getEnabledContributors(project);
                if (delegates.isEmpty()) {
                    return;
                }
                try {
                    try {
                        DVTBuildConsoleRegistry.getConsole(project).clean();
                        DVTAutoLinkManager.getInstance().cleanFileInfoCache();
                        DVTAutoLinkManager.getInstance().cleanCachedLinks(project);
                        rfMixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
                        rfMixedLangProject.syncCancelSave();
                        rfMixedLangProject.setProjectState(RfProjectState.CLEANED);
                        monitor.beginTask("DVT Internal Builder", delegates.size() * 100);
                        BuildEventManager.getInstance().notifyCleanBuild(project);
                        Collections.sort(delegates, new Comparator<IDVTBuildContributor>(){

                            @Override
                            public int compare(IDVTBuildContributor o1, IDVTBuildContributor o2) {
                                return o1 instanceof BuildConfigBuilder ? 1 : -1;
                            }
                        });
                        for (IDVTBuildContributor delegate : delegates) {
                            delegate.setProject(project);
                            delegate.setParentBuilder(this);
                            delegate.clean((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                            monitor.worked(100);
                        }
                        monitor.done();
                        break block9;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        ** for (delegate : delegates)
                    }
                }
                catch (Throwable var7_14) {
                    ** for (delegate : delegates)
                }
lbl-1000:
                // 1 sources

                {
                    delegate.setParentBuilder(null);
                    continue;
lbl30:
                    // 1 sources

                    break block10;
                }
lbl-1000:
                // 1 sources

                {
                    delegate.setParentBuilder(null);
                    continue;
                }
lbl35:
                // 1 sources

                throw var7_14;
            }
            for (IDVTBuildContributor delegate : delegates) {
                delegate.setParentBuilder(null);
            }
        }
    }

    public static List<IDVTBuildContributor> getEnabledContributors(IProject project) {
        if (fBuildContributors == null) {
            return Collections.emptyList();
        }
        ArrayList<IDVTBuildContributor> result = new ArrayList<IDVTBuildContributor>(3);
        for (IDVTBuildContributor buildContributor : fBuildContributors) {
            if (!buildContributor.isEnabled(project)) continue;
            result.add(buildContributor);
        }
        return result;
    }

    private static List<IDVTBuildContributor> getBuildContributors() {
        ArrayList<IDVTBuildContributor> delegates = new ArrayList<IDVTBuildContributor>();
        try {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DVT_BUILD_EXTENSION_POINT_ID);
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    if (!DVT_BUILD_CONTRIBUTOR_ELEMENT.equals(configurationElement.getName())) {
                        DVTLogger.INSTANCE.logError((Throwable)new Exception("Invalid element: " + configurationElement + "for extension point: " + DVT_BUILD_EXTENSION_POINT_ID));
                    }
                    IDVTBuildContributor buildContributor = (IDVTBuildContributor)configurationElement.createExecutableExtension("class");
                    buildContributor.setPriority(configurationElement.getAttribute(DVT_BUILD_CONTRIBUTOR_PRIORITY));
                    delegates.add(buildContributor);
                    ++n4;
                }
                ++n2;
            }
            Collections.sort(delegates, new Comparator<IDVTBuildContributor>(){

                @Override
                public int compare(IDVTBuildContributor bc1, IDVTBuildContributor bc2) {
                    return bc1.getPriority() - bc2.getPriority();
                }
            });
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return delegates;
    }

    public static int getBuilderPriorityForNature(String natureID) {
        if (fBuildContributors == null) {
            return Integer.MAX_VALUE;
        }
        for (IDVTBuildContributor buildContributor : fBuildContributors) {
            if (!buildContributor.hasNature(natureID)) continue;
            return buildContributor.getPriority();
        }
        return Integer.MAX_VALUE;
    }
}

