/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ListenerList;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.ChecksKindWrapper;
import ro.amiq.dvt.buildconfig.IncrementalElaborationKind;
import ro.amiq.dvt.model.DVTModelManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.IBuildStatusListener;
import ro.amiq.dvt.model.IXvmFactoryInitListener;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.BuildEventManager;

public class DVTMixedLangModelManager {
    private ListenerList fBuildDoneListeners = new ListenerList();
    private ListenerList fBuildStatusListeners = new ListenerList();
    private ListenerList fXvmFactoryInitListeners = new ListenerList();
    private static volatile DVTMixedLangModelManager fInstance = null;
    private static final Object fSyncInstance = new Object();
    private List<DVTModelManager> fSingleLangModelManagers = new ArrayList<DVTModelManager>();

    public void addBuildDoneListener(IBuildDoneListener listener) {
        this.fBuildDoneListeners.add((Object)listener);
    }

    public void removeBuildDoneListener(IBuildDoneListener listener) {
        this.fBuildDoneListeners.remove((Object)listener);
    }

    public void addBuildStatusListener(IBuildStatusListener listener) {
        this.fBuildStatusListeners.add((Object)listener);
    }

    public void removeBuildStatusListener(IBuildStatusListener listener) {
        this.fBuildStatusListeners.remove((Object)listener);
    }

    public void addXvmFactoryInitListeners(IXvmFactoryInitListener listener) {
        this.fXvmFactoryInitListeners.add((Object)listener);
    }

    public void removeXvmFactoryInitListeners(IXvmFactoryInitListener listener) {
        this.fXvmFactoryInitListeners.remove((Object)listener);
    }

    public ListenerList getXvmFactoryInitListeners() {
        return this.fXvmFactoryInitListeners;
    }

    public void fireBuildDone(IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
        Object[] objectArray = this.fBuildDoneListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object i = objectArray[n2];
            try {
                ((IBuildDoneListener)i).buildDone(buildFinishReason, projectName);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DVTMixedLangModelManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new DVTMixedLangModelManager();
            }
        }
        return fInstance;
    }

    public synchronized void registerModelManager(DVTModelManager modelManager) {
        if (!this.fSingleLangModelManagers.contains(modelManager)) {
            this.fSingleLangModelManagers.add(modelManager);
        }
        Collections.sort(this.fSingleLangModelManagers, new Comparator<DVTModelManager>(){

            @Override
            public int compare(DVTModelManager mm1, DVTModelManager mm2) {
                return mm1.getPriority() - mm2.getPriority();
            }
        });
    }

    private synchronized DVTModelManager[] singleLangModelManagersCopy() {
        DVTModelManager[] singleLangModelManagers = new DVTModelManager[this.fSingleLangModelManagers.size()];
        return this.fSingleLangModelManagers.toArray(singleLangModelManagers);
    }

    public void notifyBuildListenersPostIncrementalBuild(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) {
        DVTModelManager[] singleLangModelManagers;
        DVTModelManager[] dVTModelManagerArray = singleLangModelManagers = this.singleLangModelManagersCopy();
        int n = singleLangModelManagers.length;
        int n2 = 0;
        while (n2 < n) {
            DVTModelManager singleLangModelManager = dVTModelManagerArray[n2];
            singleLangModelManager.notifyBuildListenersPostIncrementalBuild(project, changedFiles);
            ++n2;
        }
    }

    public void notifyBuildListenersMixedLangPostIncrementalBuild(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles, IncrementalElaborationKind incrementalElaborationKind) {
        HashSet<String> updateViewIds = new HashSet<String>();
        this.notifyBuildListenersMixedLangPostIncrementalBuildElab(project, changedFiles, updateViewIds, incrementalElaborationKind);
        BuildEventManager.getInstance().notifyIncrementalBuild(project, changedFiles, updateViewIds);
        if (BuildConfigManager.getPrecompiledDbMode(project) == BuildConfigManagerCommon.PrecompileGlobalMode.NO_GLOBAL_PRECOMPILE) {
            DVTProblemManager.getInstance().save(project);
        }
    }

    private void notifyBuildListenersMixedLangPostIncrementalBuildElab(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles, Set<String> updateViewIds, IncrementalElaborationKind incrementalElaborationKind) {
        Set<FileCompileInfo> changedVHDLFiles;
        DVTModelManager[] singleLangModelManagers;
        DVTModelManager[] dVTModelManagerArray = singleLangModelManagers = this.singleLangModelManagersCopy();
        int n = singleLangModelManagers.length;
        int n2 = 0;
        while (n2 < n) {
            DVTModelManager singleLangModelManager = dVTModelManagerArray[n2];
            singleLangModelManager.notifyBuildListenersMixedLangPostIncrementalBuildPreElab(project, changedFiles, updateViewIds);
            ++n2;
        }
        Set<FileCompileInfo> changedVLOGFiles = changedFiles != null ? changedFiles.get((Object)LanguageKind.VLOG) : null;
        Set<FileCompileInfo> set = changedVHDLFiles = changedFiles != null ? changedFiles.get((Object)LanguageKind.VHDL) : null;
        if (changedVLOGFiles != null && !changedVLOGFiles.isEmpty() || changedVHDLFiles != null && !changedVHDLFiles.isEmpty()) {
            RfMixedLangManager.getInstance().incrementalElaborate(project, incrementalElaborationKind);
        }
        DVTModelManager[] dVTModelManagerArray2 = singleLangModelManagers;
        int n3 = singleLangModelManagers.length;
        int n4 = 0;
        while (n4 < n3) {
            DVTModelManager singleLangModelManager = dVTModelManagerArray2[n4];
            singleLangModelManager.notifyBuildListenersMixedLangPostIncrementalBuildPostElab(project, changedFiles, updateViewIds);
            ++n4;
        }
    }

    public void notifyBuildListenersBuildConfigPostIncrementalBuild(IProject project) {
        DVTModelManager[] singleLangModelManagers;
        DVTModelManager[] dVTModelManagerArray = singleLangModelManagers = this.singleLangModelManagersCopy();
        int n = singleLangModelManagers.length;
        int n2 = 0;
        while (n2 < n) {
            DVTModelManager singleLangModelManager = dVTModelManagerArray[n2];
            singleLangModelManager.notifyBuildListenersBuildConfigPostIncrementalBuild(project);
            ++n2;
        }
        DVTProblemManager.getInstance().save(project);
    }

    protected void notifyBuildListenersPostFullBuild(IProject project) {
        this.notifyBuildListenersPostFullBuildElab(project);
        BuildEventManager.getInstance().notifyFullBuild(project);
        DVTProblemManager.getInstance().save(project);
    }

    private void notifyBuildListenersPostFullBuildElab(IProject project) {
        DVTModelManager singleLangModelManager;
        DVTModelManager[] singleLangModelManagers;
        DVTModelManager[] dVTModelManagerArray = singleLangModelManagers = this.singleLangModelManagersCopy();
        int n = singleLangModelManagers.length;
        int n2 = 0;
        while (n2 < n) {
            singleLangModelManager = dVTModelManagerArray[n2];
            singleLangModelManager.notifyBuildListenersMixedLangPostFullBuildPreElab(project);
            ++n2;
        }
        RfMixedLangManager.getInstance().elaborate(project, true, false);
        dVTModelManagerArray = singleLangModelManagers;
        n = singleLangModelManagers.length;
        n2 = 0;
        while (n2 < n) {
            singleLangModelManager = dVTModelManagerArray[n2];
            singleLangModelManager.notifyBuildListenersMixedLangPostFullBuildPostElab(project);
            ++n2;
        }
    }

    public void notifyBuildListenersExtendedCkecksBuild(IProject project, ChecksKindWrapper checksKindWrapper) {
        DVTModelManager[] singleLangModelManagers;
        DVTModelManager[] dVTModelManagerArray = singleLangModelManagers = this.singleLangModelManagersCopy();
        int n = singleLangModelManagers.length;
        int n2 = 0;
        while (n2 < n) {
            DVTModelManager singleLangModelManager = dVTModelManagerArray[n2];
            singleLangModelManager.notifyBuildListenersExtendedCkecksBuild(project, checksKindWrapper);
            ++n2;
        }
        DVTProblemManager.getInstance().save(project);
    }

    public void notifyBuildStatusListeners(boolean buildCanceled) {
        Object[] objectArray = this.fBuildStatusListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IBuildStatusListener)listener).status(buildCanceled ? 1 : 0);
            ++n2;
        }
    }
}

