/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import ro.amiq.dvt.model.DVTElement;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.IDVTModel;
import ro.amiq.dvt.model.IDVTProject;

public abstract class DVTModel
extends DVTElement
implements IDVTModel {
    private HashMap<IFile, IDVTFile> filesCache;
    private HashMap<IProject, IDVTProject> projectsCache;

    @Override
    public IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private HashMap<IFile, IDVTFile> getModulesCache() {
        if (this.filesCache == null) {
            this.filesCache = new HashMap();
        }
        return this.filesCache;
    }

    private HashMap<IProject, IDVTProject> getProjectsCache() {
        if (this.projectsCache == null) {
            this.projectsCache = new HashMap();
        }
        return this.projectsCache;
    }

    @Override
    public synchronized IDVTFile getOrCreateIDVTFile(IFile file) {
        if (file != null) {
            HashMap<IFile, IDVTFile> cache = this.getModulesCache();
            if (cache.containsKey(file)) {
                return cache.get(file);
            }
            IDVTFile newModule = this.createIDVTFile(file);
            cache.put(file, newModule);
            return newModule;
        }
        return null;
    }

    @Override
    public synchronized IDVTFile getIDVTFile(IFile file) {
        HashMap<IFile, IDVTFile> cache;
        if (file != null && (cache = this.getModulesCache()).containsKey(file)) {
            return cache.get(file);
        }
        return null;
    }

    @Override
    public IDVTProject getIDVTProject(IProject project) {
        if (project != null) {
            HashMap<IProject, IDVTProject> cache = this.getProjectsCache();
            if (cache.containsKey(project)) {
                return cache.get(project);
            }
            IDVTProject newProject = this.createIDVTProject(project);
            cache.put(project, newProject);
            return newProject;
        }
        return null;
    }

    @Override
    public void cleanIDVTProject(IProject project) {
        this.filesCache = null;
        this.projectsCache = null;
    }
}

