/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.ChecksKindWrapper;
import ro.amiq.dvt.model.DVTFileInfo;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IDVTBuildListener;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.IDVTMixedLangBuildListener;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.model.IDVTReparseListener;
import ro.amiq.dvt.model.floatingwidgets.DVTFNotificationProvider;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyFile;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.ui.preferences.PreferenceUtils;

public abstract class DVTModelManager {
    private List<IDVTReparseListener> fReparseListeners = new ArrayList<IDVTReparseListener>();
    private final Object fSyncReparseListenersAccess = new Object();
    private List<IDVTBuildListener> fBuildListeners = new ArrayList<IDVTBuildListener>();
    private final Object fSyncBuildListenersAccess = new Object();

    public abstract int getPriority();

    public abstract void saveUnfinishedJobs(IProject var1);

    public void cbClean(IProject project, boolean compilePredef) {
        this.cbClean(project);
    }

    public abstract void cbClean(IProject var1);

    public abstract void cbClean(IFile var1);

    public abstract void cbBuild(DVTFileInfo var1);

    public abstract void cbPostFullBuild(IProject var1, boolean var2);

    public abstract void cbIncrementalBuild(IProgressMonitor var1, FileCompileInfo var2, IDocument var3, boolean var4);

    public abstract void cbRemove(IFile var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReparseListener(IDVTReparseListener listener) {
        Object object = this.fSyncReparseListenersAccess;
        synchronized (object) {
            this.fReparseListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReparseListener(IDVTReparseListener listener) {
        Object object = this.fSyncReparseListenersAccess;
        synchronized (object) {
            this.fReparseListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReparseListeners(int buildKind, int type, List<IDVTFile> files) {
        ArrayList<IDVTReparseListener> workingCopyReparseListeners = new ArrayList<IDVTReparseListener>();
        Object object = this.fSyncReparseListenersAccess;
        synchronized (object) {
            workingCopyReparseListeners.addAll(this.fReparseListeners);
        }
        if (files != null && !files.isEmpty()) {
            for (IDVTFile file : files) {
                if (file == null || file.getFile() == null || file.getFile().getLocation() == null) {
                    return;
                }
                for (IDVTReparseListener reparseListener : workingCopyReparseListeners) {
                    reparseListener.reparsed(buildKind, type, (IResource)file.getFile(), file.getErrors(), file.getWarnings(), file.getTasks());
                }
                file.setErrors(null);
                file.setWarnings(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReparseListeners(int buildKind, IProject project) {
        ArrayList<IDVTReparseListener> workingCopyReparseListeners = new ArrayList<IDVTReparseListener>();
        Object object = this.fSyncReparseListenersAccess;
        synchronized (object) {
            workingCopyReparseListeners.addAll(this.fReparseListeners);
        }
        for (IDVTReparseListener reparseListener : workingCopyReparseListeners) {
            reparseListener.reparsed(buildKind, 0, (IResource)project, null, null, null);
        }
    }

    public void notifyReparseListeners(int buildKind, int type, IDVTFile file) {
        ArrayList<IDVTFile> files = new ArrayList<IDVTFile>(1);
        if (file != null) {
            files.add(file);
        }
        this.notifyReparseListeners(buildKind, type, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBuildListener(IDVTBuildListener listener) {
        Object object = this.fSyncBuildListenersAccess;
        synchronized (object) {
            this.fBuildListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBuildListener(IDVTBuildListener listener) {
        Object object = this.fSyncBuildListenersAccess;
        synchronized (object) {
            this.fBuildListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyBuildListenersClean(IDVTProject project, boolean compilePredef) {
        ArrayList<IDVTBuildListener> buildListeners = new ArrayList<IDVTBuildListener>();
        Object object = this.fSyncBuildListenersAccess;
        synchronized (object) {
            buildListeners.addAll(this.fBuildListeners);
        }
        for (IDVTBuildListener buildListener : buildListeners) {
            buildListener.clean(project, compilePredef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyBuildListenersClean(IDVTFile file) {
        ArrayList<IDVTBuildListener> buildListeners = new ArrayList<IDVTBuildListener>();
        Object object = this.fSyncBuildListenersAccess;
        synchronized (object) {
            buildListeners.addAll(this.fBuildListeners);
        }
        for (IDVTBuildListener buildListener : buildListeners) {
            buildListener.clean(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBuildListenersFullBuild(DVTFileInfo info) {
        ArrayList<IDVTBuildListener> buildListeners = new ArrayList<IDVTBuildListener>();
        Object object = this.fSyncBuildListenersAccess;
        synchronized (object) {
            buildListeners.addAll(this.fBuildListeners);
        }
        for (IDVTBuildListener buildListener : buildListeners) {
            buildListener.fullBuild(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyBuildListenersPostIncrementalBuild(DVTFileInfo info) {
        ArrayList<IDVTBuildListener> buildListeners = new ArrayList<IDVTBuildListener>();
        Object object = this.fSyncBuildListenersAccess;
        synchronized (object) {
            buildListeners.addAll(this.fBuildListeners);
        }
        for (IDVTBuildListener buildListener : buildListeners) {
            buildListener.postIncrementalBuild(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyBuildListenersIncrementalBuild(DVTFileInfo info) {
        ArrayList<IDVTBuildListener> buildListeners = new ArrayList<IDVTBuildListener>();
        Object object = this.fSyncBuildListenersAccess;
        synchronized (object) {
            buildListeners.addAll(this.fBuildListeners);
        }
        for (IDVTBuildListener buildListener : buildListeners) {
            buildListener.incrementalBuild(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyBuildListenersPostFullBuild(IDVTProject project, boolean success) {
        ArrayList<IDVTBuildListener> buildListeners = new ArrayList<IDVTBuildListener>();
        Object object = this.fSyncBuildListenersAccess;
        synchronized (object) {
            buildListeners.addAll(this.fBuildListeners);
        }
        for (IDVTBuildListener buildListener : buildListeners) {
            buildListener.postFullBuild(project, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyBuildListenersRemove(IDVTFile eModule) {
        ArrayList<IDVTBuildListener> buildListeners = new ArrayList<IDVTBuildListener>();
        Object object = this.fSyncBuildListenersAccess;
        synchronized (object) {
            buildListeners.addAll(this.fBuildListeners);
        }
        for (IDVTBuildListener buildListener : buildListeners) {
            buildListener.remove(eModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBuildListenersPostIncrementalBuild(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) {
        ArrayList<IDVTBuildListener> buildListeners = new ArrayList<IDVTBuildListener>();
        Object object = this.fSyncBuildListenersAccess;
        synchronized (object) {
            buildListeners.addAll(this.fBuildListeners);
        }
        for (IDVTBuildListener buildListener : buildListeners) {
            if (!(buildListener instanceof IDVTMixedLangBuildListener)) continue;
            ((IDVTMixedLangBuildListener)((Object)buildListener)).postIncrementalBuild(project, changedFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBuildListenersMixedLangPostIncrementalBuildPreElab(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles, Set<String> updateViewIds) {
        ArrayList<IDVTBuildListener> buildListeners = new ArrayList<IDVTBuildListener>();
        Object object = this.fSyncBuildListenersAccess;
        synchronized (object) {
            buildListeners.addAll(this.fBuildListeners);
        }
        for (IDVTBuildListener buildListener : buildListeners) {
            if (!(buildListener instanceof IDVTMixedLangBuildListener)) continue;
            ((IDVTMixedLangBuildListener)((Object)buildListener)).postMixedLangIncrementalBuildPreElab(project, changedFiles, updateViewIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBuildListenersMixedLangPostIncrementalBuildPostElab(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles, Set<String> updateViewIds) {
        ArrayList<IDVTBuildListener> buildListeners = new ArrayList<IDVTBuildListener>();
        Object object = this.fSyncBuildListenersAccess;
        synchronized (object) {
            buildListeners.addAll(this.fBuildListeners);
        }
        for (IDVTBuildListener buildListener : buildListeners) {
            if (!(buildListener instanceof IDVTMixedLangBuildListener)) continue;
            ((IDVTMixedLangBuildListener)((Object)buildListener)).postMixedLangIncrementalBuildPostElab(project, changedFiles, updateViewIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBuildListenersBuildConfigPostIncrementalBuild(IProject project) {
        ArrayList<IDVTBuildListener> buildListeners = new ArrayList<IDVTBuildListener>();
        Object object = this.fSyncBuildListenersAccess;
        synchronized (object) {
            buildListeners.addAll(this.fBuildListeners);
        }
        for (IDVTBuildListener buildListener : buildListeners) {
            if (!(buildListener instanceof IDVTMixedLangBuildListener)) continue;
            ((IDVTMixedLangBuildListener)((Object)buildListener)).postBuildConfigIncrementalBuild(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBuildListenersMixedLangPostFullBuildPreElab(IProject project) {
        ArrayList<IDVTBuildListener> buildListeners = new ArrayList<IDVTBuildListener>();
        Object object = this.fSyncBuildListenersAccess;
        synchronized (object) {
            buildListeners.addAll(this.fBuildListeners);
        }
        for (IDVTBuildListener buildListener : buildListeners) {
            if (!(buildListener instanceof IDVTMixedLangBuildListener)) continue;
            ((IDVTMixedLangBuildListener)((Object)buildListener)).postMixedLangFullBuildPreElab(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBuildListenersMixedLangPostFullBuildPostElab(IProject project) {
        ArrayList<IDVTBuildListener> buildListeners = new ArrayList<IDVTBuildListener>();
        Object object = this.fSyncBuildListenersAccess;
        synchronized (object) {
            buildListeners.addAll(this.fBuildListeners);
        }
        for (IDVTBuildListener buildListener : buildListeners) {
            if (!(buildListener instanceof IDVTMixedLangBuildListener)) continue;
            ((IDVTMixedLangBuildListener)((Object)buildListener)).postMixedLangFullBuildPostElab(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBuildListenersExtendedCkecksBuild(IProject project, ChecksKindWrapper checksKindWrapper) {
        ArrayList<IDVTBuildListener> buildListeners = new ArrayList<IDVTBuildListener>();
        Object object = this.fSyncBuildListenersAccess;
        synchronized (object) {
            buildListeners.addAll(this.fBuildListeners);
        }
        for (IDVTBuildListener buildListener : buildListeners) {
            if (!(buildListener instanceof IDVTMixedLangBuildListener)) continue;
            ((IDVTMixedLangBuildListener)((Object)buildListener)).performExtendedChecks(project, checksKindWrapper);
        }
    }

    protected void handleFloatingNotification(DVTFNotificationProvider notificationProvider, IProject project, IFile file, boolean isParserInterrupted) {
        if (!isParserInterrupted) {
            FIncrementalNotificationTracker.INSTANCE.removeDirtyResource(project, (IResource)file);
            return;
        }
        if (PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE")) {
            return;
        }
        FIncrementalNotificationTracker.INSTANCE.addDirtyResource(project, new FIncrementalDirtyFile(file, FNotificationDirtyReason.PARSE_TIMEOUT, notificationProvider));
    }
}

