/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.compilewaivers;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.xml.sax.SAXParseException;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleCommon;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversConstants;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversUtil;
import ro.amiq.dvt.model.problems.DVTPredefinedWaivers;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemMatcher;
import ro.amiq.dvt.model.problems.DVTProblemWaiver;
import ro.amiq.dvt.model.problems.DVTProblemWaiversXMLParser;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.settings.DVTSFiles;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTStartupConstants;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.XMLException;

public enum CompileWaiversManager {
    INSTANCE;

    private Map<IProject, List<DVTProblemWaiver>> fWaiversByProject = new HashMap<IProject, List<DVTProblemWaiver>>();
    private Map<IProject, Map<DVTProblemWaiver, Integer>> fWaiversHitCountByProject = new HashMap<IProject, Map<DVTProblemWaiver, Integer>>();
    private Map<String, String> fCanonicalPathCache = new HashMap<String, String>();
    private Set<String> allCompileWaiversFilePaths;

    public synchronized void loadWaivers(IProject project) {
        try {
            List<File> predefinedWaiverFiles = BuildConfigManager.getExtraWaiverFiles(project);
            if (predefinedWaiverFiles != null) {
                for (File file2 : predefinedWaiverFiles) {
                    this.loadWaivers(project, file2, true);
                }
            }
            ArrayList<File> settingsManagedWaiversFiles = new ArrayList<File>();
            if (!DVTStartupConstants.isBatchMode((IProject)project) || DVTStartupConstants.isLSRunning.get()) {
                List<DVTProblemWaiver> waivers = this.getWaivers(project);
                waivers.addAll(DVTPredefinedWaivers.getWaivers(project));
                List sFiles = DVTSFiles.WAIVERS.getAllFiles(false);
                if (sFiles != null) {
                    settingsManagedWaiversFiles.addAll(sFiles);
                }
                File projectLevelWaiversFile = project.getFile(CompileWaiversConstants.XML_PROJECT_RELATIVE_PATH).getLocation().toFile();
                settingsManagedWaiversFiles.add(projectLevelWaiversFile);
            }
            Set<File> allWaiversFiles = CompileWaiversUtil.getInstance().createModel(project, settingsManagedWaiversFiles);
            this.allCompileWaiversFilePaths = allWaiversFiles.stream().map(file -> file.getAbsolutePath()).collect(Collectors.toSet());
            for (File file3 : allWaiversFiles) {
                if (!file3.exists()) continue;
                this.loadWaivers(project, file3, false);
            }
        }
        catch (XMLException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public List<DVTProblemWaiver> getWaivers(IProject project) {
        List<DVTProblemWaiver> result = this.fWaiversByProject.get(project);
        if (result == null) {
            result = new ArrayList<DVTProblemWaiver>();
            this.fWaiversByProject.put(project, result);
        }
        return result;
    }

    private synchronized void loadWaivers(IProject project, File file, boolean first) {
        if (!file.exists() && DVTStartupConstants.isBatchMode((IProject)project)) {
            this.reportToConsole(project, "Waivers file " + file.getAbsolutePath() + " does not exist");
            return;
        }
        String forProject = DVTStartupConstants.isBatchMode((IProject)project) ? "" : " for project " + project.getName();
        try {
            List<DVTProblemWaiver> waivers = this.getWaivers(project);
            DVTProblemWaiversXMLParser parser = DVTProblemWaiversXMLParser.newParser(project, file, true);
            List<DVTProblemWaiver> loadedWaivers = parser.load();
            loadedWaivers.sort(DVTProblemWaiver.WAIVER_ORDER_COMPARATOR);
            waivers.addAll(loadedWaivers);
            List<DVTProblemWaiversXMLParser.UnresolvedEnvWaiverProblem> unresolvedVariableWarningMessages = parser.getUnresolvedVariableWarningMessages();
            if (!unresolvedVariableWarningMessages.isEmpty()) {
                DVTProblemWaiversXMLParser.UnresolvedEnvWaiverProblem problem = unresolvedVariableWarningMessages.get(0);
                SAXParseException exception = new SAXParseException(problem.getMessage(), problem.getFile().getAbsolutePath(), problem.getFile().getAbsolutePath(), problem.getLine(), 0);
                throw new XMLException(exception, problem.getFile().getAbsolutePath());
            }
            List<DVTProblemWaiversXMLParser.InexistentFileWaiverProblem> inexistentFileWarningMessages = parser.getInexistentFileWaiversMessages();
            if (!inexistentFileWarningMessages.isEmpty()) {
                DVTProblemWaiversXMLParser.InexistentFileWaiverProblem problem = inexistentFileWarningMessages.get(0);
                SAXParseException exception = new SAXParseException(problem.getMessage(), problem.getFile().getAbsolutePath(), problem.getFile().getAbsolutePath(), problem.getLine(), 0);
                throw new XMLException(exception, problem.getFile().getAbsolutePath());
            }
            for (String message : parser.getMessages()) {
                DVTBuildConsoleRegistry.getConsole(project).print(message);
            }
            this.reportToConsole(project, "Loaded" + (first ? " (prepend)" : "") + " compile waivers from " + file.getAbsolutePath() + forProject);
            ObjectionManager.getInstance().clear(Objection.LOADED_COMPILE_WAIVERS);
        }
        catch (SAXParseException e) {
            if (this.isNonGuiApp(project)) {
                throw new XMLException(e, file.getAbsolutePath());
            }
            String msg = e.getMessage();
            this.reportToConsole(project, MessageFormat.format("*** Error: {0}\n    at line {1} in {2}{3}{4}", msg, e.getLineNumber(), file.getAbsolutePath(), "", ""));
            ViewsUtils.popOKDialog(4, "Invalid Compile Waivers", "Invalid Compile Waivers: " + msg);
            boolean isLinting = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false).isLinting();
            if (isLinting) {
                RfMixedLangManager.getInstance().getRfMixedLangProject(project, false).stopLintTracking();
                throw new XMLException(e, file.getAbsolutePath());
            }
        }
        catch (XMLException e) {
            if (this.isNonGuiApp(project)) {
                throw e;
            }
            int lineNumber = 0;
            String message = e.getMessage();
            if (e.getCause() instanceof SAXParseException) {
                SAXParseException cause = (SAXParseException)e.getCause();
                lineNumber = cause.getLineNumber();
                message = cause.getMessage();
            }
            this.reportToConsole(project, MessageFormat.format("*** Error: {0}\n    at line {1} in {2}{3}{4}", message, lineNumber, e.getFileName(), "", ""));
            ViewsUtils.popOKDialog(4, "Invalid Compile Waivers", "Invalid Compile Waivers: " + message);
            boolean isLinting = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false).isLinting();
            if (isLinting) {
                throw e;
            }
        }
        catch (Exception e) {
            this.reportToConsole(project, "Failed to load compile waivers from " + file.getAbsolutePath() + forProject + " because: ");
            String additionalInfo = "";
            if (e instanceof SAXParseException) {
                additionalInfo = "In " + ((SAXParseException)e).getSystemId() + " at line " + ((SAXParseException)e).getLineNumber() + ": ";
            }
            this.reportToConsole(project, String.valueOf(additionalInfo) + e.getMessage());
        }
    }

    boolean isNonGuiApp(IProject project) {
        return DVTStartupConstants.isBatchMode((IProject)project) && !DVTStartupConstants.isLSRunning.get();
    }

    private Map<DVTProblemWaiver, Integer> getWaiversHitCountFor(IProject project) {
        Map<DVTProblemWaiver, Integer> waiversHitCount = this.fWaiversHitCountByProject.get(project);
        if (waiversHitCount == null) {
            waiversHitCount = new HashMap<DVTProblemWaiver, Integer>();
            this.fWaiversHitCountByProject.put(project, waiversHitCount);
        }
        return waiversHitCount;
    }

    private synchronized void reportToConsole(IProject project, String string) {
        DVTBuildConsoleRegistry.getConsole(project).print(string);
    }

    private static String getNoOfProblemsWaivedMessage(DVTProblemWaiver waiver, int waiveCount) {
        if (waiver.getName().isEmpty()) {
            return "Waiver defined in '" + waiver.getWaiverDefFile() + "' at line " + waiver.getWaiverDefLine() + " applied to " + waiveCount + " problems";
        }
        return "Waiver '" + waiver.getName() + "' defined in '" + waiver.getWaiverDefFile() + "' at line " + waiver.getWaiverDefLine() + " applied to " + waiveCount + " problems";
    }

    public Map<DVTProblemWaiver, Integer> getWaiversHitCountByProject(IProject project) {
        return this.fWaiversHitCountByProject.get(project);
    }

    public void reportNofProblemsWaivedByWaiver(IProject project, DVTBuildConsoleCommon.MessageSink sink, boolean isBatch) {
        DVTBuildConsole buildConsole = DVTBuildConsoleRegistry.getConsole(project);
        List<DVTProblemWaiver> waivers = this.fWaiversByProject.get(project);
        if (waivers == null) {
            if (!isBatch) {
                buildConsole.print("No compile waivers defined!");
            }
            return;
        }
        Map<DVTProblemWaiver, Integer> waiversHitCount = this.getWaiversHitCountFor(project);
        for (DVTProblemWaiver waiver : waivers) {
            if (waiversHitCount.containsKey(waiver)) {
                buildConsole.print(CompileWaiversManager.getNoOfProblemsWaivedMessage(waiver, waiversHitCount.get(waiver)), sink);
                continue;
            }
            buildConsole.print(CompileWaiversManager.getNoOfProblemsWaivedMessage(waiver, 0), sink);
        }
    }

    private synchronized void incrementWaiverHitCount(IProject project, DVTProblemWaiver waiver) {
        Map<DVTProblemWaiver, Integer> waiversHitCount = this.getWaiversHitCountFor(project);
        if (!waiversHitCount.containsKey(waiver)) {
            waiversHitCount.put(waiver, 1);
        } else {
            int count = waiversHitCount.get(waiver) + 1;
            waiversHitCount.put(waiver, count);
        }
    }

    private synchronized DVTProblemWaiver computeMatchingWaiver(DVTProblem problem) {
        if (problem == null) {
            return null;
        }
        List<DVTProblemWaiver> projectWaivers = this.fWaiversByProject.get(problem.getProject());
        if (projectWaivers == null || projectWaivers.isEmpty()) {
            return null;
        }
        DVTProblemWaiver result = null;
        for (DVTProblemWaiver waiver : projectWaivers) {
            for (DVTProblemMatcher m : waiver.getMatchClauses()) {
                if (!m.matches(problem)) continue;
                result = waiver;
            }
        }
        return result;
    }

    public synchronized void cleanUpWaiversHitCount(IProject project) {
        this.fWaiversHitCountByProject.remove(project);
    }

    public String getCanonicalPathCache(String path) {
        return this.fCanonicalPathCache.get(path);
    }

    public String putCanonicalPathCache(String path, String canonicalPath) {
        return this.fCanonicalPathCache.put(path, canonicalPath);
    }

    public void clearCanonicalPathCache() {
        this.fCanonicalPathCache.clear();
    }

    public void waive(DVTProblem problem, boolean reportWaiving, boolean useSourceSeverity) {
        if (useSourceSeverity && problem.getSeverityAfterWaive() != null) {
            problem.setSeverity(problem.getSeverityAfterWaive());
            return;
        }
        long startTime = System.currentTimeMillis();
        DVTProblemWaiver waiver = this.computeMatchingWaiver(problem);
        if (waiver != null) {
            this.incrementWaiverHitCount(problem.getProject(), waiver);
            Severity severity = waiver.getSeverity();
            if (severity == null) {
                problem.setSeverity(problem.getOriginalSeverity());
            } else {
                problem.setSeverity(severity);
            }
            if (reportWaiving) {
                this.reportWaivingToConsole(problem, waiver);
            }
        } else {
            problem.setSeverity(problem.getOriginalSeverity());
        }
        problem.setSeverityAfterWaive(problem.getSeverity());
        TestHelper.getInstance().fCompileWaiversApplicationTime += System.currentTimeMillis() - startTime;
    }

    private synchronized void reportWaivingToConsole(DVTProblem problem, DVTProblemWaiver waiver) {
        DVTBuildConsole buildConsole = DVTBuildConsoleRegistry.getConsole(problem.getProject());
        buildConsole.printWaiving(problem, waiver);
    }

    public boolean isCompileWaiversFile(String filePath) {
        if (this.allCompileWaiversFilePaths == null) {
            return false;
        }
        return this.allCompileWaiversFilePaths.contains(filePath);
    }
}

