/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.compilewaivers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversConstants;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversManager;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversTreeNode;

public class CompileWaiversUtil {
    private static final CompileWaiversUtil INSTANCE = new CompileWaiversUtil();
    private static final String TEMP_FILE_NAME = "temp";
    private static final String TEMP_FILE_EXTENSION = ".tmp";
    private CompileWaiversTreeNode compileWaiversTreeRoot = new CompileWaiversTreeNode();
    private String lastSelectedFile;
    private String currentProjectName;

    private CompileWaiversUtil() {
    }

    public static CompileWaiversUtil getInstance() {
        return INSTANCE;
    }

    public void resetLastSelectedFile(IProject project) {
        IFile file = project.getFile(CompileWaiversConstants.XML_PROJECT_RELATIVE_PATH);
        if (file == null) {
            return;
        }
        IPath location = file.getLocation();
        if (location == null) {
            return;
        }
        this.setLastSelectedFile(location.toFile().getAbsolutePath());
    }

    public void setLastSelectedFile(String lastSelectedFile) {
        this.lastSelectedFile = lastSelectedFile;
    }

    public String getLastSelectedFile() {
        return this.lastSelectedFile;
    }

    public CompileWaiversTreeNode getCompileWaiversTreeRoot() {
        return this.compileWaiversTreeRoot;
    }

    public void setCurrentProjectName(String currentProjectName) {
        this.currentProjectName = currentProjectName;
    }

    public Set<File> createModel(IProject project, List<File> files) {
        Set<File> allWaiversFiles = this.computeCompileWaiversFileSet(project, files);
        this.init(project.getName());
        for (File file : allWaiversFiles) {
            this.createNode(file, null);
        }
        return allWaiversFiles;
    }

    private Set<File> computeCompileWaiversFileSet(IProject project, List<File> settingsManagedWaiverFiles) {
        LinkedHashSet<File> compileWaiversFilesSet = new LinkedHashSet<File>(settingsManagedWaiverFiles);
        Set<File> projectBCFilesList = BuildConfigManager.getCompileWaiversFiles(project);
        if (projectBCFilesList != null) {
            compileWaiversFilesSet.addAll(projectBCFilesList);
        }
        return compileWaiversFilesSet;
    }

    private void init(String projectName) {
        this.setCurrentProjectName(projectName);
        this.clearCompileWaiversTreeNode(this.compileWaiversTreeRoot);
    }

    private void clearCompileWaiversTreeNode(CompileWaiversTreeNode node) {
        for (CompileWaiversTreeNode child : node.getChildren()) {
            this.clearCompileWaiversTreeNode(child);
        }
        node.clearNode();
    }

    public void createNode(File includedFile, String parentFilePath) {
        CompileWaiversTreeNode parentNode = this.findParentNode(parentFilePath);
        CompileWaiversTreeNode node = new CompileWaiversTreeNode(this.computeUiEntryName(includedFile), includedFile.getAbsolutePath());
        parentNode.addChild(node);
    }

    private CompileWaiversTreeNode findParentNode(String parentFilePath) {
        if (parentFilePath == null) {
            return this.compileWaiversTreeRoot;
        }
        LinkedList<CompileWaiversTreeNode> nodesQueue = new LinkedList<CompileWaiversTreeNode>();
        nodesQueue.add(this.compileWaiversTreeRoot);
        CompileWaiversTreeNode currentNode = (CompileWaiversTreeNode)nodesQueue.remove();
        while (currentNode != null) {
            if (parentFilePath.equals(currentNode.getFileAbsolutePath())) {
                return currentNode;
            }
            nodesQueue.addAll(currentNode.getChildren());
            currentNode = (CompileWaiversTreeNode)nodesQueue.poll();
        }
        return this.compileWaiversTreeRoot;
    }

    private String computeUiEntryName(File file) {
        if (file == null) {
            return "";
        }
        List<String> fileAndParentSegments = this.extractFileAndParentSegments(file);
        if (fileAndParentSegments.isEmpty()) {
            return "";
        }
        StringBuilder buildUiEntryName = new StringBuilder(CompileWaiversConstants.UI_ENTRY_NAME_PREFIX);
        if (fileAndParentSegments.size() == 2) {
            if (fileAndParentSegments.get(0).length() + fileAndParentSegments.get(1).length() > 58) {
                buildUiEntryName.append(fileAndParentSegments.get(0));
            } else {
                buildUiEntryName.append(fileAndParentSegments.get(1)).append(System.getProperty("file.separator")).append(fileAndParentSegments.get(0));
            }
        } else {
            buildUiEntryName.append(fileAndParentSegments.get(0));
        }
        if (this.checkReadOnly(file)) {
            buildUiEntryName.append(" [readonly]");
        } else if (!file.exists()) {
            buildUiEntryName.append(" [file will be created]");
        }
        return buildUiEntryName.toString();
    }

    private List<String> extractFileAndParentSegments(File file) {
        ArrayList<String> fileAndParentSegments = new ArrayList<String>(2);
        String fileName = file.getName();
        if (fileName == null) {
            return fileAndParentSegments;
        }
        fileAndParentSegments.add(fileName);
        File parentFile = file.getParentFile();
        if (parentFile == null) {
            return fileAndParentSegments;
        }
        String parentName = parentFile.getName();
        if (parentName == null) {
            return fileAndParentSegments;
        }
        fileAndParentSegments.add(parentName);
        return fileAndParentSegments;
    }

    private boolean checkReadOnly(File file) {
        if (file.exists()) {
            return !file.canWrite();
        }
        try {
            File tempFile = File.createTempFile(TEMP_FILE_NAME, TEMP_FILE_EXTENSION, file.getParentFile());
            Files.delete(tempFile.toPath());
            return false;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public void updateCompileWaiversTree(IProject newProject) {
        if (this.currentProjectName == null || !this.currentProjectName.equals(newProject.getName())) {
            CompileWaiversManager.INSTANCE.loadWaivers(newProject);
            this.setLastSelectedFile(newProject.getFile(CompileWaiversConstants.XML_PROJECT_RELATIVE_PATH).getLocation().toFile().getAbsolutePath());
        }
    }
}

