/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.encrypted;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.KeyFactory;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.stream.Stream;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import ro.amiq.dvt.model.encrypted.EncryptedUtils;

public class EncryptedGenerateEncryptedCodeFromPlainCode {
    private static final String END_PRAGMA_HEADER = "//pragma protect end_digest_block\n//pragma protect end_protected";
    private static final String BEGIN_PRAGMA_HEADER = "//pragma protect digest_block\n";
    private static final String END_DATA_HEADER = "//pragma protect end_data_block\n";
    private static final String BEGIN_DATA_HEADER = "// pragma protect data_block\n";
    private static final String END_KEY_HEADER = "// pragma protect end_key_block\n";
    private static final String BEGIN_KEY_HEADER = "//pragma protect begin_protected\n//pragma protect control runtime_visibility=\"all_names\"\n//pragma protect key_block\n";

    public static void copyRecursive(final Path source, final Path target) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path destDir = target.resolve(source.relativize(dir));
                Files.createDirectories(destDir, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path destFile = target.resolve(source.relativize(file));
                Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void main(String[] args) {
        try {
            byte[] publicKeyBytes = Base64.getDecoder().decode("MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwhdhU89hCQlPImp1tomQmbgnjfbD1VObTrJYfiEYrqcyFFj4agCfcA0ASlQzxRnzbOFI6faZL1FZbccNGXPGs7ergc9je4OoQkoez1IoS5FdFuSwDk+5d6d8o+UUp5iktuwaxe4GEsdK8phnQ9mKIGv9e4mp6/I2pQKrOW3zBBDfWz0hQTgJJ46QhIx1PmdxzXIKACMtcyMEThjS/tlaRF+MvITFUrsCkZN+qLqo1v6Ss0VTHNNLp/3tK7E3K7eWxHnHdPRftuktmLHpydYaIIA5U+gTHvRplcNaJZ0ydQUS/1eDkAyuX25/p+U0l/1wN3ErpVOj8dLmTaoYeCYwjQIDAQAB");
            X509EncodedKeySpec spec = new X509EncodedKeySpec(publicKeyBytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(256);
            SecretKey aesKey = keyGen.generateKey();
            byte[] iv = new byte[16];
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            String projectPath = "/home/george.matei/git/dvt.main/ro.amiq.vlogdt.tests/projects/CORE_SV_TESTS/test_usage_before_declaration";
            Path inputPath = Paths.get(projectPath, new String[0]);
            String outputDir = String.valueOf(projectPath) + "_encrypted";
            Path outputPath = Paths.get(outputDir, new String[0]);
            Files.createDirectories(outputPath, new FileAttribute[0]);
            EncryptedGenerateEncryptedCodeFromPlainCode.copyRecursive(inputPath, outputPath);
            try {
                Throwable throwable = null;
                Object var14_15 = null;
                try (Stream<Path> paths = Files.walk(Paths.get(projectPath, new String[0]), new FileVisitOption[0]);){
                    paths.filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> {
                        String fileName = path.getFileName().toString().toLowerCase();
                        return fileName.endsWith(".sv") || fileName.endsWith(".svh") || fileName.endsWith(".v") || fileName.endsWith(".vh") || fileName.endsWith(".svp") || fileName.endsWith(".sv_older") || fileName.endsWith(".vams");
                    }).forEach(path3 -> {
                        try {
                            Path relativize = inputPath.relativize((Path)path3);
                            Path outputFile = outputPath.resolve(relativize);
                            Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
                            byte[] bytes = Files.readAllBytes(path3);
                            String plainText = new String(bytes, StandardCharsets.UTF_8);
                            Cipher aesCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                            aesCipher.init(1, (Key)aesKey, ivSpec);
                            byte[] encryptedData = aesCipher.doFinal(plainText.getBytes());
                            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-256AndMGF1Padding");
                            rsaCipher.init(1, kf.generatePublic(spec));
                            byte[] encryptedAesKey = rsaCipher.doFinal(aesKey.getEncoded());
                            String encryptedAesKeyB64 = Base64.getEncoder().encodeToString(encryptedAesKey);
                            byte[] ivAndCiphertext = new byte[iv.length + encryptedData.length];
                            System.arraycopy(iv, 0, ivAndCiphertext, 0, iv.length);
                            System.arraycopy(encryptedData, 0, ivAndCiphertext, iv.length, encryptedData.length);
                            String encryptedDataB64 = Base64.getEncoder().encodeToString(ivAndCiphertext);
                            StringBuilder hexString = EncryptedUtils.getDigest(plainText);
                            StringBuilder str = new StringBuilder();
                            str.append(BEGIN_KEY_HEADER);
                            str.append(String.valueOf(encryptedAesKeyB64) + "\n");
                            str.append(END_KEY_HEADER);
                            str.append(BEGIN_DATA_HEADER);
                            str.append(String.valueOf(encryptedDataB64) + "\n");
                            str.append(END_DATA_HEADER);
                            str.append(BEGIN_PRAGMA_HEADER);
                            str.append(String.valueOf(hexString.toString()) + "\n");
                            str.append(END_PRAGMA_HEADER);
                            Files.write(outputFile, str.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                        }
                        catch (Exception exception) {}
                    });
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {}
    }
}

