/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.encrypted;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum EncryptedUtils {
    INSTANCE;

    private static final String END_PREFIX = "end_";
    private static final String KEY_OWNER = "key_owner";
    private static final String KEY_METHOD = "key_method";
    private static final String DIGEST_BLOCK = "digest_block";
    private static final String DATA_BLOCK = "data_block";
    private static final String KEY_BLOCK = "key_block";
    private static final String KEY_KEYOWNER = "key_keyowner=";
    private static final String RUNTIME_VISIBILITY = "runtime_visibility=";
    private static final String KEY = "key";
    private static final String DIGEST_KEY = "digest";
    private static final String DATA_KEY = "data";
    private static final String privateKey = "MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDCF2FTz2EJCU8ianW2iZCZuCeN9sPVU5tOslh+IRiupzIUWPhqAJ9wDQBKVDPFGfNs4Ujp9pkvUVltxw0Zc8azt6uBz2N7g6hCSh7PUihLkV0W5LAOT7l3p3yj5RSnmKS27BrF7gYSx0rymGdD2Yoga/17ianr8jalAqs5bfMEEN9bPSFBOAknjpCEjHU+Z3HNcgoAIy1zIwROGNL+2VpEX4y8hMVSuwKRk36ouqjW/pKzRVMc00un/e0rsTcrt5bEecd09F+26S2YsenJ1hoggDlT6BMe9GmVw1olnTJ1BRL/V4OQDK5fbn+n5TSX/XA3cSulU6Px0uZNqhh4JjCNAgMBAAECggEADbamL0xDQGayey2HdKbCm0HaNZseWhfGrOhH/V1sR4bTsIFax+6UVU/t2dKaN85uFx7RzooYZ7H5Phrmz4oRG4iaKxlSn5r9S/W9uItHApPaPnBZCiHS6mPgmBnq/C56UNxcxehb8H65Smu/PBmGO2U160EeSuf5uW33WB7vITXKai4LmPfj87ZcYotvo9WJCNF9HsVIGAzArP6QxWW5Eh+fxQWzY9XlWSq7mul2TMNtVXMgYMRMbbHY5lIpqvVb7MxPZtXLW9bQ+lC1o1Pjuc2KfROnt3iRHm4Tl5e1BHd0hJqBBi6OpU4fvltKqJaH9hwb+T8WpdaxNFH0aqhEQQKBgQDRMkBBMEruwQYhOFQYoVFqm3cYR1if+XLx4DnmgRGllMYUeWhe/WZ5Q+7JBUmM2GCoYhdWSXhmVOwkKKnPa5sv/wyxO+wskpy8rk/Mcr1iVW0P6gp6iwYSyXBDBqNZirk4RzFqF6rpUOElAeqzsodqLWihJIgqiHS6VHzazdSGLQKBgQDtg/130wjcZFwI+CQBp2Maf31Ij6oGSKFaggllZysql0pq0dUWDn5ZiHZ5yKU0TsvMBwQlWxlfHnpFED0dqTihlh3EwFxANZ73B/p06Rq0jGTUhBc3DA0LlQ5JQXUn4ZAMzgpsB23NzLEtLVDUxXCvkJElq44HuISe2yzseOIv4QKBgAQFn06hiw9EDsYcuyEuGM6f5o5E8ONCfH9B/Fr+KESys4w5OVR6MroqIDElNODMWC9kk2ZJS1NMVq3rSjh+rSEjGi9eI5BH0VOfVlFr81AsrEgeC82HVrqNvObM/d7+18jJNZ4Ajnyl3W5Etyp1SD02Wkie1y9aKERc03mxc2CRAoGAQU2wDBj+77G8SE8Jf1bpfaid5qxxYAbqLjtgn/vMt4ofUN1ejBDyFmXZxUQwgABGMlOfhTHV+PwlPAXp99TGGE9w4d7Nvm2/xkXwS+KnkAql0nR6+YybrZqO8f9IWe2/sHWaEfe87f+gmz5BYi7i+7Jw5f2UMHVAKXkzkdTuw6ECgYBrD69qiraPnAvLo+KSdpCikP3xEEUi0XnnTfQ6Zzo+TMknTXIH/6csf2w9sXohUzt3o+XnDBJ58aoJvtgXu06Y63GX3Px+4lON9jTlButJharl5ewQLKoFTwe83QbHiRtuVX11S4nEbdpu58xUbd7mZeKLl/HoeDei7HQO4zD0kw==";
    public static final String publicKey = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwhdhU89hCQlPImp1tomQmbgnjfbD1VObTrJYfiEYrqcyFFj4agCfcA0ASlQzxRnzbOFI6faZL1FZbccNGXPGs7ergc9je4OoQkoez1IoS5FdFuSwDk+5d6d8o+UUp5iktuwaxe4GEsdK8phnQ9mKIGv9e4mp6/I2pQKrOW3zBBDfWz0hQTgJJ46QhIx1PmdxzXIKACMtcyMEThjS/tlaRF+MvITFUrsCkZN+qLqo1v6Ss0VTHNNLp/3tK7E3K7eWxHnHdPRftuktmLHpydYaIIA5U+gTHvRplcNaJZ0ydQUS/1eDkAyuX25/p+U0l/1wN3ErpVOj8dLmTaoYeCYwjQIDAQAB";
    private Map<String, String> encryptedInfoMap = new LinkedHashMap<String, String>();
    private boolean isKeyBlock;
    private boolean isDataBlock;
    private boolean isDigestBlock;

    public void clear() {
        this.encryptedInfoMap.clear();
        this.isKeyBlock = false;
        this.isDataBlock = false;
        this.isDigestBlock = false;
    }

    public void collectEncryptedCodeHeaders(String encryptedCodeHeader) {
        try {
            if (encryptedCodeHeader == null || encryptedCodeHeader.isEmpty()) {
                return;
            }
            int keyIndex = encryptedCodeHeader.indexOf(KEY_METHOD);
            int keyBlockIndex = encryptedCodeHeader.indexOf(KEY_BLOCK);
            int endKeyBlockIndex = encryptedCodeHeader.indexOf("end_key_block");
            int dataBlockIndex = encryptedCodeHeader.indexOf(DATA_BLOCK);
            int endDataBlockIndex = encryptedCodeHeader.indexOf("end_data_block");
            int digestIndex = encryptedCodeHeader.indexOf(DIGEST_BLOCK);
            int endDigestIndex = encryptedCodeHeader.indexOf("end_digest_block");
            int keyOwnerIndex = encryptedCodeHeader.indexOf(KEY_KEYOWNER);
            int runtime = encryptedCodeHeader.indexOf(RUNTIME_VISIBILITY);
            if (runtime != -1) {
                this.encryptedInfoMap.put(RUNTIME_VISIBILITY, this.getHeaderValue(encryptedCodeHeader, runtime, RUNTIME_VISIBILITY));
            }
            if (keyOwnerIndex != -1) {
                this.encryptedInfoMap.put(KEY_OWNER, this.getHeaderValue(encryptedCodeHeader, keyOwnerIndex, KEY_OWNER));
            }
            if (keyIndex != -1) {
                this.encryptedInfoMap.put(KEY_METHOD, this.getHeaderValue(encryptedCodeHeader, keyIndex, KEY_METHOD));
            }
            if (endKeyBlockIndex != -1 && keyBlockIndex != -1 && Character.isWhitespace(encryptedCodeHeader.charAt(keyBlockIndex - 1))) {
                this.encryptedInfoMap.put(KEY, this.getCodeBlock(encryptedCodeHeader, keyBlockIndex, KEY_BLOCK));
            } else if (endKeyBlockIndex != -1) {
                this.isKeyBlock = false;
            } else if (keyBlockIndex != -1) {
                this.isKeyBlock = true;
            } else if (this.isKeyBlock && !encryptedCodeHeader.isEmpty()) {
                String key = this.encryptedInfoMap.get(KEY);
                if (key == null) {
                    this.encryptedInfoMap.put(KEY, encryptedCodeHeader);
                } else {
                    this.encryptedInfoMap.put(KEY, String.valueOf(key) + "//" + encryptedCodeHeader);
                }
            }
            if (endDataBlockIndex != -1 && dataBlockIndex != -1 && Character.isWhitespace(encryptedCodeHeader.charAt(dataBlockIndex - 1))) {
                this.encryptedInfoMap.put(DATA_KEY, this.getCodeBlock(encryptedCodeHeader, dataBlockIndex, DATA_BLOCK));
            } else if (endDataBlockIndex != -1) {
                this.isDataBlock = false;
            } else if (dataBlockIndex != -1) {
                this.isDataBlock = true;
            } else if (this.isDataBlock && !encryptedCodeHeader.isEmpty()) {
                String dataKey = this.encryptedInfoMap.get(DATA_KEY);
                if (dataKey == null) {
                    this.encryptedInfoMap.put(DATA_KEY, encryptedCodeHeader);
                } else {
                    this.encryptedInfoMap.put(DATA_KEY, String.valueOf(dataKey) + "//" + encryptedCodeHeader);
                }
            }
            if (digestIndex != -1 && endDigestIndex != -1 && Character.isWhitespace(encryptedCodeHeader.charAt(digestIndex - 1))) {
                this.encryptedInfoMap.put(DIGEST_KEY, this.getCodeBlock(encryptedCodeHeader, digestIndex, DIGEST_BLOCK));
            } else if (endDigestIndex != -1) {
                this.isDigestBlock = false;
            } else if (digestIndex != -1) {
                this.isDigestBlock = true;
            } else if (this.isDigestBlock) {
                this.encryptedInfoMap.put(DIGEST_KEY, encryptedCodeHeader.trim());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private String getCodeBlock(String encryptedCodeHeader, int index, String blockType) {
        return encryptedCodeHeader.substring(index + blockType.length(), encryptedCodeHeader.indexOf("`pragma", index + 1)).trim();
    }

    private String getHeaderValue(String header, int headerStart, String keyWord) {
        int end = header.indexOf(System.lineSeparator(), headerStart);
        if (end == -1) {
            end = header.length();
        }
        return header.substring(headerStart + keyWord.length(), end);
    }

    private static String decryptAES(String encryptedText, String base64Key) throws Exception {
        if (base64Key == null || encryptedText == null) {
            return null;
        }
        byte[] keyBytes = Base64.getDecoder().decode(base64Key.trim());
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "AES");
        byte[] encryptedBytes = Base64.getDecoder().decode(encryptedText.trim());
        byte[] iv = Arrays.copyOfRange(encryptedBytes, 0, 16);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)keySpec, new IvParameterSpec(iv));
        byte[] decryptedBytes = cipher.doFinal(Arrays.copyOfRange(encryptedBytes, 16, encryptedBytes.length));
        return new String(decryptedBytes);
    }

    private static String decryptRSAKey(String encryptedKey, String string) throws Exception {
        if (encryptedKey == null || string == null) {
            return null;
        }
        byte[] encryptedBytes = Base64.getDecoder().decode(encryptedKey.trim());
        byte[] keyBytes = Base64.getDecoder().decode(string.trim());
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING");
        cipher.init(2, keyFactory.generatePrivate(keySpec));
        return Base64.getEncoder().encodeToString(cipher.doFinal(encryptedBytes));
    }

    public String getDecryptedCode() {
        String decryptAES;
        block7: {
            block6: {
                String decryptRSAKey;
                block5: {
                    try {
                        decryptRSAKey = EncryptedUtils.decryptRSAKey(this.encryptedInfoMap.get(KEY), privateKey);
                        if (decryptRSAKey != null) break block5;
                        return null;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return null;
                    }
                }
                decryptAES = EncryptedUtils.decryptAES(this.encryptedInfoMap.get(DATA_KEY), decryptRSAKey);
                if (decryptAES != null) break block6;
                return null;
            }
            StringBuilder digest = EncryptedUtils.getDigest(decryptAES);
            String digestString = this.encryptedInfoMap.get(DIGEST_KEY);
            if (digestString != null && digestString.equals(digest.toString())) break block7;
            return null;
        }
        return decryptAES;
    }

    public static StringBuilder getDigest(String plainText) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hashBytes = digest.digest(plainText.getBytes(StandardCharsets.UTF_8));
        StringBuilder hexString = new StringBuilder();
        byte[] byArray = hashBytes;
        int n = hashBytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
            ++n2;
        }
        return hexString;
    }
}

