/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.floatingwidgets;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.AbstractBuildContributor;
import ro.amiq.dvt.model.DVTMixedLangBuilder;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IDVTBuildContributor;
import ro.amiq.dvt.model.floatingwidgets.DVTFNotificationProvider;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyFile;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.resources.properties.LazyPersistentPropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.editor.floatingwidgets.IFWidget;
import ro.amiq.dvt.ui.preferences.EclipsePreferencesUtils;

public enum FIncrementalBuildAutoChangeListener implements IPropertyChangeListener,
IEclipsePreferences.IPreferenceChangeListener,
IResourceChangeListener
{
    INSTANCE;


    public void propertyChange(PropertyChangeEvent event) {
        if (!"show.automatic.build.notifications".equals(event.getProperty())) {
            return;
        }
        FIncrementalNotificationTracker.INSTANCE.setAutoBuildState();
        this.disposeFloatingWidgetsDetails();
        FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (!"description.autobuilding".equals(event.getKey())) {
            return;
        }
        FIncrementalNotificationTracker.INSTANCE.setAutoBuildState();
        this.disposeFloatingWidgetsDetails();
        if (!FIncrementalNotificationTracker.INSTANCE.isAutoBuildDisabled()) {
            Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.disposeAll(FWidgetType.DB_OUT_OF_SYNC));
        } else {
            FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC);
        }
    }

    void disposeFloatingWidgetsDetails() {
        List<IEditorPart> visibleEditors = Utils.computeVisibleEditors();
        for (IEditorPart visibleEditor : visibleEditors) {
            if (!(visibleEditor instanceof DVTEditor)) continue;
            Collection<IFWidget> floatingWidgets = FWidgetFactory.INSTANCE.getWidgets((DVTEditor)visibleEditor);
            for (IFWidget floatingWidget : floatingWidgets) {
                floatingWidget.disposeDetails();
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            if (EclipsePreferencesUtils.isAutobuildOn()) {
                return;
            }
            if (event == null) {
                return;
            }
            if (event.getType() != 1) {
                return;
            }
            IResourceDelta delta = event.getDelta();
            if (delta == null || delta.getResource() == null) {
                return;
            }
            Map<IProject, IResourceDelta> projects = this.computeDeltaPerProject(delta);
            for (Map.Entry<IProject, IResourceDelta> wntry : projects.entrySet()) {
                IProject project = wntry.getKey();
                List<IDVTBuildContributor> buildContributors = DVTMixedLangBuilder.getEnabledContributors(project);
                EnumMap<LanguageKind, Set<FileCompileInfo>> changedFilesInfo = new EnumMap<LanguageKind, Set<FileCompileInfo>>(LanguageKind.class);
                for (IDVTBuildContributor contributor : buildContributors) {
                    if (!(contributor instanceof AbstractBuildContributor)) continue;
                    changedFilesInfo.clear();
                    AbstractBuildContributor abstractBuildContributor = (AbstractBuildContributor)contributor;
                    abstractBuildContributor.setProject(project);
                    abstractBuildContributor.analyzeDelta(wntry.getValue(), (IProgressMonitor)new NullProgressMonitor(), changedFilesInfo);
                    this.addDirtyFiles(changedFilesInfo.values(), project, abstractBuildContributor.getFNotificationProvider());
                }
                FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC);
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void addDirtyFiles(Collection<Set<FileCompileInfo>> changedFiles, IProject project, DVTFNotificationProvider notificationProvider) {
        for (Set<FileCompileInfo> fileInfos : changedFiles) {
            for (FileCompileInfo fileInfo : fileInfos) {
                IFile file = fileInfo.getFile();
                if (!this.isCompiled(file)) continue;
                FIncrementalNotificationTracker.INSTANCE.addDirtyResource(project, new FIncrementalDirtyFile(file, FNotificationDirtyReason.BUILD_AUTO_DISABLED, notificationProvider));
            }
        }
    }

    private Map<IProject, IResourceDelta> computeDeltaPerProject(IResourceDelta delta) throws CoreException {
        final HashMap<IProject, IResourceDelta> result = new HashMap<IProject, IResourceDelta>();
        delta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                IResource resource = delta.getResource();
                if (resource == null) {
                    return false;
                }
                if (resource instanceof IWorkspaceRoot) {
                    return true;
                }
                if (resource instanceof IProject) {
                    result.put((IProject)resource, delta);
                    return false;
                }
                IProject project = resource.getProject();
                if (project == null) {
                    return true;
                }
                result.put(project, delta);
                return false;
            }
        });
        return result;
    }

    private boolean isCompiled(IFile file) {
        LazyPersistentPropertiesManager.IPropertyValue property = LazyPersistentPropertiesManager.INSTANCE.getProperty((IResource)file, new LazyPersistentPropertiesManager.PropertyKind(PropertyTypes.QN_IMPORTED_FILE));
        if (property == null) {
            return false;
        }
        IBuildConfigParserConstants.LanguageSyntax languageSyntax = IBuildConfigParserConstants.LanguageSyntax.from(property.value());
        if (languageSyntax == null) {
            return false;
        }
        return IBuildConfigParserConstants.ALL_LANGS.contains((Object)languageSyntax.languageKind);
    }
}

