/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.floatingwidgets;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyPrecompiledLibraries;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyProject;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtySplitInvocation;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalFixJobCommon;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public class FIncrementalFixJob
extends FIncrementalFixJobCommon {
    public FIncrementalFixJob(IProject project) {
        super(project);
        this.setRule((ISchedulingRule)project.getWorkspace().getRoot());
    }

    @Override
    protected boolean shouldFullBuild(int noOfChangedFiles) {
        if (FIncrementalNotificationTracker.INSTANCE.isFullBuildNeeded(this.project)) {
            return true;
        }
        return noOfChangedFiles >= 50;
    }

    @Override
    protected void triggerFullBuild() {
        DVTBuildUtils.runInternalBuilder(this.project);
    }

    @Override
    protected boolean shouldRegeneratePrecompiledLib() {
        return FIncrementalNotificationTracker.INSTANCE.isPrecompileDbGenerationNeeded(this.project);
    }

    @Override
    protected boolean shouldRegenerateSplitInvocation() {
        return FIncrementalNotificationTracker.INSTANCE.isSplitInvocationGenerationNeeded(this.project);
    }

    @Override
    protected void triggerRegeratePrecompiledLib(IProgressMonitor monitor) {
        FIncrementalDirtyProject dirtyResource = FIncrementalNotificationTracker.INSTANCE.getDirtyProjectInfo(this.project);
        if (!(dirtyResource instanceof FIncrementalDirtyPrecompiledLibraries)) {
            return;
        }
        FIncrementalDirtyPrecompiledLibraries dirtyLibrariesInfo = (FIncrementalDirtyPrecompiledLibraries)dirtyResource;
        Map<Integer, String> dirtyLibraries = dirtyLibrariesInfo.getDirtyLibraries();
        List<Invocation> dirtyInvocations = BuildConfigManager.getInvocations(this.project).stream().filter(invocation -> dirtyLibraries.containsKey(invocation.getState().invocationNumber)).collect(Collectors.toList());
        List<Invocation> invocationsWithoutBuildCmds = PrecompiledDBUtils.getFailedLoadInvocationsWithoutBuildCmd(this.project, dirtyInvocations);
        if (!invocationsWithoutBuildCmds.isEmpty()) {
            PrecompiledDBUtils.reportErrorsOnFailedLoadInvocationsWithoutBuildCmd(this.project, invocationsWithoutBuildCmds);
            return;
        }
        int maxJobs = BuildConfigManager.getPrecompiledDbBuildCmdMaxJobs(this.project);
        ExecutorService executor = PrecompiledDBUtils.initExecutorService(maxJobs);
        dirtyInvocations.sort((a, b) -> a.getState().invocationNumber - b.getState().invocationNumber);
        HashMap rebuildSuccess = new HashMap();
        for (Invocation invocation2 : dirtyInvocations) {
            executor.execute(() -> rebuildSuccess.put(invocation.getState().invocationNumber, PersistenceBase.precompileDb(this.project, invocation2, monitor, false)));
        }
        PrecompiledDBUtils.shutdownExecutorService(executor);
        if (rebuildSuccess.containsValue(false)) {
            return;
        }
        PrecompiledDBUtils.setWasBuildTriggeredAutomatically(true);
        DVTBuildUtils.fullBuildWithProgress(this.project);
    }

    @Override
    protected void triggerRegenerateSplitInvocation() {
        FIncrementalDirtyProject dirtyResource = FIncrementalNotificationTracker.INSTANCE.getDirtyProjectInfo(this.project);
        if (!(dirtyResource instanceof FIncrementalDirtySplitInvocation)) {
            return;
        }
        String projectLocation = this.project.getLocation().makeAbsolute().toOSString();
        String splitBC = BuildConfigManagerCommon.getActiveBuildConfig(this.project).getName();
        Path splitFilePath = Paths.get(projectLocation, ".dvt", String.valueOf(splitBC) + ".build.split");
        if (splitFilePath.toFile().exists()) {
            try {
                DVTFileUtils.getInstance().removeRecursive(splitFilePath);
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        DVTBuildUtils.fullBuildWithProgress(this.project);
    }
}

