/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.floatingwidgets;

import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IncrementalElaborationKind;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.floatingwidgets.DVTFNotificationProvider;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyFile;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationFixer;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyResource;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;

public class FIncrementalFixJobCommon
extends Job {
    private static final String NAME = "Updating Database...";
    protected IProject project;

    public FIncrementalFixJobCommon(IProject project) {
        super(NAME);
        this.project = project;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            IncrementalElaborationKind incrementalElaborationKind;
            FIncrementalNotificationFixer.INSTANCE.startTimer(this.project);
            if (this.shouldRegeneratePrecompiledLib()) {
                FIncrementalNotificationFixer.INSTANCE.stopTimer();
                this.triggerRegeratePrecompiledLib(monitor);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (this.shouldRegenerateSplitInvocation()) {
                FIncrementalNotificationFixer.INSTANCE.stopTimer();
                this.triggerRegenerateSplitInvocation();
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            List<FNotificationDirtyResource> dirtyResources = FIncrementalNotificationTracker.INSTANCE.getDirtyResources(this.project);
            if (this.shouldFullBuild(dirtyResources.size())) {
                FIncrementalNotificationFixer.INSTANCE.stopTimer();
                this.triggerFullBuild();
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            RfMixedLangProject rfMixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(this.project, false);
            boolean shouldElaborate = false;
            boolean shouldFullBuild = false;
            EnumMap<LanguageKind, Set<FileCompileInfo>> changedFiles = new EnumMap<LanguageKind, Set<FileCompileInfo>>(LanguageKind.class);
            LinkedHashSet<FileCompileInfo> fileList = new LinkedHashSet<FileCompileInfo>();
            for (FNotificationDirtyResource dirtyResource : dirtyResources) {
                DVTFNotificationProvider provider;
                if (!(dirtyResource instanceof FIncrementalDirtyFile)) continue;
                FIncrementalDirtyFile dirtyFile = (FIncrementalDirtyFile)dirtyResource;
                if (FIncrementalFixJobCommon.isFullBuildReason(dirtyFile)) {
                    shouldFullBuild = true;
                    break;
                }
                if (dirtyFile.getReason() == FNotificationDirtyReason.ELABORATION) {
                    shouldElaborate = true;
                    continue;
                }
                IResource resource = dirtyFile.getResource();
                if (!(resource instanceof IFile) || (provider = dirtyFile.getProvider()) == null) continue;
                FileCompileInfo fileCompileInfo = new FileCompileInfo((IFile)resource);
                provider.getModelManager().cbIncrementalBuild(monitor, fileCompileInfo, null, true);
                fileList.add(fileCompileInfo);
                changedFiles.put(provider.getLanguageKind(), fileList);
                if (!monitor.isCanceled()) continue;
                FIncrementalNotificationFixer.INSTANCE.stopTimer();
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (rfMixedLangProject != null) {
                rfMixedLangProject.setBuildProgressMonitor(monitor);
            }
            if (monitor.isCanceled()) {
                FIncrementalNotificationFixer.INSTANCE.stopTimer();
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (shouldFullBuild) {
                FIncrementalNotificationFixer.INSTANCE.stopTimer();
                this.triggerFullBuild();
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            DVTMixedLangModelManager.getInstance().notifyBuildListenersPostIncrementalBuild(this.project, changedFiles);
            IncrementalElaborationKind incrementalElaborationKind2 = incrementalElaborationKind = shouldElaborate ? IncrementalElaborationKind.NONE : IncrementalElaborationKind.FULL;
            if (!shouldElaborate) {
                DVTMixedLangModelManager.getInstance().notifyBuildListenersMixedLangPostIncrementalBuild(this.project, changedFiles, incrementalElaborationKind);
                if (rfMixedLangProject != null) {
                    rfMixedLangProject.cleanIncrementalDeltaContainer();
                }
                FIncrementalNotificationFixer.INSTANCE.stopTimer();
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            RfMixedLangManager.getInstance().incrementalElaborate(this.project, IncrementalElaborationKind.FULL);
            DVTMixedLangModelManager.getInstance().notifyBuildListenersMixedLangPostIncrementalBuild(this.project, changedFiles, incrementalElaborationKind);
            if (rfMixedLangProject != null) {
                rfMixedLangProject.cleanIncrementalDeltaContainer();
            }
            ObjectionManager.getInstance().clear(Objection.FLOATING_NOTIFICATION_TRIGGERED_ELAB);
            FIncrementalNotificationFixer.INSTANCE.stopTimer();
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            FIncrementalNotificationFixer.INSTANCE.stopTimer();
            DVTLogger.INSTANCE.logError((Throwable)e);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            if (monitor.isCanceled()) {
                FWidgetFactory.INSTANCE.paint(true, FWidgetType.DB_OUT_OF_SYNC);
            }
        }
    }

    public static boolean isFullBuildReason(FNotificationDirtyResource dirtyFile) {
        return dirtyFile.getReason() == FNotificationDirtyReason.RENAME_FILE || dirtyFile.getReason() == FNotificationDirtyReason.BUILD_CONFIG_CHANGED;
    }

    protected boolean shouldFullBuild(int noOfChangedFiles) {
        return false;
    }

    protected boolean shouldRegeneratePrecompiledLib() {
        return false;
    }

    protected boolean shouldRegenerateSplitInvocation() {
        return false;
    }

    protected void triggerFullBuild() {
    }

    protected void triggerRegeratePrecompiledLib(IProgressMonitor monitor) {
    }

    protected void triggerRegenerateSplitInvocation() {
    }

    public void dispose() {
        this.project = null;
    }
}

