/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.floatingwidgets;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalFixJob;
import ro.amiq.dvt.model.reflection.RfGUIUtils;
import ro.amiq.dvt.ui.preferences.PrefConst;

public enum FIncrementalNotificationFixer {
    INSTANCE;

    public static final String NAME = "Database Update";
    private HashMap<IProject, FIncrementalFixJob> fixJobMap = new HashMap(1);
    private RfGUIUtils guiUtils = new RfGUIUtils();

    public synchronized void scheduleFixJob(IProject project) {
        FIncrementalFixJob incrementalFixJob = this.fixJobMap.get(project);
        if (incrementalFixJob == null) {
            incrementalFixJob = new FIncrementalFixJob(project);
        }
        this.fixJobMap.put(project, incrementalFixJob);
        incrementalFixJob.schedule(0L);
    }

    protected synchronized void clearJob(IProject project) {
        if (project == null) {
            return;
        }
        FIncrementalFixJob incrementalFixJob = this.fixJobMap.get(project);
        if (incrementalFixJob != null) {
            incrementalFixJob.dispose();
        }
        this.fixJobMap.remove(project);
    }

    protected synchronized int getFixJobState(IProject project) {
        if (project == null) {
            return 0;
        }
        FIncrementalFixJob incrementalFixJob = this.fixJobMap.get(project);
        return incrementalFixJob == null ? 0 : incrementalFixJob.getState();
    }

    public synchronized void startTimer(IProject project) {
        if (project == null) {
            return;
        }
        this.guiUtils.startTimer(PrefConst.isDatabaseUpdateTimeoutEnabled() ? PrefConst.getDatabaseUpdateTimeout() : Integer.MAX_VALUE, project, NAME, null);
    }

    public synchronized boolean isCanceled() {
        return this.guiUtils.isCancelChecking();
    }

    public synchronized void stopTimer() {
        this.guiUtils.stopTimer();
    }
}

