/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.floatingwidgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.buildconfig.splitinvocation.SplitInvocationUtils;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.floatingwidgets.FDirtyScriptingEditorResource;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyFile;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyMacro;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyPrecompiledLibraries;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyProject;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtySplitInvocation;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalRenamedDirtyFile;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyResource;
import ro.amiq.dvt.utils.DVTStringUtil;

public class FIncrementalNotificationText {
    private StringBuilder headerText = new StringBuilder();
    private Set<String> maxLinesExceedFileNames = new HashSet<String>(1);
    private Set<String> parseTimeoutFileNames = new HashSet<String>(1);
    private Set<String> semanticTimeoutFileNames = new HashSet<String>(1);
    private Set<String> elaborationFileNames = new HashSet<String>(1);
    private Set<String> buildAutoDisabledFileNames = new HashSet<String>(1);
    private Set<String> renamedFileNames = new HashSet<String>(1);
    private Set<String> unexpectedFailureFileNames = new HashSet<String>(1);
    private Set<String> changedMacros = new HashSet<String>(1);
    private Set<String> outOfSyncPrecompiledLibraries = new LinkedHashSet<String>(1);
    private Map<SplitInvocationUtils.SplitInvocationLibraryElementsMessageType, List<String>> outOfSyncSplitInvocation = new EnumMap<SplitInvocationUtils.SplitInvocationLibraryElementsMessageType, List<String>>(SplitInvocationUtils.SplitInvocationLibraryElementsMessageType.class);
    private boolean hasScriptingEditors;
    private boolean isActiveBuildConfigChanged;
    private int noOfchangedFiles;

    protected void updateHeaderText(boolean disabledAutobuild, int noOfDirtyFiles) {
        this.headerText.setLength(0);
        if (!disabledAutobuild || noOfDirtyFiles != 0) {
            this.headerText.append(" Database is not up to date, update now");
            if (this.renamedFileNames.isEmpty() && !this.isActiveBuildConfigChanged && !this.hasScriptingEditors) {
                this.headerText.append(noOfDirtyFiles < 50 ? " (analyse changed files)." : " (full build).");
            } else {
                this.headerText.append(" (full build).");
            }
            this.headerText.append(DVTStringUtil.LINE_SEPARATOR);
        }
        if (disabledAutobuild) {
            this.headerText.append(" Automatic build is turned off. Turn it on?").append(DVTStringUtil.LINE_SEPARATOR);
        }
    }

    protected void addFileName(FNotificationDirtyResource dirtyResource) {
        if (dirtyResource instanceof FIncrementalDirtyMacro) {
            FIncrementalDirtyMacro dirtyMacro = (FIncrementalDirtyMacro)dirtyResource;
            this.changedMacros.addAll(dirtyMacro.getDirtyMacros());
            return;
        }
        if (dirtyResource instanceof FDirtyScriptingEditorResource) {
            this.hasScriptingEditors = true;
            return;
        }
        if (dirtyResource instanceof FIncrementalDirtyPrecompiledLibraries) {
            FIncrementalDirtyPrecompiledLibraries dirtyPrecompiledLibraries = (FIncrementalDirtyPrecompiledLibraries)dirtyResource;
            this.outOfSyncPrecompiledLibraries = new LinkedHashSet<String>(dirtyPrecompiledLibraries.getDirtyLibraries().values());
            return;
        }
        if (dirtyResource instanceof FIncrementalDirtySplitInvocation) {
            FIncrementalDirtySplitInvocation dirtySplitInvocation = (FIncrementalDirtySplitInvocation)dirtyResource;
            this.outOfSyncSplitInvocation = new EnumMap<SplitInvocationUtils.SplitInvocationLibraryElementsMessageType, List<String>>(dirtySplitInvocation.getLibraryElements());
            return;
        }
        FNotificationDirtyReason reason = dirtyResource.getReason();
        if (FNotificationDirtyReason.TOO_MANY_FILES_CHANGED.equals(reason)) {
            if (dirtyResource instanceof FIncrementalDirtyProject) {
                this.noOfchangedFiles = ((FIncrementalDirtyProject)dirtyResource).getNOfFiles();
            }
            return;
        }
        if (!(dirtyResource instanceof FIncrementalDirtyFile)) {
            return;
        }
        FIncrementalDirtyFile dirtyFile = (FIncrementalDirtyFile)dirtyResource;
        IResource resource = dirtyFile.getResource();
        if (resource == null || reason == null) {
            return;
        }
        if (FNotificationDirtyReason.BUILD_CONFIG_CHANGED.equals(reason)) {
            this.isActiveBuildConfigChanged = true;
            return;
        }
        IPath path = resource.getProjectRelativePath();
        if (path == null) {
            return;
        }
        String fileName = path.toOSString();
        if (fileName == null || fileName.isEmpty()) {
            return;
        }
        switch (reason) {
            case MAX_LINES_EXCEEDED: {
                this.maxLinesExceedFileNames.add(fileName);
                break;
            }
            case PARSE_TIMEOUT: {
                this.parseTimeoutFileNames.add(fileName);
                break;
            }
            case SEMANTIC_TIMEOUT: {
                this.semanticTimeoutFileNames.add(fileName);
                break;
            }
            case ELABORATION: {
                this.elaborationFileNames.add(fileName);
                break;
            }
            case BUILD_AUTO_DISABLED: {
                this.buildAutoDisabledFileNames.add(fileName);
                break;
            }
            case RENAME_FILE: {
                this.replaceOldFile(dirtyFile, fileName);
                this.renamedFileNames.add(fileName);
                break;
            }
            case UNEXPECTED_EXCEPTION: {
                this.unexpectedFailureFileNames.add(fileName);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void replaceOldFile(FNotificationDirtyResource dirtyFile, String newFileName) {
        if (!(dirtyFile instanceof FIncrementalRenamedDirtyFile)) {
            return;
        }
        IFile oldFile = ((FIncrementalRenamedDirtyFile)dirtyFile).getOldFile();
        if (oldFile == null) {
            return;
        }
        IPath path = oldFile.getProjectRelativePath();
        if (path == null) {
            return;
        }
        String oldFileName = path.toOSString();
        if (oldFileName == null || oldFileName.isEmpty()) {
            return;
        }
        if (this.maxLinesExceedFileNames.remove(oldFileName)) {
            this.maxLinesExceedFileNames.add(newFileName);
        }
        if (this.parseTimeoutFileNames.remove(oldFileName)) {
            this.parseTimeoutFileNames.add(newFileName);
        }
        if (this.semanticTimeoutFileNames.remove(oldFileName)) {
            this.semanticTimeoutFileNames.add(newFileName);
        }
        if (this.elaborationFileNames.remove(oldFileName)) {
            this.elaborationFileNames.add(newFileName);
        }
        if (this.buildAutoDisabledFileNames.remove(oldFileName)) {
            this.buildAutoDisabledFileNames.add(newFileName);
        }
        if (this.unexpectedFailureFileNames.remove(oldFileName)) {
            this.unexpectedFailureFileNames.add(newFileName);
        }
        this.renamedFileNames.remove(oldFileName);
    }

    protected void removeReason(FNotificationDirtyReason reason) {
        switch (reason) {
            case MAX_LINES_EXCEEDED: {
                this.maxLinesExceedFileNames.clear();
                break;
            }
            case PARSE_TIMEOUT: {
                this.parseTimeoutFileNames.clear();
                break;
            }
            case SEMANTIC_TIMEOUT: {
                this.semanticTimeoutFileNames.clear();
                break;
            }
            case ELABORATION: {
                this.elaborationFileNames.clear();
                break;
            }
            case BUILD_AUTO_DISABLED: {
                this.buildAutoDisabledFileNames.clear();
                break;
            }
            case UNEXPECTED_EXCEPTION: {
                this.unexpectedFailureFileNames.clear();
                break;
            }
            case BUILD_CONFIG_CHANGED: {
                this.isActiveBuildConfigChanged = false;
                break;
            }
            case MACROS_CHANGED: {
                this.changedMacros.clear();
                break;
            }
            case PRECOMPILED_SOURCES_OUT_OF_SYNC: {
                this.outOfSyncPrecompiledLibraries.clear();
                break;
            }
            case SPLIT_INVOCATION_OUT_OF_SYNC: {
                this.outOfSyncSplitInvocation.clear();
                break;
            }
            case TOO_MANY_FILES_CHANGED: {
                this.noOfchangedFiles = 0;
                break;
            }
            case ANY: {
                this.maxLinesExceedFileNames.clear();
                this.parseTimeoutFileNames.clear();
                this.semanticTimeoutFileNames.clear();
                this.elaborationFileNames.clear();
                this.buildAutoDisabledFileNames.clear();
                this.unexpectedFailureFileNames.clear();
                this.renamedFileNames.clear();
                this.isActiveBuildConfigChanged = false;
                this.changedMacros.clear();
                this.noOfchangedFiles = 0;
                break;
            }
            default: {
                return;
            }
        }
    }

    protected void removeFileName(IResource file) {
        if (file == null) {
            return;
        }
        IPath path = file.getProjectRelativePath();
        if (path == null) {
            return;
        }
        String fileName = path.toOSString();
        if (fileName == null || fileName.isEmpty()) {
            return;
        }
        if (this.maxLinesExceedFileNames.remove(fileName)) {
            return;
        }
        if (this.parseTimeoutFileNames.remove(fileName)) {
            return;
        }
        if (this.semanticTimeoutFileNames.remove(fileName)) {
            return;
        }
        if (this.elaborationFileNames.remove(fileName)) {
            return;
        }
        if (this.buildAutoDisabledFileNames.remove(fileName)) {
            return;
        }
        this.unexpectedFailureFileNames.remove(fileName);
    }

    protected String getMessage() {
        StringBuilder unexpectedFailureSb;
        StringBuilder message = new StringBuilder();
        message.append((CharSequence)this.headerText);
        if (this.isActiveBuildConfigChanged) {
            message.append(DVTStringUtil.LINE_SEPARATOR).append("Active build configuration file changed.").append(DVTStringUtil.LINE_SEPARATOR);
        }
        if (!this.maxLinesExceedFileNames.isEmpty()) {
            message.append(DVTStringUtil.LINE_SEPARATOR).append("Incremental max lines exceeded for the following files: ");
            StringBuilder maxLinesExceedSb = new StringBuilder();
            this.maxLinesExceedFileNames.forEach(fileName -> {
                StringBuilder stringBuilder2 = maxLinesExceedSb.append(DVTStringUtil.LINE_SEPARATOR).append((String)fileName);
            });
            maxLinesExceedSb.append(DVTStringUtil.LINE_SEPARATOR);
            message.append((CharSequence)maxLinesExceedSb);
        }
        if (!this.parseTimeoutFileNames.isEmpty()) {
            message.append(DVTStringUtil.LINE_SEPARATOR).append("Incremental parsing timeout for the following files: ");
            StringBuilder parseTimeoutSb = new StringBuilder();
            this.parseTimeoutFileNames.forEach(fileName -> {
                StringBuilder stringBuilder2 = parseTimeoutSb.append(DVTStringUtil.LINE_SEPARATOR).append((String)fileName);
            });
            parseTimeoutSb.append(DVTStringUtil.LINE_SEPARATOR);
            message.append((CharSequence)parseTimeoutSb);
        }
        if (!this.semanticTimeoutFileNames.isEmpty()) {
            message.append(DVTStringUtil.LINE_SEPARATOR).append("Incremental semantic checking canceled for the following files: ");
            StringBuilder semanticTimeoutSb = new StringBuilder();
            this.semanticTimeoutFileNames.forEach(fileName -> {
                StringBuilder stringBuilder2 = semanticTimeoutSb.append(DVTStringUtil.LINE_SEPARATOR).append((String)fileName);
            });
            semanticTimeoutSb.append(DVTStringUtil.LINE_SEPARATOR);
            message.append((CharSequence)semanticTimeoutSb);
        }
        if (!this.elaborationFileNames.isEmpty()) {
            message.append(DVTStringUtil.LINE_SEPARATOR).append("Full elaboration recommended after changing the following files: ");
            StringBuilder elaborationSb = new StringBuilder();
            this.elaborationFileNames.forEach(fileName -> {
                StringBuilder stringBuilder2 = elaborationSb.append(DVTStringUtil.LINE_SEPARATOR).append((String)fileName);
            });
            elaborationSb.append(DVTStringUtil.LINE_SEPARATOR);
            message.append((CharSequence)elaborationSb);
        }
        if (!this.buildAutoDisabledFileNames.isEmpty()) {
            message.append(DVTStringUtil.LINE_SEPARATOR).append("Changed files: ");
            StringBuilder buildAutoSb = new StringBuilder();
            this.buildAutoDisabledFileNames.forEach(fileName -> {
                StringBuilder stringBuilder2 = buildAutoSb.append(DVTStringUtil.LINE_SEPARATOR).append((String)fileName);
            });
            buildAutoSb.append(DVTStringUtil.LINE_SEPARATOR);
            message.append((CharSequence)buildAutoSb);
        }
        if (!this.renamedFileNames.isEmpty()) {
            message.append(DVTStringUtil.LINE_SEPARATOR).append("Renamed files: ");
            StringBuilder renameFileSb = new StringBuilder();
            this.renamedFileNames.forEach(fileName -> {
                StringBuilder stringBuilder2 = renameFileSb.append(DVTStringUtil.LINE_SEPARATOR).append((String)fileName);
            });
            renameFileSb.append(DVTStringUtil.LINE_SEPARATOR);
            message.append((CharSequence)renameFileSb);
        }
        if (!this.changedMacros.isEmpty()) {
            message.append(DVTStringUtil.LINE_SEPARATOR).append("Changes of the following macro definitions could not be handled incrementally:");
            unexpectedFailureSb = new StringBuilder();
            this.changedMacros.forEach(fileName -> {
                StringBuilder stringBuilder2 = unexpectedFailureSb.append(DVTStringUtil.LINE_SEPARATOR).append((String)fileName);
            });
            unexpectedFailureSb.append(DVTStringUtil.LINE_SEPARATOR);
            message.append((CharSequence)unexpectedFailureSb);
        }
        if (!this.outOfSyncPrecompiledLibraries.isEmpty()) {
            message.append(DVTStringUtil.LINE_SEPARATOR).append("The following precompiled libraries are out of sync (source files changed):");
            unexpectedFailureSb = new StringBuilder();
            this.outOfSyncPrecompiledLibraries.forEach(fileName -> {
                StringBuilder stringBuilder2 = unexpectedFailureSb.append(DVTStringUtil.LINE_SEPARATOR).append((String)fileName);
            });
            unexpectedFailureSb.append(DVTStringUtil.LINE_SEPARATOR);
            message.append((CharSequence)unexpectedFailureSb);
        }
        if (!this.outOfSyncSplitInvocation.isEmpty()) {
            message.append(DVTStringUtil.LINE_SEPARATOR).append("Split invocation configuration is out of sync because of the following modules: ");
            StringBuilder libraryElementsMessage = new StringBuilder();
            for (Map.Entry<SplitInvocationUtils.SplitInvocationLibraryElementsMessageType, List<String>> outOfSyncLibrary : this.outOfSyncSplitInvocation.entrySet()) {
                String type = outOfSyncLibrary.getKey() == SplitInvocationUtils.SplitInvocationLibraryElementsMessageType.REMOVED ? "Removed library elements" : "Added library elements";
                List<String> libraryElements = outOfSyncLibrary.getValue();
                libraryElementsMessage.append(DVTStringUtil.LINE_SEPARATOR).append(type).append(": ").append(String.join((CharSequence)", ", libraryElements));
            }
            libraryElementsMessage.append(DVTStringUtil.LINE_SEPARATOR);
            message.append((CharSequence)libraryElementsMessage);
        }
        if (this.areTooManyFilesChanged()) {
            message.append(DVTStringUtil.LINE_SEPARATOR).append("More than 50 files have been changed since last build.").append(DVTStringUtil.LINE_SEPARATOR);
        }
        if (this.hasScriptingEditors) {
            message.append(DVTStringUtil.LINE_SEPARATOR).append("Power format restore is not supported.").append(DVTStringUtil.LINE_SEPARATOR);
        }
        if (!this.unexpectedFailureFileNames.isEmpty()) {
            message.append(DVTStringUtil.LINE_SEPARATOR).append("Incremental build failed for the following files: ");
            unexpectedFailureSb = new StringBuilder();
            this.unexpectedFailureFileNames.forEach(fileName -> {
                StringBuilder stringBuilder2 = unexpectedFailureSb.append(DVTStringUtil.LINE_SEPARATOR).append((String)fileName);
            });
            unexpectedFailureSb.append(DVTStringUtil.LINE_SEPARATOR);
            message.append((CharSequence)unexpectedFailureSb);
        }
        return message.toString();
    }

    public ArrayList<Integer> getFileCategoriesSizes() {
        return new ArrayList<Integer>(Arrays.asList(this.maxLinesExceedFileNames.size(), this.parseTimeoutFileNames.size(), this.semanticTimeoutFileNames.size(), this.elaborationFileNames.size(), this.buildAutoDisabledFileNames.size(), this.renamedFileNames.size(), this.changedMacros.size(), this.outOfSyncPrecompiledLibraries.size(), this.outOfSyncSplitInvocation.size(), this.unexpectedFailureFileNames.size()));
    }

    public boolean isActiveBuildConfigChanged() {
        return this.isActiveBuildConfigChanged;
    }

    public boolean areTooManyFilesChanged() {
        return this.noOfchangedFiles != 0;
    }

    protected void setBuildCanceled(IBuildDoneListener.BuildFinishReason cancelReason, String projectName) {
        if (projectName == null) {
            return;
        }
        this.headerText.setLength(0);
        this.headerText.append(" Database is not up to date, update now").append(" (full build).").append(DVTStringUtil.LINE_SEPARATOR);
        if (IBuildDoneListener.BuildFinishReason.RESTORE_CANCEL == cancelReason) {
            this.headerText.append(" The restore of project '");
        } else if (IBuildDoneListener.BuildFinishReason.FULL_BUILD_CANCEL == cancelReason) {
            this.headerText.append(" The full build of project '");
        } else if (IBuildDoneListener.BuildFinishReason.PRECOMPILED_LIB_LOAD_CANCEL == cancelReason) {
            this.headerText.append(" Fail to load precompiled database of project ");
        }
        this.headerText.append(projectName);
        this.headerText.append(IBuildDoneListener.BuildFinishReason.PRECOMPILED_LIB_LOAD_CANCEL == cancelReason ? " because DVT version changed. " : "' was cancelled by user.");
    }

    public boolean hasScriptingEditors() {
        return this.hasScriptingEditors;
    }

    public void setScriptingEditors(boolean hasScriptingEditors) {
        this.hasScriptingEditors = hasScriptingEditors;
    }
}

