/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.floatingwidgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.floatingwidgets.DVTFNotificationProvider;
import ro.amiq.dvt.model.floatingwidgets.FDirtyScriptingEditorResource;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyFile;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyPrecompiledLibraries;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyProject;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalFixJobCommon;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationFixer;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationText;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyResource;
import ro.amiq.dvt.model.floatingwidgets.IFNotificationTracker;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotificationFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.preferences.EclipsePreferencesUtils;

public enum FIncrementalNotificationTracker implements IFNotificationTracker
{
    INSTANCE;

    private HashMap<IProject, Set<FIncrementalDirtyFile>> dirtyIncrementalMap = new HashMap(1);
    private HashMap<IProject, FIncrementalDirtyProject> dirtyProjectMap = new HashMap(1);
    private HashMap<String, FIncrementalNotificationText> incrementalNotificationText = new HashMap(1);
    private HashMap<String, IBuildDoneListener.BuildFinishReason> buildCancelMap = new HashMap(1);
    private HashMap<String, FDirtyScriptingEditorResource> scriptingEditorsMap = new HashMap(1);
    private AtomicBoolean isAutoBuildDisabled = new AtomicBoolean();
    private List<FIncrementalDirtyFile> semanticCandidates;

    @Override
    public synchronized void addDirtyResource(IProject project, FNotificationDirtyResource dirtyResource) {
        if (project == null) {
            return;
        }
        String projectName = project.getName();
        if (projectName == null) {
            return;
        }
        if (dirtyResource instanceof FIncrementalDirtyPrecompiledLibraries) {
            this.addDirtyPrecompiledLibraries(project, (FIncrementalDirtyPrecompiledLibraries)dirtyResource);
            return;
        }
        if (dirtyResource instanceof FIncrementalDirtyProject) {
            this.addDirtyProject(project, (FIncrementalDirtyProject)dirtyResource);
            return;
        }
        if (dirtyResource instanceof FDirtyScriptingEditorResource) {
            this.addDirtyScriptingEditor(project, (FDirtyScriptingEditorResource)dirtyResource);
            return;
        }
        if (!(dirtyResource instanceof FIncrementalDirtyFile)) {
            return;
        }
        FIncrementalDirtyFile dirtyFile = (FIncrementalDirtyFile)dirtyResource;
        if (dirtyFile.getResource() == null || dirtyFile.getReason() == null) {
            return;
        }
        Set<FIncrementalDirtyFile> dirtyFiles = this.dirtyIncrementalMap.get(project);
        if (dirtyFiles == null) {
            dirtyFiles = new HashSet<FIncrementalDirtyFile>();
            this.dirtyIncrementalMap.put(project, dirtyFiles);
        }
        boolean hasDeprecatedFile = dirtyFiles.removeIf(x -> x != null && dirtyFile.getResource().equals((Object)x.getResource()) && dirtyFile.getReason() == x.getReason());
        dirtyFiles.add(dirtyFile);
        FIncrementalNotificationText notificationText = this.incrementalNotificationText.get(projectName);
        if (notificationText == null) {
            notificationText = new FIncrementalNotificationText();
            this.incrementalNotificationText.put(projectName, notificationText);
        }
        if (hasDeprecatedFile) {
            notificationText.removeFileName(dirtyFile.getResource());
        }
        notificationText.addFileName(dirtyFile);
        int noOfDirtyFiles = dirtyFiles.size();
        if (noOfDirtyFiles == 1 || noOfDirtyFiles == 50 || FIncrementalFixJobCommon.isFullBuildReason(dirtyFile)) {
            notificationText.updateHeaderText(this.isAutoBuildDisabled.get(), noOfDirtyFiles);
        }
    }

    void addDirtyScriptingEditor(IProject project, FDirtyScriptingEditorResource dirtyResource) {
        if (project == null) {
            return;
        }
        String projectName = project.getName();
        if (projectName == null) {
            return;
        }
        this.scriptingEditorsMap.put(projectName, dirtyResource);
        FIncrementalNotificationText notificationText = this.incrementalNotificationText.get(projectName);
        if (notificationText == null) {
            notificationText = new FIncrementalNotificationText();
            this.incrementalNotificationText.put(projectName, notificationText);
        }
        notificationText.addFileName(dirtyResource);
        notificationText.updateHeaderText(this.isAutoBuildDisabled.get(), 0);
    }

    void addDirtyPrecompiledLibraries(IProject project, FIncrementalDirtyPrecompiledLibraries dirtyProject) {
        if (project == null) {
            return;
        }
        String projectName = project.getName();
        if (projectName == null) {
            return;
        }
        this.dirtyProjectMap.put(project, dirtyProject);
        FIncrementalNotificationText notificationText = this.incrementalNotificationText.get(projectName);
        if (notificationText == null) {
            notificationText = new FIncrementalNotificationText();
            this.incrementalNotificationText.put(projectName, notificationText);
        }
        notificationText.addFileName(dirtyProject);
        notificationText.updateHeaderText(this.isAutoBuildDisabled.get(), dirtyProject.getNOfFiles());
    }

    private void addDirtyProject(IProject project, FIncrementalDirtyProject dirtyInfo) {
        if (project == null) {
            return;
        }
        String projectName = project.getName();
        if (projectName == null) {
            return;
        }
        this.dirtyProjectMap.put(project, dirtyInfo);
        FIncrementalNotificationText notificationText = this.incrementalNotificationText.get(projectName);
        if (notificationText == null) {
            notificationText = new FIncrementalNotificationText();
            this.incrementalNotificationText.put(projectName, notificationText);
        }
        notificationText.addFileName(dirtyInfo);
        notificationText.updateHeaderText(this.isAutoBuildDisabled.get(), dirtyInfo.getNOfFiles());
    }

    @Override
    public synchronized void removeDirtyResource(IProject project, IResource resource) {
        this.removeDirtyFiles(project, resource, FNotificationDirtyReason.ANY);
    }

    private synchronized void removeDirtyFiles(IProject project, IResource resource, FNotificationDirtyReason dirtyReason) {
        FIncrementalNotificationText notificationText;
        if (resource == null || dirtyReason == null || project == null) {
            return;
        }
        String projectName = project.getName();
        if (projectName == null) {
            return;
        }
        Set<FIncrementalDirtyFile> dirtyFiles = this.dirtyIncrementalMap.get(project);
        if (dirtyFiles == null) {
            return;
        }
        dirtyFiles.removeIf(x -> resource.equals((Object)x.getResource()) && (dirtyReason != FNotificationDirtyReason.ANY || x.getReason() != FNotificationDirtyReason.RENAME_FILE));
        if (dirtyFiles.isEmpty()) {
            this.dirtyIncrementalMap.remove(project);
        }
        if ((notificationText = this.incrementalNotificationText.get(projectName)) == null) {
            return;
        }
        notificationText.removeFileName(resource);
        int noOfDirtyFiles = dirtyFiles.size();
        if (noOfDirtyFiles == 0 || noOfDirtyFiles == 49) {
            notificationText.updateHeaderText(this.isAutoBuildDisabled.get(), noOfDirtyFiles);
        }
    }

    public synchronized void removeDirtyFiles(IProject project, FNotificationDirtyReason dirtyReason) {
        FIncrementalNotificationText notificationText;
        if (project == null || dirtyReason == null) {
            return;
        }
        String projectName = project.getName();
        if (projectName == null) {
            return;
        }
        Set<FIncrementalDirtyFile> dirtyFiles = this.dirtyIncrementalMap.get(project);
        if (dirtyFiles == null) {
            return;
        }
        int oldNoOfDirtyFiles = dirtyFiles.size();
        dirtyFiles.removeIf(x -> dirtyReason.equals(x.getReason()));
        if (dirtyFiles.isEmpty()) {
            this.dirtyIncrementalMap.remove(project);
        }
        if ((notificationText = this.incrementalNotificationText.get(projectName)) == null) {
            return;
        }
        notificationText.removeReason(dirtyReason);
        int newNoOfDirtyFiles = dirtyFiles.size();
        if (newNoOfDirtyFiles == 0 || oldNoOfDirtyFiles >= 50 && newNoOfDirtyFiles < 50) {
            notificationText.updateHeaderText(this.isAutoBuildDisabled.get(), newNoOfDirtyFiles);
        }
    }

    public synchronized void addTransientSemanticCandidates(List<FileCompileInfo> changedFiles, DVTFNotificationProvider provider) {
        if (provider == null || changedFiles == null) {
            return;
        }
        this.semanticCandidates = new ArrayList<FIncrementalDirtyFile>(1);
        for (FileCompileInfo changedFile : changedFiles) {
            IFile file = changedFile.getFile();
            if (file == null) continue;
            this.semanticCandidates.add(new FIncrementalDirtyFile(file, FNotificationDirtyReason.SEMANTIC_TIMEOUT, provider));
        }
    }

    public synchronized void confirmTransientSemanticDirtyCandidate(IProject project) {
        if (this.semanticCandidates == null || project == null) {
            return;
        }
        String projectName = project.getName();
        if (projectName == null) {
            return;
        }
        Set<FIncrementalDirtyFile> dirtyFiles = this.dirtyIncrementalMap.get(project);
        if (dirtyFiles == null) {
            dirtyFiles = new HashSet<FIncrementalDirtyFile>();
            this.dirtyIncrementalMap.put(project, dirtyFiles);
        }
        int oldNoOfDirtyFiles = dirtyFiles.size();
        dirtyFiles.addAll(this.semanticCandidates);
        FIncrementalNotificationText notificationText = this.incrementalNotificationText.get(projectName);
        if (notificationText == null) {
            notificationText = new FIncrementalNotificationText();
            this.incrementalNotificationText.put(projectName, notificationText);
        }
        for (FNotificationDirtyResource fNotificationDirtyResource : this.semanticCandidates) {
            notificationText.addFileName(fNotificationDirtyResource);
        }
        int n = oldNoOfDirtyFiles + this.semanticCandidates.size();
        if (oldNoOfDirtyFiles == 0 || oldNoOfDirtyFiles < 50 && n >= 50) {
            notificationText.updateHeaderText(this.isAutoBuildDisabled.get(), n);
        }
    }

    public synchronized void resetTransientSemanticDirtyCandidates(IProject project) {
        FIncrementalNotificationText notificationText;
        if (this.semanticCandidates == null || project == null) {
            return;
        }
        String projectName = project.getName();
        if (projectName == null) {
            return;
        }
        Set<FIncrementalDirtyFile> dirtyFiles = this.dirtyIncrementalMap.get(project);
        if (dirtyFiles == null) {
            return;
        }
        int oldNoOfDirtyFiles = dirtyFiles.size();
        for (FIncrementalDirtyFile dirtyFile : this.semanticCandidates) {
            IResource file = dirtyFile.getResource();
            if (file == null) continue;
            dirtyFiles.removeIf(x -> file.equals((Object)x.getResource()) && FNotificationDirtyReason.SEMANTIC_TIMEOUT.equals(x.getReason()));
        }
        if (dirtyFiles.isEmpty()) {
            this.dirtyIncrementalMap.remove(project);
        }
        if ((notificationText = this.incrementalNotificationText.get(projectName)) == null) {
            return;
        }
        notificationText.removeReason(FNotificationDirtyReason.SEMANTIC_TIMEOUT);
        int newNoOfDirtyFiles = dirtyFiles.size();
        if (newNoOfDirtyFiles == 0 || oldNoOfDirtyFiles >= 50 && newNoOfDirtyFiles < 50) {
            notificationText.updateHeaderText(this.isAutoBuildDisabled.get(), newNoOfDirtyFiles);
        }
    }

    @Override
    public synchronized List<FNotificationDirtyResource> getDirtyResources(IProject project) {
        if (project == null) {
            return Collections.emptyList();
        }
        Set<FIncrementalDirtyFile> dirtyFiles = this.dirtyIncrementalMap.get(project);
        if (dirtyFiles == null || dirtyFiles.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<FNotificationDirtyResource>(dirtyFiles);
    }

    private boolean isDirtyProject(IProject project) {
        return this.dirtyProjectMap.get(project) != null;
    }

    protected FIncrementalDirtyProject getDirtyProjectInfo(IProject project) {
        return this.dirtyProjectMap.get(project);
    }

    @Override
    public synchronized boolean isDirty(IProject project) {
        if (this.isAutoBuildDisabled.get()) {
            return true;
        }
        if (project == null) {
            return false;
        }
        String projectName = project.getName();
        if (projectName == null || projectName.isEmpty()) {
            return false;
        }
        IBuildDoneListener.BuildFinishReason buildCancelReason = this.buildCancelMap.get(projectName);
        if (buildCancelReason != null && IBuildDoneListener.BuildFinishReason.BUILD_SUCCESS != buildCancelReason) {
            return true;
        }
        Set<FIncrementalDirtyFile> dirtyFiles = this.dirtyIncrementalMap.get(project);
        if (dirtyFiles != null && !dirtyFiles.isEmpty() || this.isDirtyProject(project)) {
            return true;
        }
        FDirtyScriptingEditorResource dirtyScriptingEditors = this.scriptingEditorsMap.get(projectName);
        return dirtyScriptingEditors != null;
    }

    @Override
    public synchronized String getNotificationText(IProject project) {
        FIncrementalNotificationText notificationText = this.incrementalNotificationText.get(project.getName());
        if (notificationText == null) {
            return "";
        }
        return notificationText.getMessage();
    }

    public synchronized FIncrementalNotificationText getIncrementalNotificationText(IProject project) {
        if (project == null) {
            return null;
        }
        String projectName = project.getName();
        if (projectName == null) {
            return null;
        }
        return this.incrementalNotificationText.get(projectName);
    }

    public synchronized void setAutoBuildState() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (workspaceRoot == null) {
            return;
        }
        boolean autobuildOn = EclipsePreferencesUtils.isAutobuildOn();
        this.isAutoBuildDisabled.set(!autobuildOn);
        IProject[] projects = workspaceRoot.getProjects();
        if (projects == null) {
            return;
        }
        int i = 0;
        while (i < projects.length) {
            String projectName;
            if (projects[i] != null && (projectName = projects[i].getName()) != null) {
                FIncrementalNotificationText notificationText;
                if (autobuildOn) {
                    INSTANCE.removeDirtyFiles(projects[i], FNotificationDirtyReason.BUILD_AUTO_DISABLED);
                }
                if ((notificationText = this.incrementalNotificationText.get(projectName)) == null) {
                    notificationText = new FIncrementalNotificationText();
                    this.incrementalNotificationText.put(projectName, notificationText);
                }
                notificationText.updateHeaderText(!autobuildOn, this.getDirtyResources(projects[i]).size());
            }
            ++i;
        }
    }

    public synchronized boolean isAutoBuildDisabled() {
        return this.isAutoBuildDisabled.get();
    }

    public synchronized boolean isActiveBuildConfigChanged(IProject project) {
        if (project == null) {
            return false;
        }
        String projectName = project.getName();
        if (projectName == null) {
            return false;
        }
        FIncrementalNotificationText incrementalNotificationText = this.incrementalNotificationText.get(projectName);
        if (incrementalNotificationText == null) {
            return false;
        }
        return incrementalNotificationText.isActiveBuildConfigChanged();
    }

    public synchronized void unregisterProject(IProject project) {
        if (project == null) {
            return;
        }
        Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.disposeAll(FWidgetType.DB_OUT_OF_SYNC, project));
        this.dirtyIncrementalMap.remove(project);
        this.dirtyProjectMap.remove(project);
        this.handleNotificationText(project);
        if (project != null && project.getName() != null) {
            this.scriptingEditorsMap.remove(project.getName());
        }
        FIncrementalNotificationFixer.INSTANCE.clearJob(project);
        FNotificationFactory.INSTANCE.clear();
    }

    private void handleNotificationText(IProject project) {
        if (project == null) {
            return;
        }
        String projectName = project.getName();
        if (projectName == null) {
            return;
        }
        if (!this.isAutoBuildDisabled.get()) {
            this.incrementalNotificationText.remove(projectName);
            return;
        }
        FIncrementalNotificationText notificationText = this.incrementalNotificationText.get(projectName);
        if (notificationText == null) {
            return;
        }
        notificationText.removeReason(FNotificationDirtyReason.ANY);
        notificationText.updateHeaderText(true, 0);
    }

    public synchronized boolean hasRenamedDirtyFile(IProject project) {
        Set<FIncrementalDirtyFile> dirtyFiles = this.dirtyIncrementalMap.get(project);
        if (dirtyFiles == null || dirtyFiles.isEmpty()) {
            return false;
        }
        for (FNotificationDirtyResource fNotificationDirtyResource : dirtyFiles) {
            if (!FNotificationDirtyReason.RENAME_FILE.equals(fNotificationDirtyResource.getReason())) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isUpdating(IProject project) {
        return FIncrementalNotificationFixer.INSTANCE.getFixJobState(project) != 0;
    }

    public void buildCancelUpdate(String projectName, IBuildDoneListener.BuildFinishReason buildFinishReason) {
        if (projectName == null) {
            FWidgetFactory.INSTANCE.paint(true, FWidgetType.DB_OUT_OF_SYNC);
            return;
        }
        if (IBuildDoneListener.BuildFinishReason.isSuccessful(buildFinishReason)) {
            boolean shouldKeepNotificationTextAfterRestore;
            boolean bl = shouldKeepNotificationTextAfterRestore = IBuildDoneListener.BuildFinishReason.RESTORE_SUCCES == buildFinishReason && this.scriptingEditorsMap.get(projectName) != null;
            if (!shouldKeepNotificationTextAfterRestore) {
                this.incrementalNotificationText.remove(projectName);
            }
            this.buildCancelMap.remove(projectName);
            FWidgetFactory.INSTANCE.paint(true, FWidgetType.DB_OUT_OF_SYNC);
            return;
        }
        this.buildCancelMap.put(projectName, buildFinishReason);
        FIncrementalNotificationText notificationText = new FIncrementalNotificationText();
        notificationText.setBuildCanceled(buildFinishReason, projectName);
        this.incrementalNotificationText.put(projectName, notificationText);
        FWidgetFactory.INSTANCE.paint(true, FWidgetType.DB_OUT_OF_SYNC);
    }

    private IBuildDoneListener.BuildFinishReason getBuildCanceledReason(IProject project) {
        if (project == null) {
            return null;
        }
        String projectName = project.getName();
        if (projectName == null) {
            return null;
        }
        return this.buildCancelMap.get(projectName);
    }

    public synchronized boolean isFullBuildNeeded(IProject project) {
        IBuildDoneListener.BuildFinishReason buildCanceledReason = this.getBuildCanceledReason(project);
        if (buildCanceledReason != null && IBuildDoneListener.BuildFinishReason.BUILD_SUCCESS != buildCanceledReason) {
            return true;
        }
        if (project != null && project.getName() != null && this.scriptingEditorsMap.get(project.getName()) != null) {
            return true;
        }
        return this.isDirtyProject(project);
    }

    protected synchronized boolean isPrecompileDbGenerationNeeded(IProject project) {
        FIncrementalDirtyProject dirtyProject = this.dirtyProjectMap.get(project);
        if (dirtyProject == null) {
            return false;
        }
        return FNotificationDirtyReason.PRECOMPILED_SOURCES_OUT_OF_SYNC.equals(dirtyProject.getReason());
    }

    protected synchronized boolean isSplitInvocationGenerationNeeded(IProject project) {
        FIncrementalDirtyProject dirtyProject = this.dirtyProjectMap.get(project);
        if (dirtyProject == null) {
            return false;
        }
        return FNotificationDirtyReason.SPLIT_INVOCATION_OUT_OF_SYNC.equals(dirtyProject.getReason());
    }

    public void removePFDirtyReason(IProject project) {
        if (project == null) {
            return;
        }
        String projectName = project.getName();
        if (projectName == null) {
            return;
        }
        this.scriptingEditorsMap.remove(projectName);
        FIncrementalNotificationText notificationText = this.incrementalNotificationText.get(projectName);
        if (notificationText != null) {
            notificationText.setScriptingEditors(false);
        }
    }
}

