/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.floatingwidgets;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.model.floatingwidgets.FLazyResourcesNotificationTracker;
import ro.amiq.dvt.resourcefilters.lazyfilters.LazyResourcesModelManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;

public class FLazyResourcesFixJob
extends Job {
    private static final String NAME = "Open the configuration file";
    private IProject project;

    public FLazyResourcesFixJob(IProject project) {
        super(NAME);
        this.project = project;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IFile configFile = LazyResourcesModelManager.INSTANCE.getConfigurationFile(this.project);
        if (configFile == null) {
            return Status.CANCEL_STATUS;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            try {
                IDE.openEditor((IWorkbenchPage)DVTUiUtils.getActiveWorkbenchWindow().getActivePage(), (IFile)configFile);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
        FLazyResourcesNotificationTracker.INSTANCE.disposeNotification(this.project);
        return Status.OK_STATUS;
    }

    public void dispose() {
        this.project = null;
    }
}

