/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.floatingwidgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.model.floatingwidgets.FLazyResourcesDirtyWrapper;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyResource;
import ro.amiq.dvt.model.floatingwidgets.IFNotificationTracker;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.utils.DVTStringUtil;

public enum FLazyResourcesNotificationTracker implements IFNotificationTracker
{
    INSTANCE;

    private Map<IProject, FLazyResourcesDirtyWrapper> extendedResources = new LinkedHashMap<IProject, FLazyResourcesDirtyWrapper>();

    public void init(IProject project) {
        if (this.extendedResources.containsKey(project)) {
            return;
        }
        this.extendedResources.put(project, new FLazyResourcesDirtyWrapper(FNotificationDirtyReason.NEW_LAZY_RESOURCE_ADDED));
    }

    @Override
    public void addDirtyResource(IProject project, FNotificationDirtyResource resource) {
        if (project == null || !(resource instanceof FLazyResourcesDirtyWrapper)) {
            return;
        }
        FLazyResourcesDirtyWrapper lazyResource = (FLazyResourcesDirtyWrapper)resource;
        this.extendedResources.put(project, lazyResource);
        if (this.isDirty(project)) {
            FWidgetFactory.INSTANCE.paint(false, FWidgetType.LAZY_RESOURCES);
        }
    }

    public void addDirtyResource(IProject project, String root) {
        if (project == null) {
            return;
        }
        FLazyResourcesDirtyWrapper fLazyResourcesDirtyWrapper = this.extendedResources.get(project);
        if (fLazyResourcesDirtyWrapper == null) {
            return;
        }
        fLazyResourcesDirtyWrapper.addRoot(root);
        if (this.isDirty(project)) {
            FWidgetFactory.INSTANCE.paint(false, FWidgetType.LAZY_RESOURCES);
        }
    }

    @Override
    public void removeDirtyResource(IProject project, IResource resource) {
        if (project == null || resource == null) {
            return;
        }
        FLazyResourcesDirtyWrapper extendedResource = this.extendedResources.get(project);
        if (extendedResource == null) {
            return;
        }
        IPath location = resource.getLocation();
        if (location != null) {
            extendedResource.removeRoot(location.toOSString());
        }
        if (!this.isDirty(project)) {
            Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.disposeAll(FWidgetType.LAZY_RESOURCES, project));
        }
    }

    @Override
    public List<FNotificationDirtyResource> getDirtyResources(IProject project) {
        return Collections.emptyList();
    }

    public List<String> getDirtyRoots(IProject project) {
        FLazyResourcesDirtyWrapper projectDirtyResources = this.extendedResources.get(project);
        if (projectDirtyResources == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(projectDirtyResources.getRoots());
    }

    @Override
    public String getNotificationText(IProject project) {
        StringBuilder message = new StringBuilder();
        message.append(" Resources added on top of the include first_level filtering for ").append(project.getName()).append(".");
        message.append(DVTStringUtil.LINE_SEPARATOR).append(DVTStringUtil.LINE_SEPARATOR);
        FLazyResourcesDirtyWrapper fLazyResourcesDirtyWrapper = this.extendedResources.get(project);
        for (String root : fLazyResourcesDirtyWrapper.getRoots()) {
            message.append(root).append(DVTStringUtil.LINE_SEPARATOR);
        }
        message.append(DVTStringUtil.LINE_SEPARATOR).append(" Check include first_level related filters.");
        message.append(DVTStringUtil.LINE_SEPARATOR).append(DVTStringUtil.LINE_SEPARATOR).append(" Dismiss notification.");
        message.append(DVTStringUtil.LINE_SEPARATOR);
        return message.toString();
    }

    @Override
    public boolean isDirty(IProject project) {
        if (project == null) {
            return false;
        }
        if (this.wasFileOpened(project)) {
            return false;
        }
        FLazyResourcesDirtyWrapper fLazyResourcesDirtyWrapper = this.extendedResources.get(project);
        if (fLazyResourcesDirtyWrapper == null) {
            return false;
        }
        return !fLazyResourcesDirtyWrapper.getRoots().isEmpty();
    }

    public boolean wasFileOpened(IProject project) {
        FLazyResourcesDirtyWrapper fLazyResourcesDirtyWrapper = this.extendedResources.get(project);
        if (fLazyResourcesDirtyWrapper == null) {
            return false;
        }
        return fLazyResourcesDirtyWrapper.isFileOpened();
    }

    public void disposeNotification(IProject project) {
        FLazyResourcesDirtyWrapper fLazyResourcesDirtyWrapper = this.extendedResources.get(project);
        if (fLazyResourcesDirtyWrapper == null) {
            return;
        }
        fLazyResourcesDirtyWrapper.setFileOpened(true);
        if (!this.isDirty(project)) {
            Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.disposeAll(FWidgetType.LAZY_RESOURCES, project));
        }
    }
}

