/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.floatingwidgets;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyResource;
import ro.amiq.dvt.model.floatingwidgets.IFNotificationTracker;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.preferences.PreferenceUtils;

public enum FMissingPluginNotificationTracker implements IFNotificationTracker
{
    INSTANCE;


    @Override
    public void addDirtyResource(IProject project, FNotificationDirtyResource resource) {
        if (project == null) {
            return;
        }
        if (!PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.EXTERNAL_PLUGIN_NOTIFICATION_ENABLED")) {
            return;
        }
        if (this.isDirty(project)) {
            Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.paint(false, FWidgetType.MISSING_PLUGIN));
        }
    }

    @Override
    public void removeDirtyResource(IProject project, IResource resource) {
        if (project == null) {
            return;
        }
        if (!this.isDirty(project)) {
            Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.disposeAll(FWidgetType.MISSING_PLUGIN, project));
        }
    }

    @Override
    public List<FNotificationDirtyResource> getDirtyResources(IProject project) {
        return Collections.emptyList();
    }

    @Override
    public boolean isDirty(IProject project) {
        if (project == null) {
            return false;
        }
        return Platform.getBundle((String)"org.eclipse.dltk.tcl.core") == null;
    }

    public void removeAllDirtyResources() {
        Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.disposeAll(FWidgetType.MISSING_PLUGIN));
    }
}

