/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.floatingwidgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.model.floatingwidgets.FMonitorDirtyResource;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyResource;
import ro.amiq.dvt.model.floatingwidgets.IFNotificationTracker;
import ro.amiq.dvt.ui.editor.floatingwidgets.FMonitorNotificationConstants;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.utils.DVTStringUtil;

public enum FMonitorNotificationTracker implements IFNotificationTracker
{
    INSTANCE;

    private final Comparator<IProject> PROJECT_COMPARATOR = (p1, p2) -> p1.getName().compareTo(p2.getName());
    private SortedMap<IProject, Set<FMonitorDirtyResource>> scanInProgressResources = new TreeMap<IProject, Set<FMonitorDirtyResource>>(this.PROJECT_COMPARATOR);
    private SortedMap<IProject, Set<FMonitorDirtyResource>> completeScanResources = new TreeMap<IProject, Set<FMonitorDirtyResource>>(this.PROJECT_COMPARATOR);
    private String cachedMessage = "";
    private String inProgressMessage = "";

    public synchronized void onMonitorDone() {
        this.completeScanResources = new TreeMap<IProject, Set<FMonitorDirtyResource>>(this.scanInProgressResources);
        this.cachedMessage = this.inProgressMessage;
        this.scanInProgressResources.clear();
        this.inProgressMessage = "";
    }

    @Override
    public void addDirtyResource(IProject project, FNotificationDirtyResource resource) {
        if (project == null || !(resource instanceof FMonitorDirtyResource)) {
            return;
        }
        TreeSet<FMonitorDirtyResource> projectDirtyPaths = (TreeSet<FMonitorDirtyResource>)this.scanInProgressResources.get(project);
        FMonitorDirtyResource monitorResource = (FMonitorDirtyResource)resource;
        if (projectDirtyPaths != null) {
            projectDirtyPaths.removeIf(dr -> dr.getPath().startsWith(monitorResource.getPath()));
            projectDirtyPaths.add(monitorResource);
            this.inProgressMessage = this.computeMessage();
            return;
        }
        projectDirtyPaths = new TreeSet<FMonitorDirtyResource>((r1, r2) -> r1.getPathString().compareTo(r2.getPathString()));
        projectDirtyPaths.add(monitorResource);
        this.scanInProgressResources.put(project, projectDirtyPaths);
        this.inProgressMessage = this.computeMessage();
    }

    @Override
    public void removeDirtyResource(IProject project, IResource resource) {
        if (project == null || resource == null) {
            return;
        }
        Set projectDirtyPaths = (Set)this.scanInProgressResources.get(project);
        if (projectDirtyPaths == null || projectDirtyPaths.isEmpty()) {
            return;
        }
        projectDirtyPaths.removeIf(dp -> resource.getProjectRelativePath().toOSString().equals(dp.getPathString()));
    }

    public void removeDirtyResources(IProject project) {
        if (project == null) {
            return;
        }
        this.scanInProgressResources.remove(project);
        this.inProgressMessage = this.computeMessage();
        if (!this.isDirty()) {
            Display.getDefault().syncExec(() -> FWidgetFactory.INSTANCE.disposeAll(FWidgetType.RESOURCE_MONITOR));
        }
    }

    @Override
    public synchronized List<FNotificationDirtyResource> getDirtyResources(IProject project) {
        Set projectDirtyResources = (Set)this.completeScanResources.get(project);
        if (projectDirtyResources == null || projectDirtyResources.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<FNotificationDirtyResource>(projectDirtyResources);
    }

    @Override
    public synchronized String getNotificationText(IProject useless) {
        return this.cachedMessage;
    }

    private String computeMessage() {
        StringBuilder message = new StringBuilder(FMonitorNotificationConstants.BIG_DIRECTORIES);
        message.append(DVTStringUtil.LINE_SEPARATOR);
        for (Map.Entry<IProject, Set<FMonitorDirtyResource>> entry : this.scanInProgressResources.entrySet()) {
            IProject project;
            Set<FMonitorDirtyResource> projectDirtyDirectories = entry.getValue();
            if (projectDirtyDirectories == null || projectDirtyDirectories.isEmpty() || !(project = entry.getKey()).isOpen()) continue;
            message.append(DVTStringUtil.LINE_SEPARATOR).append(" In project " + project.getName()).append(':');
            projectDirtyDirectories.forEach(dr -> {
                StringBuilder stringBuilder2 = message.append(DVTStringUtil.LINE_SEPARATOR).append(dr.getPath().toString());
            });
            message.append(DVTStringUtil.LINE_SEPARATOR);
        }
        message.append(DVTStringUtil.LINE_SEPARATOR);
        message.append(" Configure...");
        message.append(DVTStringUtil.LINE_SEPARATOR);
        return message.toString();
    }

    public synchronized boolean isDirty() {
        for (Set<FMonitorDirtyResource> s : this.completeScanResources.values()) {
            if (s == null || s.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDirty(IProject project) {
        return this.isDirty();
    }

    public synchronized void clear() {
        this.scanInProgressResources.clear();
        this.completeScanResources.clear();
    }

    public synchronized Map<IProject, Set<FMonitorDirtyResource>> getAllDirtyResources() {
        return new TreeMap<IProject, Set<FMonitorDirtyResource>>(this.completeScanResources);
    }

    public synchronized FMonitorDirtyResource getDirtyResource(String path) {
        for (Set<FMonitorDirtyResource> dirtyResources : this.completeScanResources.values()) {
            for (FMonitorDirtyResource dirtyResource : dirtyResources) {
                if (!dirtyResource.getPath().toString().equals(path)) continue;
                return dirtyResource;
            }
        }
        return null;
    }

    public synchronized boolean isDirtyProject(String projectName) {
        for (IProject project : this.completeScanResources.keySet()) {
            if (!project.getName().equals(projectName)) continue;
            return true;
        }
        return false;
    }
}

