/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.floatingwidgets;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyResource;
import ro.amiq.dvt.model.floatingwidgets.FReportIssueDirtyResource;
import ro.amiq.dvt.model.floatingwidgets.IFNotificationTracker;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.preferences.PreferenceUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public enum FReportIssueNotificationTracker implements IFNotificationTracker
{
    INSTANCE;

    private HashMap<IProject, FReportIssueDirtyResource> dirtyResourcesMap = new HashMap(1);

    @Override
    public void addDirtyResource(IProject project, FNotificationDirtyResource dirtyResource) {
        if (project == null) {
            return;
        }
        if (!(dirtyResource instanceof FReportIssueDirtyResource)) {
            return;
        }
        if (!PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.REPORT_AN_ISSUE_NOTIFICATION_ENABLED")) {
            return;
        }
        FReportIssueDirtyResource existingDirtyResource = this.dirtyResourcesMap.get(project);
        if (existingDirtyResource != null) {
            FReportIssueDirtyResource reportIssueDirtyResource = (FReportIssueDirtyResource)dirtyResource;
            FNotificationDirtyReason reason = reportIssueDirtyResource.getReason();
            existingDirtyResource.addReason(reason, reportIssueDirtyResource.getReasons().get(reason));
        } else {
            this.dirtyResourcesMap.put(project, (FReportIssueDirtyResource)dirtyResource);
        }
    }

    @Override
    public void removeDirtyResource(IProject project, IResource resource) {
        this.dirtyResourcesMap.remove(project);
        Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.disposeAll(FWidgetType.REPORT_ISSUE, project));
    }

    public void removeAllDirtyResources() {
        this.dirtyResourcesMap.clear();
        Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.disposeAll(FWidgetType.REPORT_ISSUE));
    }

    @Override
    public List<FNotificationDirtyResource> getDirtyResources(IProject project) {
        if (project == null) {
            return Collections.emptyList();
        }
        FReportIssueDirtyResource dirtyProject = this.dirtyResourcesMap.get(project);
        if (dirtyProject == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(dirtyProject);
    }

    @Override
    public boolean isDirty(IProject project) {
        if (project == null) {
            return false;
        }
        return this.dirtyResourcesMap.containsKey(project);
    }

    @Override
    public String getNotificationText(IProject project) {
        StringBuilder message = new StringBuilder();
        for (Map.Entry<FNotificationDirtyReason, String> reason : this.dirtyResourcesMap.get(project).getReasons().entrySet()) {
            message.append(this.getMessageForReason(reason.getKey()));
            if (reason.getValue() != null) {
                message.append(" ").append(reason.getValue());
            }
            message.append(DVTStringUtil.LINE_SEPARATOR);
        }
        message.append(DVTStringUtil.LINE_SEPARATOR).append(" Sending a DVT Issue Report is recommended." + DVTStringUtil.LINE_SEPARATOR + DVTStringUtil.LINE_SEPARATOR + DVTStringUtil.LINE_SEPARATOR + " Dismiss notification." + DVTStringUtil.LINE_SEPARATOR);
        return message.toString();
    }

    public String getMessageForReason(FNotificationDirtyReason reason) {
        switch (reason) {
            case INCREMENTAL_THREAD_DUMP_COLLECTED: {
                return " Incremental build took longer than expected.";
            }
            case PRECOMPILED_AUTO_INFINITE_LOOP: {
                return " Unable to precompile the following libraries so they were fully built: ";
            }
        }
        return "";
    }
}

