/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.indexer;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.model.indexer.GreyCodePair;
import ro.amiq.dvt.model.indexer.IIdentifierIndexerExtension;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.Utils;

public abstract class AbstractIdentifierIndexer
implements IIdentifierIndexerExtension {
    private Map<String, Set<Integer>> fIdentifiersMap = new HashMap<String, Set<Integer>>();
    private Map<String, Set<GreyCodePair>> fIdentifiersMapInGreyCode = new HashMap<String, Set<GreyCodePair>>();
    private Int2ObjectMap<Set<String>> fIdentifiersReverseMap = new Int2ObjectOpenHashMap();
    private Object2IntMap<String> fFilenamesMap = new Object2IntOpenHashMap();
    private Int2ObjectMap<String> fFileIndexToNameMap = new Int2ObjectOpenHashMap();
    private int fFileNamePhysical;
    private IProject fProject;
    private static final Map<String, String> physicalPathCache = new HashMap<String, String>();

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public abstract String getIndexerFileName();

    @Override
    public synchronized void startFile(String filePath, boolean clearIndexerEntries) {
        this.fFileNamePhysical = this.file2index(filePath, true);
        if (!clearIndexerEntries) {
            return;
        }
        Set words = (Set)this.fIdentifiersReverseMap.get(this.fFileNamePhysical);
        if (words == null || words.isEmpty()) {
            return;
        }
        for (String word : words) {
            Set<GreyCodePair> greyCodeFiles;
            Set<Integer> files = this.fIdentifiersMap.get(word);
            if (files != null) {
                files.remove(this.fFileNamePhysical);
                if (files.isEmpty()) {
                    this.fIdentifiersMap.remove(word);
                }
            }
            if ((greyCodeFiles = this.fIdentifiersMapInGreyCode.get(word)) == null) continue;
            Iterator<GreyCodePair> it = greyCodeFiles.iterator();
            while (it.hasNext()) {
                GreyCodePair pair = it.next();
                if (pair.getFileIndex() != this.fFileNamePhysical) continue;
                it.remove();
            }
            if (!greyCodeFiles.isEmpty()) continue;
            this.fIdentifiersMapInGreyCode.remove(word);
        }
    }

    @Override
    public final synchronized Collection<GreyCodePair> getHitsInGreyCode(String name) {
        return this.fIdentifiersMapInGreyCode.get(name);
    }

    public static void clearPhysicalPathCache() {
        physicalPathCache.clear();
    }

    private final int file2index(String filePath, boolean createIndex) {
        String physicalPath = physicalPathCache.get(filePath);
        if (physicalPath == null) {
            physicalPath = Utils.physicalPath(filePath, true);
            physicalPathCache.put(filePath, physicalPath);
        }
        if (this.fFilenamesMap.containsKey((Object)physicalPath)) {
            return this.fFilenamesMap.get((Object)physicalPath);
        }
        if (!createIndex) {
            return -1;
        }
        int size = this.fFilenamesMap.size();
        physicalPath = DVTStringUtil.intern(physicalPath);
        this.fFilenamesMap.put((Object)physicalPath, size);
        this.fFileIndexToNameMap.put(size, (Object)physicalPath);
        return size;
    }

    public synchronized void indexToken(String word, int line, int column) {
        Set<String> newWordList;
        Set wordList;
        Set<Integer> filesList = this.fIdentifiersMap.get(word);
        Set<Integer> newFilesList = OptimizedUtils.setAdd(filesList, this.fFileNamePhysical);
        String intern = DVTStringUtil.intern(word);
        if (newFilesList != filesList) {
            this.fIdentifiersMap.put(intern, newFilesList);
        }
        if ((wordList = (Set)this.fIdentifiersReverseMap.get(this.fFileNamePhysical)) != (newWordList = OptimizedUtils.setAdd(wordList, word))) {
            this.fIdentifiersReverseMap.put(this.fFileNamePhysical, newWordList);
        }
    }

    public synchronized void indexToken2(String word, int line, int column) {
        Set<String> newWordList;
        Set wordList;
        Set<GreyCodePair> filesList = this.fIdentifiersMapInGreyCode.get(word);
        Set<GreyCodePair> newFilesList = OptimizedUtils.setAdd(filesList, new GreyCodePair(this.fFileNamePhysical, column, line));
        if (newFilesList != filesList) {
            this.fIdentifiersMapInGreyCode.put(DVTStringUtil.intern(word), newFilesList);
        }
        if ((wordList = (Set)this.fIdentifiersReverseMap.get(this.fFileNamePhysical)) != (newWordList = OptimizedUtils.setAdd(wordList, word))) {
            this.fIdentifiersReverseMap.put(this.fFileNamePhysical, newWordList);
        }
    }

    @Override
    public void write(BuildConfigManagerCommon.PersistenceModeWrapper persistenceMode) throws Exception {
        this.write(persistenceMode, null);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void write(BuildConfigManagerCommon.PersistenceModeWrapper persistenceMode, IRfSingleLangProject rfProject) throws Exception {
        file = BuildConfigManager.getModelPersistenceLocation(this.fProject, this.getIndexerFileName(), false, persistenceMode);
        if (file == null) {
            return;
        }
        isPrecompileAuto = persistenceMode.libraryName != null;
        var5_5 = null;
        var6_7 = null;
        try {
            os0 = new BufferedOutputStream(new FileOutputStream(file));
            try {
                os1 = new BufferedOutputStream(new DeflaterOutputStream((OutputStream)os0, new Deflater(1)));
                try {
                    os2 = new ObjectOutputStream(os1);
                    try {
                        libraryInvocations = new HashSet<E>();
                        libraryParserPaths = new HashSet<E>();
                        libraryFileIndexes = new HashSet<Integer>();
                        filteredIdentifiersMap = this.fIdentifiersMap;
                        filteredFilenamesMap /* !! */  = this.fFilenamesMap;
                        filteredIdentifiersGrayCodeMap = this.fIdentifiersMapInGreyCode;
                        if (isPrecompileAuto) {
                            libraryInvocations.addAll(BuildConfigManager.getInvocations(this.fProject).stream().filter((Predicate<Invocation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$0(ro.amiq.dvt.buildconfig.BuildConfigManagerCommon$PersistenceModeWrapper ro.amiq.dvt.buildconfig.Invocation ), (Lro/amiq/dvt/buildconfig/Invocation;)Z)((BuildConfigManagerCommon.PersistenceModeWrapper)persistenceMode)).map((Function<Invocation, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$1(ro.amiq.dvt.buildconfig.Invocation ), (Lro/amiq/dvt/buildconfig/Invocation;)Ljava/lang/Integer;)()).collect(Collectors.toSet()));
                            libraryParserPaths.addAll(rfProject.getRfProjectContent().getInvocationIndicesByPath().entrySet().stream().filter((Predicate<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$2(java.util.Set java.util.Map$Entry ), (Ljava/util/Map$Entry;)Z)(libraryInvocations)).map((Function<Map.Entry, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$4(java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/lang/String;)()).collect(Collectors.toSet()));
                            idx = 0;
                            while (idx < this.fFileIndexToNameMap.size()) {
                                if (libraryParserPaths.contains(this.fFileIndexToNameMap.get(idx))) {
                                    libraryFileIndexes.add(idx);
                                }
                                ++idx;
                            }
                            for (Map.Entry<String, Set<Integer>> e : this.fIdentifiersMap.entrySet()) {
                                identifier = e.getKey();
                                identifierFileIndexes = e.getValue().stream().filter((Predicate<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$5(java.util.Set java.lang.Integer ), (Ljava/lang/Integer;)Z)(libraryFileIndexes)).collect(Collectors.toSet());
                                filteredIdentifiersMap.put(identifier, identifierFileIndexes);
                            }
                            filteredFilenamesMap /* !! */  = this.fFilenamesMap.entrySet().stream().filter((Predicate<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$6(java.util.Set java.util.Map$Entry ), (Ljava/util/Map$Entry;)Z)(libraryParserPaths)).collect(Collectors.toMap((Function<Map.Entry, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getKey(), (Ljava/util/Map$Entry;)Ljava/lang/String;)(), (Function<Map.Entry, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Ljava/util/Map$Entry;)Ljava/lang/Integer;)()));
                            filteredIdentifiersGrayCodeMap = this.fIdentifiersMapInGreyCode.entrySet().stream().filter((Predicate<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$9(java.util.Set java.util.Map$Entry ), (Ljava/util/Map$Entry;)Z)(libraryParserPaths)).collect(Collectors.toMap((Function<Map.Entry, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getKey(), (Ljava/util/Map$Entry;)Ljava/lang/String;)(), (Function<Map.Entry, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Ljava/util/Map$Entry;)Ljava/util/Set;)()));
                        }
                        sortedIdentifiersByIndexes = new HashMap<String, TreeSet<E>>();
                        for (Map.Entry<String, Set<Integer>> entry : filteredIdentifiersMap.entrySet()) {
                            sortedSet = new TreeSet<E>(entry.getValue());
                            sortedIdentifiersByIndexes.put(entry.getKey(), sortedSet);
                        }
                        filenameIndexesList = new ArrayList<Map.Entry<K, V>>(filteredFilenamesMap /* !! */ .entrySet());
                        filenameIndexesList.sort(Map.Entry.comparingByValue());
                        sortedFilenamesByIndexes = new LinkedHashMap<String, Integer>();
                        for (Map.Entry entry : filenameIndexesList) {
                            sortedFilenamesByIndexes.put((String)entry.getKey(), (Integer)entry.getValue());
                        }
                        os2.writeObject(sortedIdentifiersByIndexes);
                        os2.writeObject(sortedFilenamesByIndexes);
                        os2.writeObject(filteredIdentifiersGrayCodeMap);
                    }
                    finally {
                        if (os2 != null) {
                            os2.close();
                        }
                    }
                    ** if (os1 == null) goto lbl-1000
                }
                catch (Throwable var6_8) {
                    if (var5_5 == null) {
                        var5_5 = var6_8;
                    } else if (var5_5 != var6_8) {
                        var5_5.addSuppressed(var6_8);
                    }
                    if (os1 != null) {
                        os1.close();
                    }
                    throw var5_5;
                }
lbl-1000:
                // 1 sources

                {
                    os1.close();
                }
lbl-1000:
                // 2 sources

                {
                }
                ** if (os0 == null) goto lbl-1000
            }
            catch (Throwable var6_9) {
                if (var5_5 == null) {
                    var5_5 = var6_9;
                } else if (var5_5 != var6_9) {
                    var5_5.addSuppressed(var6_9);
                }
                if (os0 != null) {
                    os0.close();
                }
                throw var5_5;
            }
lbl-1000:
            // 1 sources

            {
                os0.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (Throwable var6_10) {
            if (var5_5 == null) {
                var5_5 = var6_10;
            } else if (var5_5 != var6_10) {
                var5_5.addSuppressed(var6_10);
            }
            throw var5_5;
        }
        if (persistenceMode.persistenceMode == BuildConfigManagerCommon.PersistenceMode.PRECOMPILED_DB_SAVE) {
            PrecompiledDBUtils.logMD5(this.fProject, this.getIndexerFileName(), persistenceMode);
        }
    }

    @Override
    public void read(BuildConfigManagerCommon.PersistenceModeWrapper persistenceMode) throws Exception {
        String file = BuildConfigManager.getModelPersistenceLocation(this.fProject, this.getIndexerFileName(), true, persistenceMode);
        if (file == null) {
            return;
        }
        try {
            this.internalRead(true, file);
        }
        catch (IOException e) {
            if ("Stream is corrupted".equals(e.getMessage())) {
                this.internalRead(false, file);
            }
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void internalRead(boolean lz4enabled, String file) throws Exception {
        var3_3 = null;
        var4_5 = null;
        try {
            is0 = new BufferedInputStream(new FileInputStream(file));
            try {
                is1 = lz4enabled != false ? new BufferedInputStream(new InflaterInputStream(is0)) : is0;
                try {
                    is2 = new ObjectInputStream(is1);
                    try {
                        if (this.fIdentifiersMap == null) {
                            this.fIdentifiersMap = new HashMap<String, Set<Integer>>();
                        }
                        if (this.fIdentifiersReverseMap == null) {
                            this.fIdentifiersReverseMap = new Int2ObjectOpenHashMap();
                        }
                        if (this.fFilenamesMap == null) {
                            this.fFilenamesMap = new Object2IntOpenHashMap();
                        }
                        if (this.fIdentifiersMapInGreyCode == null) {
                            this.fIdentifiersMapInGreyCode = new HashMap<String, Set<GreyCodePair>>();
                        }
                        if (this.fFileIndexToNameMap == null) {
                            this.fFileIndexToNameMap = new Int2ObjectOpenHashMap();
                        }
                        identifiersMap = (Map)is2.readObject();
                        filenamesMap = (LinkedHashMap)is2.readObject();
                        identifiersMapInGreyCode = (Map)is2.readObject();
                        initialSize = this.fFilenamesMap.size();
                        duplicatedFilesIndex = new HashSet<Integer>();
                        isMergingMode = false;
                        for (Map.Entry<K, V> entry : filenamesMap.entrySet()) {
                            if (this.fFilenamesMap.containsKey(entry.getKey())) {
                                duplicatedFilesIndex.add((Integer)entry.getValue());
                                if (!((String)entry.getKey()).contains("__vlog__")) continue;
                                isMergingMode = true;
                                continue;
                            }
                            fileIndex = initialSize + (Integer)entry.getValue() - duplicatedFilesIndex.size();
                            if (fileIndex != 0 && ((String)entry.getKey()).contains("__vlog__")) {
                                duplicatedFilesIndex.add(0);
                                isMergingMode = true;
                                continue;
                            }
                            this.fFilenamesMap.put((Object)((String)entry.getKey()), fileIndex);
                            this.fFileIndexToNameMap.put(fileIndex, (Object)((String)entry.getKey()));
                        }
                        for (Map.Entry<K, V> entry : identifiersMap.entrySet()) {
                            identifier = (String)entry.getKey();
                            fileIndexSet = (Set)entry.getValue();
                            numberOfCurentDuplicates = isMergingMode != false ? 1 : 0;
                            this.fIdentifiersMap.putIfAbsent(identifier, new HashSet<E>());
                            for (Integer readFileIndex : fileIndexSet) {
                                if (readFileIndex != 0 && duplicatedFilesIndex.contains(readFileIndex)) {
                                    ++numberOfCurentDuplicates;
                                    continue;
                                }
                                fileIndex = initialSize + readFileIndex - numberOfCurentDuplicates;
                                this.fIdentifiersMap.get(identifier).add(fileIndex);
                                this.fIdentifiersReverseMap.putIfAbsent(fileIndex, new HashSet<E>());
                                ((Set)this.fIdentifiersReverseMap.get(fileIndex)).add(identifier);
                            }
                        }
                        for (Map.Entry<K, V> entry : identifiersMapInGreyCode.entrySet()) {
                            this.fIdentifiersMapInGreyCode.putIfAbsent((String)entry.getKey(), new HashSet<E>());
                            numberOfCurentDuplicates = isMergingMode != false ? 1 : 0;
                            for (GreyCodePair greyCodePair : (Set)entry.getValue()) {
                                if (greyCodePair.getFileIndex() != 0 && duplicatedFilesIndex.contains(greyCodePair.getFileIndex())) {
                                    ++numberOfCurentDuplicates;
                                    continue;
                                }
                                greyCodePair.setFileIndex(initialSize + greyCodePair.getFileIndex() - numberOfCurentDuplicates);
                                this.fIdentifiersMapInGreyCode.get(entry.getKey()).add(greyCodePair);
                            }
                        }
                    }
                    finally {
                        if (is2 != null) {
                            is2.close();
                        }
                    }
                    ** if (is1 == null) goto lbl-1000
                }
                catch (Throwable var4_6) {
                    if (var3_3 == null) {
                        var3_3 = var4_6;
                    } else if (var3_3 != var4_6) {
                        var3_3.addSuppressed(var4_6);
                    }
                    if (is1 != null) {
                        is1.close();
                    }
                    throw var3_3;
                }
lbl-1000:
                // 1 sources

                {
                    is1.close();
                }
lbl-1000:
                // 2 sources

                {
                }
                ** if (is0 == null) goto lbl-1000
            }
            catch (Throwable var4_7) {
                if (var3_3 == null) {
                    var3_3 = var4_7;
                } else if (var3_3 != var4_7) {
                    var3_3.addSuppressed(var4_7);
                }
                if (is0 != null) {
                    is0.close();
                }
                throw var3_3;
            }
lbl-1000:
            // 1 sources

            {
                is0.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (Throwable var4_8) {
            if (var3_3 == null) {
                var3_3 = var4_8;
            } else if (var3_3 != var4_8) {
                var3_3.addSuppressed(var4_8);
            }
            throw var3_3;
        }
    }

    @Override
    public synchronized boolean hasHits(String filePath, Matcher matcher) {
        int physicalPath = this.file2index(filePath, false);
        if (physicalPath < 0) {
            return false;
        }
        for (String text : this.fIdentifiersMap.keySet()) {
            Set<Integer> candidates = this.fIdentifiersMap.get(text);
            if (!candidates.contains(physicalPath)) continue;
            matcher.reset(text);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean hasHits(String filePath, String[] names) {
        int physicalPath = this.file2index(filePath, false);
        if (physicalPath < 0) {
            return false;
        }
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String nameString = stringArray[n2];
            Set<Integer> candidates = this.fIdentifiersMap.get(nameString);
            if (candidates != null && !candidates.isEmpty() && candidates.contains(physicalPath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public synchronized void clean() {
        this.fIdentifiersMap.clear();
        this.fIdentifiersReverseMap.clear();
        this.fFilenamesMap.clear();
        this.fIdentifiersMapInGreyCode.clear();
        this.fFileIndexToNameMap.clear();
    }

    @Override
    public final synchronized String getFile(int fileIndex) {
        return (String)this.fFileIndexToNameMap.get(fileIndex);
    }

    private static /* synthetic */ boolean lambda$0(BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper, Invocation inv) {
        return inv.getLibName().equals(persistenceModeWrapper.libraryName);
    }

    private static /* synthetic */ Integer lambda$1(Invocation inv) {
        return inv.getIndex();
    }

    private static /* synthetic */ boolean lambda$2(Set set, Map.Entry pathsInvocationIndices) {
        return ((Set)pathsInvocationIndices.getValue()).stream().anyMatch(in -> set.contains(in));
    }

    private static /* synthetic */ String lambda$4(Map.Entry p) {
        return ((ParserPath)p.getKey()).toString();
    }

    private static /* synthetic */ boolean lambda$5(Set set, Integer i) {
        return set.contains(i);
    }

    private static /* synthetic */ boolean lambda$6(Set set, Map.Entry fileInfo) {
        return set.contains(fileInfo.getKey());
    }

    private static /* synthetic */ boolean lambda$9(Set set, Map.Entry fileInfo) {
        return set.contains(fileInfo.getKey());
    }
}

