/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.indexer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.indexer.AbstractIdentifierIndexer;
import ro.amiq.dvt.model.indexer.GreyCodePair;
import ro.amiq.dvt.model.indexer.IIdentifierIndexerExtension;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.Utils;

public class IdentifierIndexerManager {
    private static final Object fSyncInstance = new Object();
    private static volatile IdentifierIndexerManager fInstance;
    private final Map<String, Map<IProject, AbstractIdentifierIndexer>> fProjectIndexerMap = new HashMap<String, Map<IProject, AbstractIdentifierIndexer>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final IdentifierIndexerManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new IdentifierIndexerManager();
            }
        }
        return fInstance;
    }

    public final IIdentifierIndexerExtension getProjectIndexer(Class<? extends AbstractIdentifierIndexer> indexerClass, IProject project) {
        AbstractIdentifierIndexer indexer;
        Map<IProject, AbstractIdentifierIndexer> indexerProjectMap = this.fProjectIndexerMap.get(indexerClass.getCanonicalName());
        if (indexerProjectMap == null) {
            indexerProjectMap = new HashMap<IProject, AbstractIdentifierIndexer>();
            this.fProjectIndexerMap.put(indexerClass.getCanonicalName(), indexerProjectMap);
        }
        if ((indexer = indexerProjectMap.get(project)) == null) {
            try {
                indexer = indexerClass.newInstance();
                indexer.setProject(project);
                indexerProjectMap.put(project, indexer);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return indexer;
    }

    public final boolean hasHits(Class<? extends AbstractIdentifierIndexer> indexerClass, IFile file, String[] names, Matcher matcher, boolean isRegexp) {
        if (file == null) {
            return false;
        }
        IIdentifierIndexerExtension indexer = this.getProjectIndexer(indexerClass, file.getProject());
        if (indexer == null) {
            return false;
        }
        if (isRegexp) {
            return indexer.hasHits(Utils.physicalPath(file.getLocation()), matcher);
        }
        return indexer.hasHits(Utils.physicalPath(file.getLocation()), names);
    }

    public final boolean hasHits(Class<? extends AbstractIdentifierIndexer> indexerClass, ParserPath parserPath, IProject project, String[] names, Matcher matcher, boolean isRegexp) {
        if (parserPath == null) {
            return false;
        }
        IIdentifierIndexerExtension indexer = this.getProjectIndexer(indexerClass, project);
        if (indexer == null) {
            return false;
        }
        if (isRegexp) {
            return indexer.hasHits(parserPath.getCanonicalPath(), matcher);
        }
        return indexer.hasHits(parserPath.getCanonicalPath(), names);
    }

    public final Collection<GreyCodePair> getHitsInGreyCode(IProject project, Class<? extends AbstractIdentifierIndexer> indexerClass, String name) {
        IIdentifierIndexerExtension indexer = this.getProjectIndexer(indexerClass, project);
        if (indexer == null) {
            return null;
        }
        return indexer.getHitsInGreyCode(name);
    }

    public String getFile(IProject project, Class<? extends AbstractIdentifierIndexer> indexerClass, int fileIndex) {
        IIdentifierIndexerExtension indexer = this.getProjectIndexer(indexerClass, project);
        if (indexer == null) {
            return null;
        }
        return indexer.getFile(fileIndex);
    }
}

