/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.builders.DVTPrecompiledDatabaseRebuildConsole;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversManager;
import ro.amiq.dvt.model.indexer.AbstractIdentifierIndexer;
import ro.amiq.dvt.model.indexer.IdentifierIndexerManager;
import ro.amiq.dvt.model.persistence.IPersistenceInputRunnable;
import ro.amiq.dvt.model.persistence.IPersistenceOutputRunnable;
import ro.amiq.dvt.model.persistence.PersistenceBenchmark;
import ro.amiq.dvt.model.persistence.PersistenceCancelException;
import ro.amiq.dvt.model.persistence.PersistenceInputStream;
import ro.amiq.dvt.model.persistence.PersistenceOutputStream;
import ro.amiq.dvt.model.persistence.PersistenceUtils;
import ro.amiq.dvt.model.persistence.VersionChangedException;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.reflection.IDVTRfManager;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfCompiledFiles;
import ro.amiq.dvt.model.reflection.RfNamedElementVisitorException;
import ro.amiq.dvt.model.reflection.util.IdleHandler;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTProcessRunner;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.PrecompiledRebuildConsolePipe;

public abstract class PersistenceBase {
    private static final int UNKN_STATUS = 0;
    public static final int OK_STATUS = 1;
    public static final int DIRTY_STATUS = 2;
    private static final long SYNC_CANCEL_SAVE_TIMEOUT = 5000L;
    public static final long THREAD_YIELD_DELTA_READ = 300L;
    public static final long THREAD_YIELD_DELTA_WRITE = 100L;
    private Thread writeThread;
    private Integer dirtyFlag;
    private IProgressMonitor globalRestoreMonitor;
    private IProgressMonitor saveMonitor;
    private IProject project;
    private Map<BuildConfigManagerCommon.PersistenceModeWrapper, PersistenceBenchmark> benchmarks = new ConcurrentHashMap<BuildConfigManagerCommon.PersistenceModeWrapper, PersistenceBenchmark>();
    private long fNextThreadYieldAllowedTimestamp;

    protected PersistenceBase(IProject project) {
        this.project = project;
    }

    public Map<BuildConfigManagerCommon.PersistenceModeWrapper, PersistenceBenchmark> getBenchmarks() {
        return this.benchmarks;
    }

    public PersistenceBenchmark getBenchmark(BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) {
        return this.benchmarks.get(persistenceModeWrapper);
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean isRestoreCanceled() {
        return this.globalRestoreMonitor != null && this.globalRestoreMonitor.isCanceled();
    }

    public boolean isSaveCanceled() {
        return this.saveMonitor != null && this.saveMonitor.isCanceled();
    }

    public void cancelSave() {
        if (this.saveMonitor == null) {
            this.saveMonitor = new NullProgressMonitor();
        }
        this.saveMonitor.setCanceled(true);
    }

    public void syncCancelSave() {
        this.cancelSave();
        long timeoutTime = 5000L + System.currentTimeMillis();
        while (System.currentTimeMillis() < timeoutTime) {
            if (this.writeThread == null) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.writeThread != null) {
            DVTLogger.INSTANCE.logError("Timed out while waiting for dictionary save operation to end after cancelling.");
        }
    }

    public void setDirty() {
        this.dirtyFlag = 2;
    }

    protected void logDebug(String message, BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) {
        DVTLogger.INSTANCE.logDebug("[PERSISTENCE " + (this.project != null ? this.project.getName() : "") + PersistenceBenchmark.getTagId(persistenceModeWrapper) + "] " + message);
    }

    private void writeRfProject(final IRfSingleLangProject rfProject, final BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) {
        try {
            this.run(this.getRfProjectFileName(), new IPersistenceOutputRunnable(){

                @Override
                public void run(PersistenceOutputStream stream) throws Exception {
                    PersistenceBase.this.benchmarks.get(persistenceModeWrapper).start("save");
                    stream.writeBoolean(true);
                    PersistenceBase.this.fastSerialize(rfProject, stream);
                    PersistenceBase.this.benchmarks.get(persistenceModeWrapper).stop("save");
                    PersistenceBase.this.logDebug("Wrote RfProject to " + stream.getFile() + " : " + PersistenceBase.this.benchmarks.get(persistenceModeWrapper).get("save"), persistenceModeWrapper);
                }
            }, persistenceModeWrapper);
        }
        catch (PersistenceCancelException persistenceCancelException) {
            this.logDebug("Save cancelled by user", persistenceModeWrapper);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("Write RfProject for " + rfProject.getName(), (Throwable)e);
        }
    }

    public final void save(final IRfSingleLangProject rfProject, boolean incremental, boolean isAsyncronous, boolean reportprogress, final BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) {
        this.benchmarks.computeIfAbsent(persistenceModeWrapper, p -> new PersistenceBenchmark(this.project, persistenceModeWrapper));
        this.benchmarks.get(persistenceModeWrapper).setExtended(BuildConfigManager.isBenchmarkSerdes(this.project));
        this.benchmarks.get(persistenceModeWrapper).resetSerdesMetrics();
        if (BuildConfigManager.isDisableIncrementalSave(this.project)) {
            if (incremental) {
                IdleHandler.addIdleListener(rfProject.getIdleListener());
                this.writeDirtyFlag(2, persistenceModeWrapper);
                return;
            }
        } else {
            IdleHandler.removeIdleListener(rfProject.getIdleListener());
        }
        try {
            if (this.writeThread != null && this.writeThread.isAlive()) {
                this.writeThread.interrupt();
                long timeout = 5000L + System.currentTimeMillis();
                while (this.writeThread != null) {
                    if (System.currentTimeMillis() > timeout) {
                        this.logDebug("Timed out while waiting for pending write to cancel.", persistenceModeWrapper);
                        return;
                    }
                    Thread.sleep(100L);
                }
                this.dirtyFlag = 2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("Save dictionary", (Throwable)e);
        }
        if (this.dirtyFlag == null || this.dirtyFlag != 1) {
            this.writeThread = new Thread(){

                @Override
                public void run() {
                    try {
                        try {
                            PersistenceBase.this.saveMonitor = new NullProgressMonitor();
                            PersistenceBase.this.write(rfProject, persistenceModeWrapper);
                            PersistenceBase.this.logDebug("Write done", persistenceModeWrapper);
                            ObjectionManager.getInstance().clear(Objection.SERIALIZE);
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            PersistenceBase.this.writeThread = null;
                        }
                    }
                    finally {
                        PersistenceBase.this.writeThread = null;
                    }
                }
            };
            if (reportprogress) {
                PersistenceUtils.reportSavingProject(this.project);
            }
            if (persistenceModeWrapper.persistenceMode == BuildConfigManagerCommon.PersistenceMode.PRECOMPILED_DB_SAVE || !isAsyncronous) {
                this.writeThread.run();
            } else {
                this.writeThread.start();
            }
            this.dirtyFlag = 1;
        }
    }

    public void write(IRfSingleLangProject rfProject, BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) {
        this.writeCompiledFiles(rfProject.getRfCompiledFiles(), persistenceModeWrapper);
        this.writeIdentifierIndexer(rfProject, persistenceModeWrapper);
        this.writeRfProject(rfProject, persistenceModeWrapper);
        this.writeDirtyFlag(1, persistenceModeWrapper);
    }

    protected void readIdentifierIndexer(BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) {
        try {
            Class<? extends AbstractIdentifierIndexer> identifierIndexerClass = this.getIdentifierIndexerClass();
            if (identifierIndexerClass == null) {
                return;
            }
            IdentifierIndexerManager.getInstance().getProjectIndexer(identifierIndexerClass, this.getProject()).read(persistenceModeWrapper);
        }
        catch (Exception e) {
            this.logDebug("Read IdentifierIndexer : " + e.getMessage(), persistenceModeWrapper);
        }
    }

    public void writeCompiledFiles(final RfCompiledFiles rfCompiledFiles, BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) {
        try {
            this.run(this.getCompiledFilesFileName(), new IPersistenceOutputRunnable(){

                @Override
                public void run(PersistenceOutputStream stream) throws Exception {
                    stream.writeObject(rfCompiledFiles);
                }
            }, persistenceModeWrapper);
        }
        catch (Exception e) {
            this.logDebug("Write RfCompiledFiles for : " + e.getMessage(), persistenceModeWrapper);
        }
    }

    private void writeIdentifierIndexer(IRfSingleLangProject rfProject, BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) {
        try {
            Class<? extends AbstractIdentifierIndexer> identifierIndexerClass = this.getIdentifierIndexerClass();
            if (identifierIndexerClass == null) {
                return;
            }
            IdentifierIndexerManager.getInstance().getProjectIndexer(identifierIndexerClass, this.getProject()).write(persistenceModeWrapper, rfProject);
        }
        catch (Exception e) {
            this.logDebug("Write IdentifierIndexer for : " + e.getMessage(), persistenceModeWrapper);
        }
    }

    protected final IRfSingleLangProject readRfProject(IProgressMonitor monitor, final BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) {
        try {
            return this.run(this.getRfProjectFileName(), new IPersistenceInputRunnable<IRfSingleLangProject>(){

                @Override
                public IRfSingleLangProject run(PersistenceInputStream stream) throws Exception {
                    stream.readBoolean();
                    PersistenceBase.this.logDebug("Reading RfProject from " + stream.getFile(), persistenceModeWrapper);
                    IRfSingleLangProject result = PersistenceBase.this.fastDeSerialize(stream);
                    return result;
                }
            }, persistenceModeWrapper, monitor);
        }
        catch (Throwable e) {
            if (e instanceof PrecompiledDbLoadFailException) {
                this.logDebug("Failed to read RfProject (" + e.getClass().getName() + " : " + e.getMessage() + ")", persistenceModeWrapper);
                PrecompiledDBUtils.regeneratePrecompiledLibraries(this.project, "Precompiled database is corrupted", "Unable to load the precompiled database because it is corrupted.\nDo you want to rebuild the precompiled database?\n\nThe existing precompiled database will be deleted.", persistenceModeWrapper, null);
                throw new PrecompiledDbLoadFailException("Missing precompiled database.");
            }
            if (e instanceof RfNamedElementVisitorException) {
                e = e.getCause();
            }
            IProject project = this.getProject();
            if (e instanceof InvalidClassException || e instanceof InvalidObjectException || e instanceof ClassNotFoundException || e instanceof ClassCastException || e instanceof OptionalDataException || e instanceof EOFException || e instanceof VersionChangedException || e instanceof StreamCorruptedException || e instanceof ZipException) {
                if (persistenceModeWrapper.persistenceMode == BuildConfigManagerCommon.PersistenceMode.PRECOMPILED_DB_LOAD) {
                    this.logDebug("Failed to read RfProject (" + e.getClass().getName() + " : " + e.getMessage() + ")", persistenceModeWrapper);
                    PrecompiledDBUtils.regeneratePrecompiledLibraries(project, "Precompiled database is corrupted", "Unable to load the precompiled database because it is corrupted.\nDo you want to rebuild the precompiled database?\n\nThe existing precompiled database will be deleted.", persistenceModeWrapper, null);
                    throw new PrecompiledDbLoadFailException("Fail to load precompiled database because DVT version changed.");
                }
                PersistenceUtils.openRebuildDialog(project);
            } else if (e instanceof PersistenceCancelException || e instanceof FileNotFoundException) {
                this.logDebug("Failed to read RfProject (" + e.getMessage() + ")", persistenceModeWrapper);
                if (persistenceModeWrapper.persistenceMode == BuildConfigManagerCommon.PersistenceMode.PRECOMPILED_DB_LOAD && e instanceof PersistenceCancelException) {
                    throw (PersistenceCancelException)e;
                }
            } else {
                DVTLogger.INSTANCE.logError("Failed to read RfProject for " + project.getName(), e);
            }
            return null;
        }
    }

    public final boolean preRestore(IRfSingleLangProject rfProject, BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) {
        RfCompiledFiles compiledFiles;
        block3: {
            try {
                compiledFiles = this.readCompiledFiles(persistenceModeWrapper);
                if (compiledFiles != null) break block3;
                return false;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        rfProject.setRfCompiledFiles(compiledFiles);
        return true;
    }

    public final RfCompiledFiles readCompiledFiles(BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) {
        try {
            return this.run(this.getCompiledFilesFileName(), new IPersistenceInputRunnable<RfCompiledFiles>(){

                @Override
                public RfCompiledFiles run(PersistenceInputStream stream) throws Exception {
                    return (RfCompiledFiles)stream.readObject();
                }
            }, persistenceModeWrapper);
        }
        catch (Exception e) {
            this.logDebug("Read RfCompiledFiles : " + e.getMessage(), persistenceModeWrapper);
            return null;
        }
    }

    public final void setGlobalRestoreMonitor(IProgressMonitor monitor) {
        this.globalRestoreMonitor = monitor;
    }

    /*
     * Unable to fully structure code
     */
    public final void restore(IRfSingleLangProject rfProject, IProgressMonitor monitor, IDVTRfManager rfManager, BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) {
        block18: {
            block17: {
                block16: {
                    this.benchmarks.computeIfAbsent(persistenceModeWrapper, (Function<BuildConfigManagerCommon.PersistenceModeWrapper, PersistenceBenchmark>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$1(ro.amiq.dvt.buildconfig.BuildConfigManagerCommon$PersistenceModeWrapper ro.amiq.dvt.buildconfig.BuildConfigManagerCommon$PersistenceModeWrapper ), (Lro/amiq/dvt/buildconfig/BuildConfigManagerCommon$PersistenceModeWrapper;)Lro/amiq/dvt/model/persistence/PersistenceBenchmark;)((PersistenceBase)this, (BuildConfigManagerCommon.PersistenceModeWrapper)persistenceModeWrapper));
                    benchmark = this.benchmarks.get(persistenceModeWrapper);
                    benchmark.setExtended(BuildConfigManager.isBenchmarkSerdes(this.project));
                    benchmark.resetSerdesMetrics();
                    benchmark.start("restore");
                    if (persistenceModeWrapper.persistenceMode == BuildConfigManagerCommon.PersistenceMode.REGULAR) {
                        this.setGlobalRestoreMonitor(monitor);
                    }
                    if (!this.isRestoreCanceled()) break block16;
                    if (persistenceModeWrapper.persistenceMode == BuildConfigManagerCommon.PersistenceMode.REGULAR) {
                        this.globalRestoreMonitor = null;
                    }
                    return;
                }
                project = rfProject.getProject();
                if (project.exists() && project.isOpen() && project.isAccessible()) break block17;
                if (persistenceModeWrapper.persistenceMode == BuildConfigManagerCommon.PersistenceMode.REGULAR) {
                    this.globalRestoreMonitor = null;
                }
                return;
            }
            DVTProblemManager.getInstance().clearWaivers(project);
            CompileWaiversManager.INSTANCE.loadWaivers(project);
            this.dirtyFlag = this.getDirtyStatus(persistenceModeWrapper);
            PersistenceUtils.updateDeprecatedProject(project);
            if (this.dirtyFlag != 2 || !PersistenceUtils.openDirtyDialog(project)) break block18;
            DVTBuildUtils.asyncExecInternalBuilder(project);
            if (persistenceModeWrapper.persistenceMode == BuildConfigManagerCommon.PersistenceMode.REGULAR) {
                this.globalRestoreMonitor = null;
            }
            return;
        }
        try {
            try {
                benchmark.start("readIdentifierIndexer");
                this.readIdentifierIndexer(persistenceModeWrapper);
                benchmark.stop("readIdentifierIndexer");
                this.logDebug("Read IdentifierIndexer : " + benchmark.get("readIdentifierIndexer"), persistenceModeWrapper);
                benchmark.start("readRfProject");
                rfMixedLangProject = rfProject.getMixedLangProjectParent();
                restoredRfProject = this.readRfProject(monitor, persistenceModeWrapper);
                benchmark.stop("readRfProject");
                this.logDebug("Read RfProject : " + benchmark.get("readRfProject"), persistenceModeWrapper);
                if (restoredRfProject != null) {
                    restoredRfProject.setMixedLangProjectParent(rfMixedLangProject);
                    rfProjectContent = restoredRfProject.getRfProjectContent();
                    rfProjectContent.setEnclosingScope(rfProject);
                    rfProject.setRfProjectContent(rfProjectContent);
                }
                benchmark.start("initRfProject");
                rfProject.init(project, rfManager, persistenceModeWrapper.persistenceMode == BuildConfigManagerCommon.PersistenceMode.REGULAR);
                benchmark.stop("initRfProject");
                ObjectionManager.getInstance().clear(Objection.POST_RESTORE);
            }
            catch (PrecompiledDbLoadFailException | PersistenceCancelException e) {
                throw e;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                if (persistenceModeWrapper.persistenceMode != BuildConfigManagerCommon.PersistenceMode.REGULAR) ** GOTO lbl68
                this.globalRestoreMonitor = null;
            }
        }
        catch (Throwable var10_12) {
            if (persistenceModeWrapper.persistenceMode == BuildConfigManagerCommon.PersistenceMode.REGULAR) {
                this.globalRestoreMonitor = null;
            }
            throw var10_12;
        }
        if (persistenceModeWrapper.persistenceMode == BuildConfigManagerCommon.PersistenceMode.REGULAR) {
            this.globalRestoreMonitor = null;
        }
lbl68:
        // 5 sources

        if (rfProject != null && rfProject.getProject() != null) {
            benchmark.stop("restore");
            this.logDebug("Total read time for '" + rfProject.getProject().getName() + "' = " + benchmark.get("restore"), persistenceModeWrapper);
        }
        benchmark.printSerdesMetrics();
    }

    public final boolean isWriteDone() {
        try {
            return this.writeThread == null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return true;
        }
    }

    protected final void writeDirtyFlag(int dirtyStatus, BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) {
        try {
            this.dirtyFlag = dirtyStatus;
            String file = BuildConfigManager.getModelPersistenceLocation(this.project, this.getDirtyFileName(), false, persistenceModeWrapper);
            if (file == null) {
                return;
            }
            DVTFileUtils.getInstance().writeStringToFile(new File(file), dirtyStatus == 2 ? "true" : "false", false);
            if (persistenceModeWrapper.persistenceMode == BuildConfigManagerCommon.PersistenceMode.PRECOMPILED_DB_SAVE) {
                PrecompiledDBUtils.logMD5(this.project, this.getDirtyFileName(), persistenceModeWrapper);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("RfProject.writeDirtyFlag()", (Throwable)e);
        }
    }

    protected final int getDirtyStatus(BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) {
        int dirtyStatus = 0;
        try {
            String file = BuildConfigManager.getModelPersistenceLocation(this.project, this.getDirtyFileName(), true, persistenceModeWrapper);
            String isDirtyText = DVTFileUtils.getInstance().readFileContent(new File(file));
            dirtyStatus = "false".equals(isDirtyText) ? 1 : ("true".equals(isDirtyText) ? 2 : 0);
        }
        catch (Exception exception) {}
        return dirtyStatus;
    }

    protected <T> T run(String dbName, IPersistenceInputRunnable<T> code, BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) throws Exception {
        return this.run(dbName, code, persistenceModeWrapper, this.globalRestoreMonitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T run(String dbName, IPersistenceInputRunnable<T> code, BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper, IProgressMonitor monitor) throws Exception {
        T result = null;
        String file = BuildConfigManager.getModelPersistenceLocation(this.project, dbName, true, persistenceModeWrapper);
        if (file == null) {
            return null;
        }
        if (persistenceModeWrapper.persistenceMode == BuildConfigManagerCommon.PersistenceMode.PRECOMPILED_DB_LOAD && this.getRfProjectFileName().equals(dbName) && !new File(file).canRead()) {
            throw new PrecompiledDbLoadFailException("Missing precompiled database.");
        }
        Throwable throwable = null;
        Object var8_9 = null;
        try {
            BufferedInputStream is0 = new BufferedInputStream(new FileInputStream(file));
            try {
                block20: {
                    BufferedInputStream is1 = new BufferedInputStream(new InflaterInputStream(is0));
                    try {
                        try (PersistenceInputStream is2 = new PersistenceInputStream(file, is1, this, persistenceModeWrapper, monitor);){
                            result = code.run(is2);
                        }
                        if (is1 == null) break block20;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (is1 == null) throw throwable;
                        ((InputStream)is1).close();
                        throw throwable;
                    }
                    ((InputStream)is1).close();
                }
                if (is0 == null) return result;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (is0 == null) throw throwable;
                ((InputStream)is0).close();
                throw throwable;
            }
            ((InputStream)is0).close();
            return result;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void run(String dbName, IPersistenceOutputRunnable code, BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) throws Exception {
        block20: {
            String file = BuildConfigManager.getModelPersistenceLocation(this.project, dbName, false, persistenceModeWrapper);
            if (file == null) {
                return;
            }
            Throwable throwable = null;
            Object var6_7 = null;
            try {
                BufferedOutputStream os1 = new BufferedOutputStream(new FileOutputStream(file));
                try {
                    block19: {
                        BufferedOutputStream os3 = new BufferedOutputStream(new DeflaterOutputStream((OutputStream)os1, new Deflater(1)));
                        try {
                            try (PersistenceOutputStream os4 = new PersistenceOutputStream(file, os3, this, persistenceModeWrapper);){
                                code.run(os4);
                            }
                            if (os3 == null) break block19;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (os3 == null) throw throwable;
                            ((OutputStream)os3).close();
                            throw throwable;
                        }
                        ((OutputStream)os3).close();
                    }
                    if (os1 == null) break block20;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (os1 == null) throw throwable;
                    ((OutputStream)os1).close();
                    throw throwable;
                }
                ((OutputStream)os1).close();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        if (persistenceModeWrapper.persistenceMode != BuildConfigManagerCommon.PersistenceMode.PRECOMPILED_DB_SAVE) return;
        PrecompiledDBUtils.logMD5(this.project, dbName, persistenceModeWrapper);
    }

    public void threadYield(long delta) {
        if (delta == 0L) {
            Thread.yield();
            return;
        }
        if (System.currentTimeMillis() < this.fNextThreadYieldAllowedTimestamp) {
            return;
        }
        Thread.yield();
        this.fNextThreadYieldAllowedTimestamp = System.currentTimeMillis() + delta;
    }

    protected abstract Class<? extends AbstractIdentifierIndexer> getIdentifierIndexerClass();

    protected abstract void fastSerialize(IRfSingleLangProject var1, PersistenceOutputStream var2) throws Exception;

    protected abstract IRfSingleLangProject fastDeSerialize(PersistenceInputStream var1) throws Exception;

    protected abstract String getRfProjectFileName();

    protected abstract String getCompiledFilesFileName();

    protected abstract String getDirtyFileName();

    protected abstract Class<?> resolveClass(ObjectStreamClass var1);

    public static boolean precompileDb(IProject project, Invocation invocation, IProgressMonitor monitor, boolean deletePrecompiledDbDirectory) {
        String buildCmd = BuildConfigManager.getPrecompiledDbBuildCmd(project, invocation);
        if (buildCmd == null || buildCmd.isEmpty()) {
            return false;
        }
        if (deletePrecompiledDbDirectory) {
            PrecompiledDBUtils.deletePrecompiledDatabaseDirectory(project, BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbManualLoad(invocation));
        }
        DVTBuildConsole buildConsole = DVTBuildConsoleRegistry.getConsole(project);
        DVTPrecompiledDatabaseRebuildConsole rebuildConsole = buildConsole.createPrecompiledRebuildConsole(invocation);
        rebuildConsole.clearConsole();
        rebuildConsole.activate();
        try {
            rebuildConsole.printSection("---------------------------------- Build Precompiled Database Start ----------------------------------");
            DVTProcessRunner processRunner = new DVTProcessRunner(DVTStringUtil.split(DVTStringUtil.MULTIPLE_WS, buildCmd));
            processRunner.setWorkingDir(project.getLocation().toFile());
            PrecompiledRebuildConsolePipe consolePipe = new PrecompiledRebuildConsolePipe(rebuildConsole);
            processRunner.pipeStdOutTo(consolePipe);
            processRunner.pipeStdErrTo(consolePipe);
            processRunner.run(monitor);
            rebuildConsole.printSection("----------------------------------- Build Precompiled Database End -----------------------------------");
            ((OutputStream)consolePipe).close();
        }
        catch (Exception e) {
            buildConsole.print("*** Error: " + e.getMessage());
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    private /* synthetic */ PersistenceBenchmark lambda$1(BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper, BuildConfigManagerCommon.PersistenceModeWrapper p) {
        return new PersistenceBenchmark(this.project, persistenceModeWrapper);
    }

    public static class PrecompiledDbLoadFailException
    extends BuildCancelException {
        private static final long serialVersionUID = 1L;

        public PrecompiledDbLoadFailException(String message) {
            super(message);
        }
    }

    public static class PrecompiledDirectoryFailedToCreateException
    extends BuildCancelException {
        private static final long serialVersionUID = 1L;

        public PrecompiledDirectoryFailedToCreateException(String message) {
            super(message);
        }
    }
}

