/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.persistence;

import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.utils.benchmark.Counter;
import ro.amiq.dvt.utils.benchmark.StopWatch;

public class PersistenceBenchmark {
    public static final String TAG_PATTERN = "[PERSISTENCE%s] ";
    private String tag;
    private boolean fExtendedBenchmark;

    public PersistenceBenchmark(IProject project, BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) {
        this.fExtendedBenchmark = BuildConfigManager.isBenchmarkSerdes(project);
        this.tag = String.format(TAG_PATTERN, PersistenceBenchmark.getTagId(persistenceModeWrapper));
    }

    public static final String getTagId(BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) {
        if (persistenceModeWrapper.persistenceMode == BuildConfigManagerCommon.PersistenceMode.REGULAR) {
            return "";
        }
        if (persistenceModeWrapper.invocation != null) {
            return " - invocation " + String.valueOf(persistenceModeWrapper.invocation.getState().invocationNumber);
        }
        if (persistenceModeWrapper.libraryName != null) {
            return " - " + persistenceModeWrapper.libraryName;
        }
        return "";
    }

    public void setExtended(boolean extended) {
        this.fExtendedBenchmark = extended;
    }

    public void readStart(Object object) {
        if (!this.fExtendedBenchmark) {
            return;
        }
        String tag = this.getPrefix(object).concat(object.getClass().getName());
        if (!StopWatch.get(tag).isRunning()) {
            StopWatch.start(tag);
        }
        Counter.inc(tag);
    }

    private String getPrefix(Object object) {
        String prefix = this.tag;
        if (object instanceof IRfNamedElement) {
            prefix = prefix.concat("[NE ] ");
        } else if (object instanceof IRfDefElement) {
            prefix = prefix.concat("[DE ] ");
        } else if (object instanceof Hid) {
            prefix = prefix.concat("[HID] ");
        } else if (object instanceof HidImplicit) {
            prefix = prefix.concat("[HIM] ");
        } else if (object instanceof HidHolder) {
            prefix = prefix.concat("[HH ] ");
        }
        return prefix;
    }

    public void readEnd(Object object) {
        if (!this.fExtendedBenchmark) {
            return;
        }
        String tag = this.getPrefix(object).concat(object.getClass().getName());
        if (StopWatch.get(tag).isRunning()) {
            StopWatch.stop(tag);
        }
    }

    public void start(String string) {
        StopWatch.start(this.tag.concat(string));
    }

    public void stop(String string) {
        StopWatch.stop(this.tag.concat(string));
    }

    public String get(String string) {
        return String.valueOf(StopWatch.get(this.tag.concat(string)).timeMillis()) + " ms";
    }

    public void resetSerdesMetrics() {
        StopWatch.resetAll(this.tag);
        Counter.clearAll(this.tag);
    }

    public void printSerdesMetrics() {
        if (!this.fExtendedBenchmark) {
            return;
        }
        StopWatch.printAll(this.tag);
        Counter.printAll(this.tag);
    }
}

