/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.persistence;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.dvt.utils.DVTExceptionHandler;

public class PersistenceUtils {
    public static final String DB_OUT_OF_SYNC_DIALOG_TITLE = "Include compilation related resources";

    public static boolean openDirtyDialog(IProject project) {
        if (TestHelper.isTestMode()) {
            return false;
        }
        boolean[] isRebuilding = new boolean[]{false};
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "DVT Dirty Dictionary", null, "DVT dictionary is dirty. It is recommended to rebuild '" + project.getName() + "' project for refreshing dictionary, errors etc.", 4, new String[]{"Rebuild Now", "Later"}, 0);
            if (dialog.open() == 0) {
                blArray[0] = true;
            }
        });
        return isRebuilding[0];
    }

    public static void openRebuildDialog(IProject project) {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "DVT Version Changed", null, "DVT version changed. It is recommended to rebuild '" + project.getName() + "' project for refreshing dictionary, errors etc.", 4, new String[]{"Rebuild Now", "Later"}, 0);
            if (dialog.open() == 0) {
                DVTBuildUtils.runInternalBuilder(project);
            }
        });
    }

    public static boolean openIncludeAutoDbOutOfSyncDialog() {
        boolean[] isRebuilding = new boolean[]{false};
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), DB_OUT_OF_SYNC_DIALOG_TITLE, null, "Analyzing the build configuration is required.", 4, new String[]{"Cancel", "Proceed"}, 1);
            if (dialog.open() == 1) {
                blArray[0] = true;
            }
        });
        return isRebuilding[0];
    }

    public static void updateDeprecatedProject(IProject project) {
        DVTNature.updateDeprecatedProject(project);
    }

    public static void reportSavingProject(IProject project) {
        PersistenceUtils.reportSavingProject(project, null);
    }

    public static void reportSavingProject(IProject project, final AtomicBoolean areLibrariesWriting) {
        final Map<String, PersistenceBase> persistenceMap = RfMixedLangManager.getInstance().getPersistenceMap(project);
        Shell shell = Utils.getActiveWorkbenchWindow().getShell();
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);
        shell.getDisplay().asyncExec(() -> {
            try {
                pmd.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("Saving Dictionary ...", -1);
                        boolean isDone = false;
                        while (!isDone) {
                            isDone = true;
                            for (PersistenceBase persistence : persistenceMap.values()) {
                                try {
                                    if (!persistence.isWriteDone()) {
                                        isDone = false;
                                    }
                                    if (!monitor.isCanceled()) continue;
                                    persistence.cancelSave();
                                    if (areLibrariesWriting == null) continue;
                                    areLibrariesWriting.set(false);
                                }
                                catch (Throwable e) {
                                    DVTLogger.INSTANCE.logError(e);
                                }
                            }
                            if (areLibrariesWriting != null && areLibrariesWriting.get() && !monitor.isCanceled()) {
                                isDone = false;
                            }
                            try {
                                Thread.sleep(200L);
                            }
                            catch (Throwable throwable) {}
                            monitor.worked(1);
                        }
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                DVTExceptionHandler.handle(e, shell, "Saving dirty dictionary", "Error saving the dictionary.");
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        });
    }

    public static void reportSavedProject() {
    }
}

