/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.preproc;

import java.util.List;
import ro.amiq.dvt.model.preproc.PreprocDiffManager;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;

public class CompilationPreprocMacroFinder {
    private ParserPath cachedParserPath;
    private List<PreprocDiffManager.PreprocMacro> cachedRegionsList;
    private int cachedRegionsIndex;
    private int cachedOffset;
    private int cachedCompilationOffset;
    private int cachedRegionPadding;

    private CompilationPreprocMacroFinder() {
    }

    protected static CompilationPreprocMacroFinder getInstance() {
        return InstanceHolder.INSTANCE;
    }

    protected int getCompilationOffset(ParserPath parserPath, int offset) {
        if (parserPath == this.cachedParserPath && offset == this.cachedOffset) {
            return this.cachedCompilationOffset;
        }
        if (parserPath == this.cachedParserPath && offset < this.cachedOffset) {
            this.resetCaching(parserPath);
        }
        this.cachedOffset = offset;
        PreprocDiffManager.PreprocMacro preprocMacro = this.findPreprocMacroAtOffset(parserPath, offset);
        if (preprocMacro != null) {
            this.cachedCompilationOffset = preprocMacro.getPStartOffset();
            return this.cachedCompilationOffset;
        }
        this.cachedCompilationOffset = offset - this.cachedRegionPadding;
        return this.cachedCompilationOffset;
    }

    protected boolean isInsidePreprocMacro(ParserPath parserPath, int compilationOffset) {
        if (parserPath != this.cachedParserPath) {
            return false;
        }
        if (this.cachedRegionsList == null || this.cachedRegionsIndex >= this.cachedRegionsList.size()) {
            return false;
        }
        PreprocDiffManager.PreprocMacro preprocMacro = this.cachedRegionsList.get(this.cachedRegionsIndex);
        if (preprocMacro == null) {
            return false;
        }
        return compilationOffset == preprocMacro.getPStartOffset();
    }

    private PreprocDiffManager.PreprocMacro findPreprocMacroAtOffset(ParserPath parserPath, int offset) {
        if (this.cachedParserPath != parserPath) {
            this.resetCaching(parserPath);
        }
        if (this.cachedRegionsList == null) {
            return null;
        }
        int i = this.cachedRegionsIndex;
        while (i < this.cachedRegionsList.size()) {
            PreprocDiffManager.PreprocMacro preprocMacro = this.cachedRegionsList.get(i);
            if (preprocMacro != null) {
                int startOffset = preprocMacro.getPStartOffset() + this.cachedRegionPadding;
                if (startOffset < 0) {
                    DVTLogger.INSTANCE.logError("Preprocessed Files: Error while collecting the position of a preprocessed token!");
                    this.clearCaching();
                    return null;
                }
                int endOffset = startOffset + preprocMacro.getGLength();
                if (offset > endOffset) {
                    this.cachedRegionsIndex = i + 1;
                    this.cachedRegionPadding += this.getPreprocMacroPadding(preprocMacro);
                } else {
                    if (offset >= startOffset) {
                        return preprocMacro;
                    }
                    if (offset < startOffset) {
                        return null;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private int getPreprocMacroPadding(PreprocDiffManager.PreprocMacro preprocMacro) {
        int pLength = preprocMacro.getPLength();
        int gLength = preprocMacro.getGLength();
        if (pLength == 0) {
            gLength += DVTStringUtil.LINE_SEPARATOR.length();
        }
        if (gLength == 0) {
            pLength += DVTStringUtil.LINE_SEPARATOR.length();
        }
        return gLength - pLength;
    }

    private void resetCaching(ParserPath parserPath) {
        this.cachedParserPath = parserPath;
        this.cachedRegionsList = parserPath != null ? PreprocDiffManager.INSTANCE.getPreprocMacros(parserPath.path) : null;
        this.cachedRegionsIndex = 0;
        this.cachedOffset = 0;
        this.cachedCompilationOffset = 0;
        this.cachedRegionPadding = 0;
    }

    protected void clearCaching() {
        this.resetCaching(null);
    }

    private static class InstanceHolder {
        private static final CompilationPreprocMacroFinder INSTANCE = new CompilationPreprocMacroFinder();

        private InstanceHolder() {
        }
    }
}

