/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.preproc;

import java.util.List;
import ro.amiq.dvt.model.preproc.PreprocConstCommon;
import ro.amiq.dvt.model.preproc.PreprocDiffManager;
import ro.amiq.dvt.model.reflection.ParserPath;

public class CursorPreprocMacroFinder {
    private ParserPath cachedParserPath;
    private PreprocDiffManager.PreprocMacro cachedPreprocMacro;

    private CursorPreprocMacroFinder() {
    }

    public static CursorPreprocMacroFinder getInstance() {
        return InstanceHolder.INSTANCE;
    }

    protected PreprocDiffManager.PreprocMacro findPreprocMacroAtOffset(ParserPath pParserPath, int offset, PreprocConstCommon.PreprocFileType fileType) {
        if (pParserPath == null) {
            return null;
        }
        List<PreprocDiffManager.PreprocMacro> regionsList = PreprocDiffManager.INSTANCE.getPreprocMacros(pParserPath.path);
        if (regionsList == null || regionsList.isEmpty()) {
            return null;
        }
        if (this.isCacheHit(pParserPath, offset, fileType)) {
            return this.cachedPreprocMacro;
        }
        int i = 0;
        while (i < regionsList.size()) {
            PreprocDiffManager.PreprocMacro candidate = regionsList.get(i);
            if (offset <= candidate.getEndOffset(fileType)) {
                if (offset < candidate.getStartOffset(fileType)) break;
                this.cachedParserPath = pParserPath;
                this.cachedPreprocMacro = candidate;
                return candidate;
            }
            ++i;
        }
        return null;
    }

    private boolean isCacheHit(ParserPath parserPath, int offset, PreprocConstCommon.PreprocFileType fileType) {
        if (!parserPath.equals(this.cachedParserPath)) {
            return false;
        }
        if (offset < this.cachedPreprocMacro.getStartOffset(fileType)) {
            return false;
        }
        return offset <= this.cachedPreprocMacro.getEndOffset(fileType);
    }

    protected void clearCaching() {
        this.cachedParserPath = null;
        this.cachedPreprocMacro = null;
    }

    protected void clearCaching(String filePath) {
        if (this.cachedParserPath == null) {
            return;
        }
        if (filePath != null && !filePath.equals(this.cachedParserPath.path)) {
            return;
        }
        this.clearCaching();
    }

    private static class InstanceHolder {
        private static final CursorPreprocMacroFinder INSTANCE = new CursorPreprocMacroFinder();

        private InstanceHolder() {
        }
    }
}

