/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.preproc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.utils.DVTStringUtil;

class DiffAlgorithmUtils {
    DiffAlgorithmUtils() {
    }

    protected static int computeShift(int leftStartOffset, int leftEndOffset, int rightStartOffset, int rightEndOffset) {
        if (leftStartOffset == rightStartOffset && leftEndOffset == rightEndOffset) {
            return 0;
        }
        return rightEndOffset - rightStartOffset - leftEndOffset + leftStartOffset;
    }

    protected static DiffPosition computeDiffPosition(int startLine, int noLines, IDocument document, Map<Integer, Integer> nonEmptyIndexMap) throws BadLocationException {
        int documentLength = document.getLength();
        int documentNoOfLines = document.getNumberOfLines();
        int endLine = startLine + noLines;
        if (nonEmptyIndexMap != null) {
            int endNonEmptyLine = startLine + noLines;
            startLine = nonEmptyIndexMap.get(startLine);
            endLine = nonEmptyIndexMap.get(endNonEmptyLine - 1) + 1;
        }
        int startOffset = document.getLineOffset(startLine);
        int endOffset = noLines == 0 ? startOffset : (endLine >= documentNoOfLines ? documentLength - 1 : document.getLineOffset(endLine) - 1);
        return new DiffPosition(startOffset, endOffset);
    }

    protected static NonEmptyContentWrapper computeNonEmptyStringContent(String documentContent) {
        String lineSeparator = DVTStringUtil.LINE_SEPARATOR;
        List<String> documentLines = Arrays.asList(DVTStringUtil.split(DVTStringUtil.NEW_LINE, documentContent, -1));
        int documentNoOfLines = documentLines.size();
        int nonEmptyIndex = 0;
        StringBuilder nonEmptyContentStringBuilder = new StringBuilder();
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < documentNoOfLines) {
            String line = documentLines.get(i);
            if (!"".equals(line.trim())) {
                if (nonEmptyContentStringBuilder.length() != 0) {
                    nonEmptyContentStringBuilder.append(lineSeparator);
                }
                nonEmptyContentStringBuilder.append(line);
                indexMap.put(nonEmptyIndex, i);
                ++nonEmptyIndex;
            }
            ++i;
        }
        nonEmptyContentStringBuilder.append(lineSeparator);
        return new NonEmptyContentWrapper(nonEmptyContentStringBuilder.toString(), indexMap, nonEmptyIndex);
    }

    protected static NonEmptyContentWrapper computeNonEmptyContentLines(String documentContent) {
        List<String> documentLines = Arrays.asList(DVTStringUtil.split(DVTStringUtil.NEW_LINE, documentContent, -1));
        int documentNoOfLines = documentLines.size();
        int nonEmptyIndex = 0;
        ArrayList<String> nonEmptyLines = new ArrayList<String>();
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < documentNoOfLines) {
            String line = documentLines.get(i);
            if (!"".equals(line.trim())) {
                nonEmptyLines.add(line);
                indexMap.put(nonEmptyIndex, i);
                ++nonEmptyIndex;
            }
            ++i;
        }
        return new NonEmptyContentWrapper(nonEmptyLines, indexMap, nonEmptyIndex);
    }

    protected static int computeLineEndingOffset(IDocument document, int line) throws BadLocationException {
        int lineOffset = document.getLineOffset(line);
        int lineLength = document.getLineLength(line);
        int lineDelimiterLength = 0;
        String lineDelimiter = document.getLineDelimiter(line);
        if (lineDelimiter != null) {
            lineDelimiterLength = lineDelimiter.length();
        }
        return lineOffset + lineLength - lineDelimiterLength;
    }

    static class DiffPosition {
        private int startOffset;
        private int endOffset;

        public DiffPosition(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }

    protected static class NonEmptyContentWrapper {
        private String content;
        private List<String> contentLines;
        private HashMap<Integer, Integer> indexMap;
        private int numberOfLines;

        public NonEmptyContentWrapper(String content, HashMap<Integer, Integer> indexMap, int numberOfLines) {
            this.content = content;
            this.indexMap = indexMap;
            this.numberOfLines = numberOfLines;
        }

        public NonEmptyContentWrapper(List<String> contentLines, HashMap<Integer, Integer> indexMap, int numberOfLines) {
            this.contentLines = contentLines;
            this.indexMap = indexMap;
            this.numberOfLines = numberOfLines;
        }

        public String getContent() {
            return this.content;
        }

        public List<String> getContentLines() {
            return this.contentLines;
        }

        public HashMap<Integer, Integer> getIndexMap() {
            return this.indexMap;
        }

        public int getNumberOfLines() {
            return this.numberOfLines;
        }
    }
}

