/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.preproc;

import com.github.difflib.DiffUtils;
import com.github.difflib.algorithm.DiffAlgorithmI;
import com.github.difflib.algorithm.myers.MeyersDiffWithLinearSpace;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.DeleteDelta;
import com.github.difflib.patch.InsertDelta;
import com.github.difflib.patch.Patch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import ro.amiq.dvt.model.preproc.DiffAlgorithmUtils;
import ro.amiq.dvt.model.preproc.DiffRegion;
import ro.amiq.dvt.model.preproc.IDiffAlgorithm;
import ro.amiq.dvt.model.preproc.PreprocDiffManager;
import ro.amiq.dvt.model.preproc.PreprocDiffWrapper;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;

public enum DifflibDiffAlgorithm implements IDiffAlgorithm
{
    INSTANCE;


    @Override
    public List<DiffRegion> computeIncrementalDiff(PreprocDiffWrapper preprocDiffWrapper, IProgressMonitor monitor) throws BadLocationException {
        try {
            String lineSeparator = DVTStringUtil.LINE_SEPARATOR;
            ArrayList<DiffRegion> regions = new ArrayList<DiffRegion>();
            int prevDocNoOfLines = preprocDiffWrapper.getPPrevDocument().getNumberOfLines();
            List<String> pDocumentLines = Arrays.asList(preprocDiffWrapper.getPDocument().get().split(lineSeparator, -1));
            List<String> pPrevDocumentLines = Arrays.asList(preprocDiffWrapper.getPPrevDocument().get().split(lineSeparator, -1));
            Patch p = DiffUtils.diff(pPrevDocumentLines, pDocumentLines, (DiffAlgorithmI)new MeyersDiffWithLinearSpace());
            List deltas = p.getDeltas();
            if (deltas.isEmpty()) {
                return Collections.emptyList();
            }
            for (AbstractDelta delta : deltas) {
                int leftStartLine = delta.getSource().getPosition();
                int leftLengthInLines = delta.getSource().size();
                if (leftStartLine >= prevDocNoOfLines) {
                    leftStartLine = prevDocNoOfLines - 1;
                }
                DiffAlgorithmUtils.DiffPosition leftPosition = DiffAlgorithmUtils.computeDiffPosition(leftStartLine, leftLengthInLines, preprocDiffWrapper.getPPrevDocument(), null);
                int leftStartOffset = leftPosition.getStartOffset();
                int leftEndOffset = leftPosition.getEndOffset();
                int rightStartLine = delta.getTarget().getPosition();
                int rightLengthInLines = delta.getTarget().size();
                DiffAlgorithmUtils.DiffPosition rightPosition = DiffAlgorithmUtils.computeDiffPosition(rightStartLine, rightLengthInLines, preprocDiffWrapper.getPDocument(), null);
                int rightStartOffset = rightPosition.getStartOffset();
                int rightEndOffset = rightPosition.getEndOffset();
                int shiftNoOfChars = DiffAlgorithmUtils.computeShift(leftStartOffset, leftEndOffset, rightStartOffset, rightEndOffset);
                regions.add(new DiffRegion(leftStartOffset, leftEndOffset == leftStartOffset ? leftStartOffset : leftEndOffset - 1, shiftNoOfChars));
            }
            return regions;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<PreprocDiffManager.PreprocMacro> computeFullDiff(PreprocDiffWrapper preprocDiffWrapper, IProgressMonitor monitor) throws BadLocationException {
        try {
            ArrayList<PreprocDiffManager.PreprocMacro> regions = new ArrayList<PreprocDiffManager.PreprocMacro>();
            DiffAlgorithmUtils.NonEmptyContentWrapper pNonEmptyContentWrapper = DiffAlgorithmUtils.computeNonEmptyContentLines(preprocDiffWrapper.getPDocument().get());
            List<String> pNonEmptyLines = pNonEmptyContentWrapper.getContentLines();
            int pNumberOfNonEmptyLines = pNonEmptyContentWrapper.getNumberOfLines();
            DiffAlgorithmUtils.NonEmptyContentWrapper gNonEmptyContentWrapper = DiffAlgorithmUtils.computeNonEmptyContentLines(preprocDiffWrapper.getGDocument().get());
            List<String> gNonEmptyLines = gNonEmptyContentWrapper.getContentLines();
            int gNumberOfNonEmptyLines = gNonEmptyContentWrapper.getNumberOfLines();
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            Patch p = DiffUtils.diff(pNonEmptyLines, gNonEmptyLines, (DiffAlgorithmI)new MeyersDiffWithLinearSpace());
            List deltas = p.getDeltas();
            if (deltas.isEmpty()) {
                return Collections.emptyList();
            }
            AbstractDelta prevDelta = null;
            for (AbstractDelta delta : deltas) {
                PreprocDiffManager.PreprocMacro prevMacro;
                int rightStartNonEmptyLine = delta.getTarget().getPosition();
                if (rightStartNonEmptyLine >= gNumberOfNonEmptyLines) {
                    rightStartNonEmptyLine = gNumberOfNonEmptyLines - 1;
                }
                int rightLengthInLines = delta.getTarget().size();
                DiffAlgorithmUtils.DiffPosition rightPosition = DiffAlgorithmUtils.computeDiffPosition(rightStartNonEmptyLine, rightLengthInLines, preprocDiffWrapper.getGDocument(), gNonEmptyContentWrapper.getIndexMap());
                int rightStartOffset = rightPosition.getStartOffset();
                int rightEndOffset = rightPosition.getEndOffset();
                String gReplacement = preprocDiffWrapper.getGDocument().get(rightStartOffset, rightEndOffset - rightStartOffset);
                if (gReplacement == null) continue;
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                int leftStartNonEmptyLine = delta.getSource().getPosition();
                if (leftStartNonEmptyLine >= pNumberOfNonEmptyLines) {
                    leftStartNonEmptyLine = pNumberOfNonEmptyLines - 1;
                }
                int leftLengthInLines = delta.getSource().size();
                DiffAlgorithmUtils.DiffPosition leftPosition = DiffAlgorithmUtils.computeDiffPosition(leftStartNonEmptyLine, leftLengthInLines, preprocDiffWrapper.getPDocument(), pNonEmptyContentWrapper.getIndexMap());
                int leftStartOffset = leftPosition.getStartOffset();
                int leftEndOffset = leftPosition.getEndOffset();
                if (delta instanceof DeleteDelta && prevDelta != null && prevDelta instanceof InsertDelta && (prevMacro = (PreprocDiffManager.PreprocMacro)regions.get(regions.size() - 1)).getPStartOffset() == leftStartOffset) {
                    gReplacement = prevMacro.getReplacement();
                    regions.remove(regions.size() - 1);
                }
                PreprocDiffManager.PreprocMacro pRegion = new PreprocDiffManager.PreprocMacro(leftStartOffset, leftEndOffset, gReplacement, rightStartOffset, rightEndOffset);
                regions.add(pRegion);
                prevDelta = delta;
            }
            return regions;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.emptyList();
        }
    }
}

