/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.preproc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.compare.internal.DocLineComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import ro.amiq.dvt.model.preproc.DiffAlgorithmUtils;
import ro.amiq.dvt.model.preproc.DiffRegion;
import ro.amiq.dvt.model.preproc.IDiffAlgorithm;
import ro.amiq.dvt.model.preproc.PreprocDiffManager;
import ro.amiq.dvt.model.preproc.PreprocDiffWrapper;

public enum EclipseDiffAlgorithm implements IDiffAlgorithm
{
    INSTANCE;


    @Override
    public List<DiffRegion> computeIncrementalDiff(PreprocDiffWrapper preprocDiffWrapper, IProgressMonitor monitor) throws BadLocationException {
        DocLineComparator leftComparator = new DocLineComparator(preprocDiffWrapper.getPPrevDocument(), null, false);
        DocLineComparator rightComparator = new DocLineComparator(preprocDiffWrapper.getPDocument(), null, false);
        ArrayList<DiffRegion> regionAssociation = new ArrayList<DiffRegion>();
        RangeDifference[] compareDifferences = RangeDifferencer.findDifferences((IProgressMonitor)monitor, null, (IRangeComparator)leftComparator, (IRangeComparator)rightComparator);
        int noOfDiffs = compareDifferences.length;
        if (noOfDiffs == 0) {
            return Collections.emptyList();
        }
        int i = 0;
        while (i < noOfDiffs) {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            RangeDifference diffRegion = compareDifferences[i];
            if (diffRegion != null) {
                int leftStartLine = diffRegion.leftStart();
                int leftLengthInLines = diffRegion.leftLength();
                DiffAlgorithmUtils.DiffPosition leftPosition = DiffAlgorithmUtils.computeDiffPosition(leftStartLine, leftLengthInLines, preprocDiffWrapper.getPPrevDocument(), null);
                int leftStartOffset = leftPosition.getStartOffset();
                int leftEndOffset = leftPosition.getEndOffset();
                int rightStartLine = diffRegion.rightStart();
                int rightLengthInLines = diffRegion.rightLength();
                DiffAlgorithmUtils.DiffPosition rightPosition = DiffAlgorithmUtils.computeDiffPosition(rightStartLine, rightLengthInLines, preprocDiffWrapper.getPDocument(), null);
                int rightStartOffset = rightPosition.getStartOffset();
                int rightEndOffset = rightPosition.getEndOffset();
                int shiftNoOfChars = DiffAlgorithmUtils.computeShift(leftStartOffset, leftEndOffset, rightStartOffset, rightEndOffset);
                regionAssociation.add(new DiffRegion(leftStartOffset, leftEndOffset == leftStartOffset ? leftStartOffset : leftEndOffset - 1, shiftNoOfChars));
            }
            ++i;
        }
        return regionAssociation;
    }

    @Override
    public List<PreprocDiffManager.PreprocMacro> computeFullDiff(PreprocDiffWrapper preprocDiffWrapper, IProgressMonitor monitor) throws BadLocationException {
        DocLineComparator leftComparator = new DocLineComparator(preprocDiffWrapper.getPDocument(), null, false);
        DocLineComparator rightComparator = new DocLineComparator(preprocDiffWrapper.getGDocument(), null, false);
        ArrayList<PreprocDiffManager.PreprocMacro> regionAssociation = new ArrayList<PreprocDiffManager.PreprocMacro>();
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        RangeDifference[] compareDifferences = RangeDifferencer.findDifferences((IProgressMonitor)monitor, null, (IRangeComparator)leftComparator, (IRangeComparator)rightComparator);
        int noOfDiffs = compareDifferences.length;
        if (noOfDiffs == 0) {
            return Collections.emptyList();
        }
        int i = 0;
        while (i < noOfDiffs) {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            RangeDifference diffRegion = compareDifferences[i];
            if (diffRegion != null) {
                int rightStartLine = diffRegion.rightStart();
                int rightLengthInLines = diffRegion.rightLength();
                DiffAlgorithmUtils.DiffPosition rightPosition = DiffAlgorithmUtils.computeDiffPosition(rightStartLine, rightLengthInLines, preprocDiffWrapper.getGDocument(), null);
                int rightStartOffset = rightPosition.getStartOffset();
                int rightEndOffset = rightPosition.getEndOffset();
                String gReplacement = preprocDiffWrapper.getGDocument().get(rightStartOffset, rightEndOffset - rightStartOffset + 1);
                if (gReplacement != null) {
                    if (monitor.isCanceled()) {
                        return Collections.emptyList();
                    }
                    int leftStartLine = diffRegion.leftStart();
                    int leftLengthInLines = diffRegion.leftLength();
                    DiffAlgorithmUtils.DiffPosition leftPosition = DiffAlgorithmUtils.computeDiffPosition(leftStartLine, leftLengthInLines, preprocDiffWrapper.getPDocument(), null);
                    int leftStartOffset = leftPosition.getStartOffset();
                    int leftEndOffset = leftPosition.getEndOffset();
                    if (leftEndOffset < leftStartOffset) {
                        leftEndOffset = leftStartOffset;
                    }
                    PreprocDiffManager.PreprocMacro pRegion = new PreprocDiffManager.PreprocMacro(leftStartOffset, leftEndOffset, gReplacement, rightStartOffset, rightEndOffset);
                    regionAssociation.add(pRegion);
                }
            }
            ++i;
        }
        return regionAssociation;
    }
}

